/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_9306;
import net.minecraft.class_9323;
import net.minecraft.class_9329;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.data.persistence.AbstractDataBuilder;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.common.accessor.world.item.trading.MerchantOfferAccessor;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.Preconditions;

public class SpongeTradeOfferBuilder
extends AbstractDataBuilder<TradeOffer>
implements TradeOffer.Builder,
DataBuilder<TradeOffer> {
    private @MonotonicNonNull ItemStackSnapshot firstItem;
    private @Nullable ItemStackSnapshot secondItem;
    private @MonotonicNonNull ItemStackSnapshot sellingItem;
    private int useCount;
    private int maxUses;
    private boolean allowsExperience;
    private int merchantExperienceGranted;
    private double priceGrowthMultiplier;
    private int demandBonus;

    public SpongeTradeOfferBuilder() {
        super(TradeOffer.class, 1);
        this.reset();
    }

    public TradeOffer.Builder firstBuyingItem(ItemStackLike item) {
        Objects.requireNonNull(item, "Buying item cannot be null");
        this.firstItem = item.asImmutable();
        return this;
    }

    public TradeOffer.Builder secondBuyingItem(ItemStackLike item) {
        this.secondItem = item != null ? item.asImmutable() : ItemStackSnapshot.empty();
        return this;
    }

    public TradeOffer.Builder sellingItem(ItemStackLike item) {
        this.sellingItem = item.asImmutable();
        return this;
    }

    public TradeOffer.Builder uses(int uses) {
        Preconditions.checkArgument(uses >= 0, "Usage count cannot be negative");
        this.useCount = uses;
        return this;
    }

    public TradeOffer.Builder maxUses(int maxUses) {
        Preconditions.checkArgument(maxUses > 0, "Max usage count must be greater than 0");
        this.maxUses = maxUses;
        return this;
    }

    public TradeOffer.Builder canGrantExperience(boolean experience) {
        this.allowsExperience = experience;
        return this;
    }

    public TradeOffer.Builder merchantExperienceGranted(int experience) {
        this.merchantExperienceGranted = experience;
        return this;
    }

    public TradeOffer.Builder priceGrowthMultiplier(double priceGrowthMultiplier) {
        this.priceGrowthMultiplier = priceGrowthMultiplier;
        return this;
    }

    public TradeOffer.Builder demandBonus(int bonus) {
        this.demandBonus = bonus;
        return this;
    }

    public TradeOffer build() throws IllegalStateException {
        Preconditions.checkState(this.firstItem != null, "Trading item has not been set");
        Preconditions.checkState(this.sellingItem != null, "Selling item has not been set");
        Preconditions.checkState(this.useCount <= this.maxUses, String.format("Usage count cannot be greater than the max usage count (%d)", this.maxUses));
        class_1799 first = ItemStackUtil.fromSnapshotToNative(this.firstItem);
        class_1799 second = ItemStackUtil.fromSnapshotToNative(this.secondItem);
        class_1799 selling = ItemStackUtil.fromSnapshotToNative(this.sellingItem);
        class_1914 merchantOffer = new class_1914(SpongeTradeOfferBuilder.itemCostOf(first), second.method_7960() ? Optional.empty() : Optional.ofNullable(second).map(SpongeTradeOfferBuilder::itemCostOf), selling, this.useCount, this.maxUses, this.merchantExperienceGranted, (float)this.priceGrowthMultiplier);
        ((MerchantOfferAccessor)merchantOffer).accessor$rewardExp(this.allowsExperience);
        ((MerchantOfferAccessor)merchantOffer).accessor$demand(this.demandBonus);
        return (TradeOffer)merchantOffer;
    }

    @NotNull
    private static class_9306 itemCostOf(class_1799 stack) {
        return new class_9306(stack.method_41409(), stack.method_7947(), class_9329.method_57865((class_9323)stack.method_57353()), stack);
    }

    public TradeOffer.Builder from(TradeOffer offer) {
        Objects.requireNonNull(offer, "Trade offer cannot be null");
        this.firstItem = offer.firstBuyingItem();
        this.secondItem = offer.secondBuyingItem().orElse(null);
        this.sellingItem = offer.sellingItem();
        this.useCount = offer.uses();
        this.maxUses = offer.maxUses();
        this.allowsExperience = offer.doesGrantExperience();
        this.merchantExperienceGranted = offer.experienceGrantedToMerchant();
        this.priceGrowthMultiplier = offer.priceGrowthMultiplier();
        this.demandBonus = offer.demandBonus();
        return this;
    }

    public SpongeTradeOfferBuilder reset() {
        this.firstItem = null;
        this.secondItem = null;
        this.sellingItem = null;
        this.useCount = 0;
        this.maxUses = 7;
        this.allowsExperience = true;
        this.merchantExperienceGranted = 0;
        this.priceGrowthMultiplier = 0.0;
        this.demandBonus = 0;
        return this;
    }

    protected Optional<TradeOffer> buildContent(DataView container) throws InvalidDataException {
        ItemStack secondItem;
        boolean secondPresent;
        if (!container.contains(Constants.Item.TradeOffer.FIRST_QUERY, new DataQuery[]{Constants.Item.TradeOffer.SECOND_QUERY, Constants.Item.TradeOffer.EXPERIENCE_QUERY, Constants.Item.TradeOffer.MAX_QUERY, Constants.Item.TradeOffer.USES_QUERY, Constants.Item.TradeOffer.BUYING_QUERY})) {
            return Optional.empty();
        }
        ItemStack firstItem = (ItemStack)container.getSerializable(Constants.Item.TradeOffer.FIRST_QUERY, ItemStack.class).get();
        ItemStack buyingItem = (ItemStack)container.getSerializable(Constants.Item.TradeOffer.BUYING_QUERY, ItemStack.class).get();
        if (container.getString(Constants.Item.TradeOffer.SECOND_QUERY).isPresent() && ((String)container.getString(Constants.Item.TradeOffer.SECOND_QUERY).get()).equals("none")) {
            secondPresent = false;
            secondItem = null;
        } else {
            secondPresent = true;
            secondItem = (ItemStack)container.getSerializable(Constants.Item.TradeOffer.SECOND_QUERY, ItemStack.class).get();
        }
        SpongeTradeOfferBuilder builder = new SpongeTradeOfferBuilder();
        builder.firstBuyingItem((ItemStackLike)firstItem);
        if (secondPresent) {
            builder.secondBuyingItem((ItemStackLike)secondItem);
        }
        builder.sellingItem((ItemStackLike)buyingItem).maxUses(((Integer)container.getInt(Constants.Item.TradeOffer.MAX_QUERY).get()).intValue()).uses(((Integer)container.getInt(Constants.Item.TradeOffer.USES_QUERY).get()).intValue()).merchantExperienceGranted(container.getInt(Constants.Item.TradeOffer.EXPERIENCE_GRANTED_TO_MERCHANT_QUERY).orElse(0).intValue()).priceGrowthMultiplier(container.getDouble(Constants.Item.TradeOffer.PRICE_GROWTH_MULTIPLIER_QUERY).orElse(0.0).doubleValue()).demandBonus(container.getInt(Constants.Item.TradeOffer.DEMAND_BONUS_QUERY).orElse(0).intValue());
        return Optional.of(builder.build());
    }
}

