/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.merchant;

import java.util.Objects;
import java.util.random.RandomGenerator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.item.inventory.ItemStackGenerator;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.merchant.TradeOffer;
import org.spongepowered.api.item.merchant.TradeOfferGenerator;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.common.util.Preconditions;

public final class SpongeTradeOfferGenerator
implements TradeOfferGenerator {
    final ItemStackGenerator firstItemGenerator;
    final ItemStackGenerator sellingItemGenerator;
    final @Nullable ItemStackGenerator secondItemGenerator;
    final double experience;
    final VariableAmount baseUses;
    final VariableAmount maxUses;
    final VariableAmount grantedExperience;

    public static Builder builder() {
        return new Builder();
    }

    SpongeTradeOfferGenerator(Builder builder) {
        this.firstItemGenerator = builder.firstGenerator;
        this.secondItemGenerator = builder.secondGenerator;
        this.sellingItemGenerator = builder.sellingGenerator;
        this.experience = builder.experience;
        this.baseUses = builder.baseUses;
        this.maxUses = builder.maxUses;
        this.grantedExperience = builder.grantedExperience == null ? VariableAmount.fixed((double)0.0) : builder.grantedExperience;
    }

    public TradeOffer apply(Entity merchant, RandomProvider.Source random) {
        Objects.requireNonNull(random, "Random cannot be null!");
        TradeOffer.Builder builder = TradeOffer.builder();
        builder.firstBuyingItem((ItemStackLike)this.firstItemGenerator.apply((Object)random));
        if (this.secondItemGenerator != null) {
            builder.secondBuyingItem((ItemStackLike)this.secondItemGenerator.apply((Object)random));
        }
        builder.sellingItem((ItemStackLike)this.sellingItemGenerator.apply((Object)random));
        if (random.nextDouble() < this.experience) {
            builder.merchantExperienceGranted(this.grantedExperience.flooredAmount((RandomGenerator)random));
        }
        builder.uses(this.baseUses.flooredAmount((RandomGenerator)random));
        builder.maxUses(this.maxUses.flooredAmount((RandomGenerator)random));
        return builder.build();
    }

    public static final class Builder
    implements TradeOfferGenerator.Builder {
        @MonotonicNonNull ItemStackGenerator firstGenerator;
        @Nullable ItemStackGenerator secondGenerator;
        @MonotonicNonNull ItemStackGenerator sellingGenerator;
        double experience;
        @MonotonicNonNull VariableAmount baseUses;
        @MonotonicNonNull VariableAmount maxUses;
        @Nullable VariableAmount grantedExperience;

        public TradeOfferGenerator.Builder firstBuyingItemGenerator(ItemStackGenerator generator) {
            this.firstGenerator = Objects.requireNonNull(generator, "ItemStackGenerator cannot be null!");
            return this;
        }

        public TradeOfferGenerator.Builder secondBuyingItemGenerator(@Nullable ItemStackGenerator generator) {
            this.secondGenerator = generator;
            return this;
        }

        public TradeOfferGenerator.Builder sellingItemGenerator(ItemStackGenerator sellingGenerator) {
            this.sellingGenerator = Objects.requireNonNull(sellingGenerator, "ItemStackGenerator cannot be null!");
            return this;
        }

        public TradeOfferGenerator.Builder experienceChance(double experience) {
            this.experience = experience;
            return this;
        }

        public TradeOfferGenerator.Builder grantedExperience(VariableAmount amount) {
            this.grantedExperience = Objects.requireNonNull(amount, "Granted experience cannot be null");
            return this;
        }

        public TradeOfferGenerator.Builder startingUses(VariableAmount amount) {
            this.baseUses = Objects.requireNonNull(amount, "Variable amount cannot be null!");
            return this;
        }

        public TradeOfferGenerator.Builder maxUses(VariableAmount amount) {
            this.maxUses = Objects.requireNonNull(amount, "Variable amount cannot be null!");
            return this;
        }

        public TradeOfferGenerator build() {
            Preconditions.checkState(this.firstGenerator != null, "First item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState(this.sellingGenerator != null, "Selling item populators cannot be empty! Populate with some BiConsumers!");
            Preconditions.checkState(this.baseUses != null);
            Preconditions.checkState(this.maxUses != null);
            return new SpongeTradeOfferGenerator(this);
        }

        public TradeOfferGenerator.Builder from(TradeOfferGenerator value) {
            this.reset();
            if (value instanceof SpongeTradeOfferGenerator) {
                SpongeTradeOfferGenerator generator = (SpongeTradeOfferGenerator)value;
                this.firstGenerator = generator.firstItemGenerator;
                this.secondGenerator = generator.secondItemGenerator;
                this.sellingGenerator = generator.sellingItemGenerator;
                this.experience = generator.experience;
                this.baseUses = generator.baseUses;
                this.maxUses = generator.maxUses;
                return this;
            }
            throw new IllegalArgumentException("The provided TradeOfferGenerator is incompatible with the current implementation!");
        }

        public TradeOfferGenerator.Builder reset() {
            this.firstGenerator = null;
            this.secondGenerator = null;
            this.sellingGenerator = null;
            this.experience = 0.5;
            this.baseUses = null;
            this.maxUses = null;
            this.grantedExperience = null;
            return this;
        }
    }
}

