/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_2119;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8566;
import net.minecraft.class_8779;
import net.minecraft.class_9695;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public abstract class SpongeRecipeRegistration<R extends class_1860<? extends class_9695>>
implements RecipeRegistration {
    private static final Gson GSON = new Gson();
    protected final class_2960 key;
    protected final class_1865<? extends R> serializer;
    protected final class_8779 advancement;
    protected final String group;
    protected final DataPack<RecipeRegistration> pack;

    public SpongeRecipeRegistration(class_2960 key, String group, DataPack<RecipeRegistration> pack, class_7800 recipeCategory, class_1865<? extends R> serializer) {
        this.key = key;
        this.serializer = serializer;
        this.pack = pack;
        class_5321 rKey = class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)key);
        this.advancement = class_161.class_162.method_707().method_705("has_the_recipe", class_2119.method_27847((class_5321)rKey)).method_703(class_170.class_171.method_753((class_5321)rKey)).method_695(class_2960.method_60655((String)key.method_12836(), (String)("recipes/" + recipeCategory.method_46203() + "/" + key.method_12832())));
        this.group = group == null ? "" : group;
    }

    public static <R extends class_1860<I>, I extends class_9695> class_1865<? extends R> determineSerializer(class_1799 resultStack, Function<I, class_1799> resultFunction, Function<class_8566, class_2371<class_1799>> remainingItemsFunction, Collection<class_1856> ingredients, class_1865<R> vanilla, class_1865<? extends R> sponge) {
        if (!resultStack.method_57353().method_57837() || resultFunction != null || remainingItemsFunction != null) {
            return sponge;
        }
        for (class_1856 value : ingredients) {
            if (!(value instanceof SpongeIngredient)) continue;
            return sponge;
        }
        return vanilla;
    }

    public static <I extends class_9695> boolean isVanillaSerializer(class_1799 resultStack, Function<I, class_1799> resultFunction, Function<I, class_2371<class_1799>> remainingItemsFunction, Collection<class_1856> ingredients) {
        if (!resultStack.method_57353().method_57837() || resultFunction != null || remainingItemsFunction != null) {
            return false;
        }
        return ingredients.stream().noneMatch(value -> value instanceof SpongeIngredient);
    }

    public ResourceKey key() {
        return (ResourceKey)this.key;
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        JsonElement json = (JsonElement)class_1860.field_47319.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_1860)this.recipe())).result().get();
        try {
            return ((StringDataFormat)DataFormats.JSON.get()).read(GSON.toJson(json));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public DataPack<RecipeRegistration> pack() {
        return this.pack;
    }

    protected void ensureCached() {
        SpongeRecipeRegistration spongeRecipeRegistration = this;
        if (spongeRecipeRegistration instanceof ResultFunctionRegistration) {
            ResultFunctionRegistration rfr = (ResultFunctionRegistration)((Object)spongeRecipeRegistration);
            IngredientResultUtil.cacheResultFunction(this.key, rfr.resultFunction());
        }
        if ((spongeRecipeRegistration = this) instanceof RemainingItemsFunctionRegistration) {
            RemainingItemsFunctionRegistration rifr = (RemainingItemsFunctionRegistration)((Object)spongeRecipeRegistration);
            IngredientResultUtil.cacheRemainingItemsFunction(this.key, rifr.remainingItems());
        }
    }

    public class_8779 advancement() {
        return this.advancement;
    }

    public static JsonObject encode(RecipeRegistration template, class_5455 access) {
        try {
            class_6903 ops;
            DataResult encoded;
            if (template instanceof SpongeRecipeRegistration) {
                SpongeRecipeRegistration srr = (SpongeRecipeRegistration)template;
                srr.ensureCached();
            }
            if ((encoded = class_1860.field_47319.encodeStart((DynamicOps)(ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)access)), (Object)((class_1860)template.recipe()))).result().isPresent()) {
                return ((JsonElement)encoded.result().get()).getAsJsonObject();
            }
            DataResult.Error error = (DataResult.Error)encoded.error().get();
            throw new RuntimeException(error.message());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not encode recipe " + String.valueOf(template.key()), e);
        }
    }

    public static interface ResultFunctionRegistration<I extends class_9695> {
        public Function<I, class_1799> resultFunction();
    }

    public static interface RemainingItemsFunctionRegistration<I extends class_9695> {
        public Function<I, class_2371<class_1799>> remainingItems();
    }
}

