/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.cooking;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1874;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_7709;
import net.minecraft.class_7800;
import net.minecraft.class_9696;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.common.item.recipe.SpongeRecipeRegistration;
import org.spongepowered.common.item.recipe.cooking.SpongeBlastingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeCampfireCookingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmeltingRecipe;
import org.spongepowered.common.item.recipe.cooking.SpongeSmokingRecipe;
import org.spongepowered.common.util.SpongeTicks;

public class SpongeCookingRecipeRegistration
extends SpongeRecipeRegistration<class_1874>
implements SpongeRecipeRegistration.ResultFunctionRegistration<class_9696> {
    private final class_1856 ingredient;
    private final float experience;
    private final Ticks cookingTime;
    private final class_1799 spongeResult;
    private final Function<class_9696, class_1799> resultFunction;
    private final class_3956<?> type;
    private final class_7709 cookingCategory;

    public SpongeCookingRecipeRegistration(class_2960 key, class_3956<?> type, class_1865<? extends class_1874> serializer, String group, class_1856 ingredient, float experience, Ticks cookingTime, class_1799 spongeResult, Function<class_9696, class_1799> resultFunction, DataPack<RecipeRegistration> pack, class_7800 category, class_7709 cookingCategory) {
        super(key, group, pack, category, serializer);
        this.type = type;
        this.ingredient = ingredient;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.spongeResult = spongeResult;
        this.resultFunction = resultFunction;
        this.cookingCategory = cookingCategory;
    }

    public static SpongeCookingRecipeRegistration of(class_2960 key, class_3956<?> type, @Nullable String group, class_1856 ingredient, Float experience, @Nullable Ticks cookingTime, class_1799 result, Function<class_9696, class_1799> resultFunction, DataPack<RecipeRegistration> pack, class_7800 recipeCategory, class_7709 cookingCategory) {
        class_1865 serializer;
        Ticks finalCookingTime = cookingTime;
        if (type == class_3956.field_17547) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of((long)100L);
            }
            serializer = class_1865.field_17084;
        } else if (type == class_3956.field_17549) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of((long)600L);
            }
            serializer = class_1865.field_17347;
        } else if (type == class_3956.field_17548) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of((long)100L);
            }
            serializer = class_1865.field_17085;
        } else if (type == class_3956.field_17546) {
            if (finalCookingTime == null) {
                finalCookingTime = Ticks.of((long)200L);
            }
            serializer = class_1865.field_9042;
        } else {
            throw new IllegalArgumentException("Unknown RecipeType " + String.valueOf(type));
        }
        return new SpongeCookingRecipeRegistration(key, type, (class_1865<? extends class_1874>)serializer, group, ingredient, experience == null ? 0.0f : experience.floatValue(), finalCookingTime, result, resultFunction, pack, recipeCategory, cookingCategory);
    }

    public Recipe recipe() {
        this.ensureCached();
        int ticksCookingTime = SpongeTicks.toSaturatedIntOrInfinite(this.cookingTime);
        String resultFunctionId = this.resultFunction == null ? null : this.key.toString();
        List<class_1856> ingredientList = Collections.singletonList(this.ingredient);
        boolean isVanilla = SpongeRecipeRegistration.isVanillaSerializer(this.spongeResult, this.resultFunction, null, ingredientList);
        if (this.type == class_3956.field_17547) {
            if (!isVanilla) {
                return (CookingRecipe)new SpongeBlastingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId);
            }
            return (CookingRecipe)new class_3859(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == class_3956.field_17549) {
            if (!isVanilla) {
                return (CookingRecipe)new SpongeCampfireCookingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId);
            }
            return (CookingRecipe)new class_3920(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == class_3956.field_17548) {
            if (!isVanilla) {
                return (CookingRecipe)new SpongeSmokingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId);
            }
            return (CookingRecipe)new class_3862(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        if (this.type == class_3956.field_17546) {
            if (!isVanilla) {
                return (CookingRecipe)new SpongeSmeltingRecipe(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime, resultFunctionId);
            }
            return (CookingRecipe)new class_3861(this.group, this.cookingCategory, this.ingredient, this.spongeResult, this.experience, ticksCookingTime);
        }
        throw new IllegalArgumentException("Unknown RecipeType " + String.valueOf(this.type));
    }

    @Override
    public Function<class_9696, class_1799> resultFunction() {
        return this.resultFunction;
    }
}

