/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shaped;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_8957;
import net.minecraft.class_9694;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.item.recipe.crafting.ShapedCraftingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.crafting.shaped.SpongeShapedCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public final class SpongeShapedCraftingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, ShapedCraftingRecipe.Builder>
implements ShapedCraftingRecipe.Builder,
ShapedCraftingRecipe.Builder.AisleStep.ResultStep,
ShapedCraftingRecipe.Builder.RowsStep.ResultStep,
ShapedCraftingRecipe.Builder.EndStep {
    private List<String> aisle = Lists.newArrayList();
    private final Map<Character, Ingredient> ingredientMap = new Char2ObjectArrayMap();
    private final Map<Ingredient, Character> reverseIngredientMap = new IdentityHashMap<Ingredient, Character>();
    private ItemStack result = ItemStack.empty();
    private Function<class_9694, class_2371<class_1799>> remainingItemsFunction;
    private Function<class_9694, class_1799> resultFunction;
    private String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private class_7800 recipeCategory = class_7800.field_40642;
    private class_7710 craftingBookCategory = class_7710.field_40251;

    public ShapedCraftingRecipe.Builder.AisleStep aisle(String ... aisle) {
        Objects.requireNonNull(aisle, "aisle");
        this.aisle.clear();
        this.ingredientMap.clear();
        this.reverseIngredientMap.clear();
        Collections.addAll(this.aisle, aisle);
        return this;
    }

    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(char symbol, Ingredient ingredient) throws IllegalArgumentException {
        if (this.aisle.stream().noneMatch(row -> row.indexOf(symbol) >= 0)) {
            throw new IllegalArgumentException("The symbol '" + symbol + "' is not defined in the aisle pattern.");
        }
        this.ingredientMap.put(Character.valueOf(symbol), ingredient == null ? Ingredient.empty() : ingredient);
        this.reverseIngredientMap.put(ingredient, Character.valueOf(symbol));
        return this;
    }

    public ShapedCraftingRecipe.Builder.AisleStep.ResultStep where(Map<Character, Ingredient> ingredientMap) throws IllegalArgumentException {
        for (Map.Entry<Character, Ingredient> entry : ingredientMap.entrySet()) {
            this.where(entry.getKey().charValue(), entry.getValue());
        }
        return this;
    }

    public ShapedCraftingRecipe.Builder.RowsStep rows() {
        this.aisle.clear();
        this.ingredientMap.clear();
        return this;
    }

    public ShapedCraftingRecipe.Builder.RowsStep.ResultStep row(int skip, Ingredient ... ingredients) {
        int columns = ingredients.length + skip;
        if (!this.aisle.isEmpty()) {
            Preconditions.checkState(this.aisle.get(0).length() == columns, "The rows have an inconsistent width.");
        }
        StringBuilder row = new StringBuilder();
        for (int i = 0; i < skip; ++i) {
            row.append(" ");
        }
        int key = 65 + columns * this.aisle.size();
        for (Ingredient ingredient : ingredients) {
            Character usedKey = this.reverseIngredientMap.get(ingredient);
            if (usedKey == null) {
                usedKey = Character.valueOf((char)key);
                ++key;
            }
            row.append(usedKey);
            this.ingredientMap.put(usedKey, ingredient);
            this.reverseIngredientMap.put(ingredient, usedKey);
        }
        this.aisle.add(row.toString());
        return this;
    }

    public ShapedCraftingRecipe.Builder.ResultStep remainingItems(Function<RecipeInput.Crafting, ? extends List<? extends ItemStackLike>> remainingItemsFunction) {
        this.remainingItemsFunction = grid -> {
            class_2371 mcList = class_2371.method_10211();
            ((List)remainingItemsFunction.apply(InventoryUtil.toSponge(grid))).forEach(stack -> mcList.add((Object)ItemStackUtil.fromLikeToNative(stack)));
            return mcList;
        };
        return this;
    }

    public ShapedCraftingRecipe.Builder.EndStep result(ItemStackLike result) {
        Objects.requireNonNull(result, "result");
        this.result = result.asMutableCopy();
        this.resultFunction = null;
        return this;
    }

    public ShapedCraftingRecipe.Builder.EndStep result(Function<RecipeInput.Crafting, ? extends ItemStackLike> resultFunction, ItemStackLike exemplaryResult) {
        this.resultFunction = inv -> ItemStackUtil.fromLikeToNative((ItemStackLike)resultFunction.apply(InventoryUtil.toSponge(inv)));
        this.result = exemplaryResult.asMutableCopy();
        return this;
    }

    public ShapedCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public ShapedCraftingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        Preconditions.checkState(!this.aisle.isEmpty(), "aisle has not been set");
        Preconditions.checkState(!this.ingredientMap.isEmpty(), "no ingredients set");
        Preconditions.checkState(!this.result.isEmpty(), "no result set");
        Iterator<String> aisleIterator = this.aisle.iterator();
        String aisleRow = aisleIterator.next();
        int width = aisleRow.length();
        Preconditions.checkState(width > 0, "The aisle cannot be empty.");
        while (aisleIterator.hasNext()) {
            aisleRow = aisleIterator.next();
            Preconditions.checkState(aisleRow.length() == width, "The aisle has an inconsistent width.");
        }
        Map<Character, class_1856> ingredientsMap = this.ingredientMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> IngredientUtil.toNative((Ingredient)e.getValue())));
        class_8957 pattern = class_8957.method_55085(ingredientsMap, this.aisle);
        return new SpongeShapedCraftingRecipeRegistration((class_2960)this.key, this.group, pattern, ItemStackUtil.toNative(this.result), this.resultFunction, this.remainingItemsFunction, this.pack, this.recipeCategory, this.craftingBookCategory);
    }

    public ShapedCraftingRecipe.Builder reset() {
        super.reset();
        this.aisle = new ArrayList<String>();
        this.ingredientMap.clear();
        this.result = ItemStack.empty();
        this.resultFunction = null;
        this.group = null;
        this.remainingItemsFunction = null;
        this.pack = DataPacks.RECIPE;
        return this;
    }
}

