/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_9694;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.item.recipe.crafting.ShapelessCraftingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.crafting.shapeless.SpongeShapelessCraftingRecipeRegistration;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public class SpongeShapelessCraftingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, ShapelessCraftingRecipe.Builder>
implements ShapelessCraftingRecipe.Builder.EndStep,
ShapelessCraftingRecipe.Builder.ResultStep {
    private ItemStack result;
    private Function<class_9694, class_1799> resultFunction;
    private Function<class_9694, class_2371<class_1799>> remainingItemsFunction;
    private final class_2371<class_1856> ingredients = class_2371.method_10211();
    private String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private class_7800 recipeCategory = class_7800.field_40642;
    private class_7710 craftingBookCategory = class_7710.field_40251;

    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(ItemType ... ingredients) {
        for (ItemType ingredient : ingredients) {
            this.ingredients.add((Object)class_1856.method_8101(() -> (class_1792)ingredient));
        }
        return this;
    }

    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(Supplier<? extends ItemType> ... ingredients) {
        for (Supplier<? extends ItemType> ingredient : ingredients) {
            this.ingredients.add((Object)class_1856.method_8101(() -> (class_1792)ingredient.get()));
        }
        return this;
    }

    public ShapelessCraftingRecipe.Builder.ResultStep addIngredients(Ingredient ... ingredients) {
        for (Ingredient ingredient : ingredients) {
            this.ingredients.add((Object)IngredientUtil.toNative(ingredient));
        }
        return this;
    }

    public ShapelessCraftingRecipe.Builder.ResultStep remainingItems(Function<RecipeInput.Crafting, ? extends List<? extends ItemStackLike>> remainingItemsFunction) {
        this.remainingItemsFunction = grid -> {
            class_2371 mcList = class_2371.method_10211();
            ((List)remainingItemsFunction.apply(InventoryUtil.toSponge(grid))).forEach(stack -> mcList.add((Object)ItemStackUtil.fromLikeToNative(stack)));
            return mcList;
        };
        return this;
    }

    public ShapelessCraftingRecipe.Builder.EndStep result(ItemStackLike result) {
        Objects.requireNonNull(result, "result");
        this.result = result.asMutable();
        this.resultFunction = null;
        return this;
    }

    public ShapelessCraftingRecipe.Builder.EndStep result(Function<RecipeInput.Crafting, ? extends ItemStackLike> resultFunction, ItemStackLike exemplaryResult) {
        this.resultFunction = input -> ItemStackUtil.fromLikeToNative((ItemStackLike)resultFunction.apply(InventoryUtil.toSponge(input)));
        this.result = exemplaryResult.asMutableCopy();
        return this;
    }

    public ShapelessCraftingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public ShapelessCraftingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        Preconditions.checkState(!this.ingredients.isEmpty(), "The ingredients are not set.");
        return new SpongeShapelessCraftingRecipeRegistration((class_2960)this.key, this.group, (List<class_1856>)this.ingredients, ItemStackUtil.toNative(this.result), this.resultFunction, this.remainingItemsFunction, this.pack, this.recipeCategory, this.craftingBookCategory);
    }

    public ShapelessCraftingRecipe.Builder reset() {
        super.reset();
        this.result = null;
        this.resultFunction = null;
        this.ingredients.clear();
        this.group = null;
        this.remainingItemsFunction = null;
        this.pack = DataPacks.RECIPE;
        return this;
    }
}

