/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.crafting.shapeless;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import org.spongepowered.common.accessor.world.item.crafting.ShapelessRecipeAccessor;
import org.spongepowered.common.bridge.world.item.crafting.RecipeResultBridge;
import org.spongepowered.common.item.recipe.ingredient.IngredientResultUtil;
import org.spongepowered.common.item.recipe.ingredient.SpongeIngredient;

public class SpongeShapelessRecipe
extends class_1867 {
    public static final MapCodec<SpongeShapelessRecipe> SPONGE_CODEC = RecordCodecBuilder.mapCodec($$0 -> $$0.group((App)Codec.STRING.fieldOf("sponge:type").forGetter(t -> "custom"), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(class_1867::method_8112), (App)class_7710.field_40252.fieldOf("category").orElse((Object)class_7710.field_40251).forGetter(class_1867::method_45441), (App)class_1799.field_24671.fieldOf("result").forGetter($$0x -> ((RecipeResultBridge)((Object)$$0x)).bridge$result()), (App)class_1856.field_46095.listOf(1, 9).fieldOf("ingredients").forGetter(sr -> ((ShapelessRecipeAccessor)((Object)sr)).accessor$ingredients()), (App)IngredientResultUtil.CACHED_RESULT_FUNC_CODEC.optionalFieldOf("sponge:result_function").forGetter(SpongeShapelessRecipe::resultFunctionId), (App)IngredientResultUtil.CACHED_REMAINING_FUNC_CODEC.optionalFieldOf("sponge:remaining_items").forGetter(SpongeShapelessRecipe::remainingItemsFunctionId)).apply((Applicative)$$0, SpongeShapelessRecipe::of));
    private final boolean onlyVanillaIngredients;
    private final String resultFunctionId;
    private final String remainingItemsFunctionId;

    public static SpongeShapelessRecipe of(String spongeType, String groupIn, class_7710 category, class_1799 recipeOutputIn, List<class_1856> recipeItemsIn, Optional<String> resultFunctionId, Optional<String> remainingItemsFunctionId) {
        return new SpongeShapelessRecipe(groupIn, category, recipeItemsIn, recipeOutputIn, resultFunctionId.orElse(null), remainingItemsFunctionId.orElse(null));
    }

    public SpongeShapelessRecipe(String groupIn, class_7710 category, List<class_1856> recipeItemsIn, class_1799 spongeResultStack, String resultFunctionId, String remainingItemsFunctionId) {
        super(groupIn, category, spongeResultStack, recipeItemsIn);
        this.onlyVanillaIngredients = recipeItemsIn.stream().noneMatch(i -> i instanceof SpongeIngredient);
        this.resultFunctionId = resultFunctionId;
        this.remainingItemsFunctionId = remainingItemsFunctionId;
    }

    public Optional<String> resultFunctionId() {
        return Optional.ofNullable(this.resultFunctionId);
    }

    public Optional<String> remainingItemsFunctionId() {
        return Optional.ofNullable(this.remainingItemsFunctionId);
    }

    public boolean method_17730(class_9694 $$0, class_1937 $$1) {
        if (this.onlyVanillaIngredients) {
            return super.method_17730($$0, $$1);
        }
        return SpongeShapelessRecipe.matches($$0.method_59989(), ((ShapelessRecipeAccessor)((Object)this)).accessor$ingredients());
    }

    public class_2371<class_1799> method_17704(class_9694 $$0) {
        if (this.remainingItemsFunctionId != null) {
            return IngredientResultUtil.cachedRemainingItemsFunction(this.remainingItemsFunctionId).apply($$0);
        }
        return super.method_17704($$0);
    }

    public class_1799 method_17729(class_9694 $$0, class_7225.class_7874 $$1) {
        if (this.resultFunctionId != null) {
            return IngredientResultUtil.cachedResultFunction(this.resultFunctionId).apply($$0);
        }
        return super.method_17729($$0, $$1);
    }

    private static boolean matches(List<class_1799> stacks, List<class_1856> ingredients) {
        int elements = ingredients.size();
        if (stacks.size() < elements) {
            return false;
        }
        HashMap<Integer, List> matchesMap = new HashMap<Integer, List>();
        for (int i = 0; i < ingredients.size(); ++i) {
            class_1856 ingredient = ingredients.get(i);
            boolean noMatch = true;
            for (int j = 0; j < stacks.size(); ++j) {
                if (!ingredient.method_8093(stacks.get(j))) continue;
                matchesMap.computeIfAbsent(j, k -> new ArrayList()).add(i);
                noMatch = false;
            }
            if (!noMatch) continue;
            return false;
        }
        if (matchesMap.isEmpty()) {
            return false;
        }
        ArrayList<Collection<Integer>> stackList = new ArrayList<Collection<Integer>>(matchesMap.values());
        stackList.sort(Comparator.comparingInt(Collection::size));
        return SpongeShapelessRecipe.matchesRecursive(stackList, 0, new HashSet<Integer>());
    }

    private static boolean matchesRecursive(List<Collection<Integer>> stackList, int d, Set<Integer> used) {
        if (d == stackList.size()) {
            return true;
        }
        Collection<Integer> stacks = stackList.get(d);
        for (Integer stack : stacks) {
            if (used.contains(stack)) continue;
            HashSet<Integer> copy = new HashSet<Integer>(used);
            copy.add(stack);
            if (!SpongeShapelessRecipe.matchesRecursive(stackList, d + 1, copy)) continue;
            return true;
        }
        return false;
    }
}

