/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.text.MessageFormat;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.common.SpongeCommon;

public final class IngredientResultUtil {
    private static final Map<String, Function<?, class_1799>> cachedResultFunctions = new Object2ObjectOpenHashMap();
    private static final Map<String, Function<?, class_2371<class_1799>>> cachedRemainingItemsFunctions = new Object2ObjectOpenHashMap();
    public static final Codec<String> CACHED_RESULT_FUNC_CODEC = Codec.STRING.flatXmap(id -> IngredientResultUtil.cachedResultFunction(id) != null ? DataResult.success((Object)id) : DataResult.error(() -> "Missing Result Function for id " + id), DataResult::success);
    public static final Codec<String> CACHED_REMAINING_FUNC_CODEC = Codec.STRING.flatXmap(id -> IngredientResultUtil.cachedRemainingItemsFunction(id) != null ? DataResult.success((Object)id) : DataResult.error(() -> "Missing Result Function for id " + id), DataResult::success);

    public static JsonElement serializeItemStack(class_1799 spongeResult) {
        DataResult encoded = class_1799.field_24671.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)spongeResult);
        return (JsonElement)encoded.result().get();
    }

    public static <I extends class_9695> @Nullable Function<I, class_1799> cachedResultFunction(String id) {
        return cachedResultFunctions.get(id);
    }

    public static <C extends class_1263> String cacheResultFunction(class_2960 id, Function<C, class_1799> resultFunction) {
        if (cachedResultFunctions.put(id.toString(), resultFunction) != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Duplicate cache result registration! " + String.valueOf(id) + " was replaced.", new Object[0]));
        }
        return id.toString();
    }

    public static <I extends class_9694> @Nullable Function<I, class_2371<class_1799>> cachedRemainingItemsFunction(String id) {
        return cachedRemainingItemsFunctions.get(id);
    }

    public static <C extends class_1263> String cacheRemainingItemsFunction(class_2960 id, Function<C, class_2371<class_1799>> resultFunction) {
        if (cachedRemainingItemsFunctions.put(id.toString(), resultFunction) != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Duplicate cache result registration! " + String.valueOf(id) + " was replaced.", new Object[0]));
        }
        return id.toString();
    }

    public static void clearCache() {
        cachedResultFunctions.clear();
        cachedRemainingItemsFunctions.clear();
    }
}

