/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.ingredient;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_10302;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import org.apache.commons.lang3.NotImplementedException;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.item.recipe.ingredient.SpongeItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongePredicateItemList;
import org.spongepowered.common.item.recipe.ingredient.SpongeStackItemList;
import org.spongepowered.common.item.util.ItemStackUtil;

public class SpongeIngredient
extends class_1856 {
    private static final Codec<class_1799> LEGACY_STACK_CODEC = RecordCodecBuilder.create(b -> b.group((App)class_7923.field_41178.method_39673().fieldOf("ItemType").forGetter(class_1799::method_7909), (App)Codec.INT.fieldOf("Count").forGetter(class_1799::method_7947)).apply((Applicative)b, (type, qty) -> {
        SpongeCommon.logger().info("Found legacy recipe");
        return new class_1799((class_1935)type, qty.intValue());
    }));
    private static final Codec<class_1799> STACK_CODEC = Codec.xor((Codec)class_1799.field_24671, LEGACY_STACK_CODEC).xmap(to -> (class_1799)to.map(i -> i, i -> i), Either::left);
    private static final Codec<SpongeRawIngredient> RAW_CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.optionalFieldOf("sponge:type", (Object)"vanilla").forGetter(raw -> raw.type), (App)Codec.list(STACK_CODEC).optionalFieldOf("sponge:item", List.of()).forGetter(raw -> raw.stacks), (App)Codec.STRING.optionalFieldOf("sponge:predicate").forGetter(raw -> raw.predicateId)).apply((Applicative)builder, SpongeRawIngredient::new));
    public static final Codec<SpongeIngredient> CODEC = RAW_CODEC.flatXmap(raw -> {
        switch (raw.type) {
            case "vanilla": {
                return DataResult.error(() -> "Vanilla Ingredient");
            }
            case "sponge:stack": {
                SpongeStackItemList spongeStackItemList = new SpongeStackItemList(raw.stacks.toArray(new class_1799[0]));
                SpongeIngredient ingredient = new SpongeIngredient(raw.type, spongeStackItemList, null);
                return DataResult.success((Object)((Object)ingredient));
            }
            case "sponge:predicate": {
                if (raw.predicateId.isEmpty()) {
                    return DataResult.error(() -> "Missing sponge:predicate for custom ingredient of type " + raw.type);
                }
                Predicate<class_1799> predicate = SpongeIngredient.cachedPredicate(raw.predicateId.get());
                if (predicate == null) {
                    return DataResult.error(() -> "Could not find predicate for custom ingredient with id " + raw.predicateId.get());
                }
                SpongePredicateItemList predicateList = new SpongePredicateItemList(raw.predicateId.get(), predicate, raw.stacks.toArray(new class_1799[0]));
                SpongeIngredient ingredient = new SpongeIngredient(raw.type, predicateList, raw.predicateId.orElse(null));
                return DataResult.success((Object)((Object)ingredient));
            }
        }
        return DataResult.error(() -> "Unknown ingredient type " + raw.type);
    }, spongeIngredient -> {
        switch (spongeIngredient.type) {
            case "sponge:stack": {
                List<class_1799> stacks = Arrays.asList(spongeIngredient.itemList.stacks);
                return DataResult.success((Object)new SpongeRawIngredient(spongeIngredient.type, stacks, Optional.empty()));
            }
            case "sponge:predicate": {
                List<class_1799> stacks = Arrays.asList(spongeIngredient.itemList.stacks);
                return DataResult.success((Object)new SpongeRawIngredient(spongeIngredient.type, stacks, Optional.ofNullable(spongeIngredient.predicateId)));
            }
        }
        throw new NotImplementedException("Serializing SpongeIngredient is not implemented yet.");
    });
    public final String type;
    public final String predicateId;
    private final SpongeItemList itemList;
    private static final Map<String, Predicate<class_1799>> cachedPredicates = new HashMap<String, Predicate<class_1799>>();

    public SpongeIngredient(String type, SpongeItemList itemList, String predicateId) {
        super((class_6885)class_6885.method_40242(itemList.method_40239().toList()));
        this.type = type;
        this.predicateId = predicateId;
        this.itemList = itemList;
    }

    public static void clearCache() {
        cachedPredicates.clear();
    }

    public boolean method_8093(class_1799 testStack) {
        if (testStack == null) {
            return false;
        }
        return this.itemList.test(testStack);
    }

    public class_10302 method_64673() {
        return new class_10302.class_10304(this.itemList.getItems().stream().map(class_10302.class_10307::new).map(class_10302.class::cast).toList());
    }

    public static SpongeIngredient spongeFromStacks(class_1799 ... stacks) {
        SpongeStackItemList itemList = new SpongeStackItemList(stacks);
        return new SpongeIngredient("sponge:stack", itemList, null);
    }

    public static SpongeIngredient spongeFromPredicate(ResourceKey key, Predicate<? super ItemStackLike> predicate, class_1799 ... exemplaryIngredients) {
        Predicate<class_1799> mcPredicate = stack -> predicate.test((ItemStackLike)ItemStackUtil.fromNative(stack));
        Predicate<class_1799> registeredPredicate = cachedPredicates.get(key.toString());
        if (registeredPredicate instanceof WrappedPredicate) {
            WrappedPredicate wrapped = (WrappedPredicate)registeredPredicate;
            wrapped.setPredicate(mcPredicate);
        } else if (registeredPredicate != null) {
            SpongeCommon.logger().warn(MessageFormat.format("Predicate ingredient registered twice! {} was replaced.", key.toString()));
        } else {
            cachedPredicates.put(key.toString(), mcPredicate);
        }
        SpongePredicateItemList itemList = new SpongePredicateItemList(key.toString(), mcPredicate, exemplaryIngredients);
        return new SpongeIngredient("sponge:predicate", itemList, key.toString());
    }

    public static Predicate<class_1799> cachedPredicate(String id) {
        return cachedPredicates.computeIfAbsent(id, k -> new WrappedPredicate(id));
    }

    public static class WrappedPredicate
    implements Predicate<class_1799> {
        private final String key;
        private Predicate<class_1799> predicate;

        public WrappedPredicate(String key) {
            this.key = key;
        }

        public void setPredicate(Predicate<class_1799> predicate) {
            this.predicate = predicate;
        }

        @Override
        public boolean test(class_1799 itemStack) {
            if (this.predicate == null) {
                SpongeCommon.logger().error(this.key + " ingredient predicate was not registered. Is the plugin loaded?");
                return false;
            }
            return this.predicate.test(itemStack);
        }
    }

    record SpongeRawIngredient(String type, List<class_1799> stacks, Optional<String> predicateId) {
    }
}

