/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.recipe.smithing;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_7800;
import net.minecraft.class_9697;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.datapack.DataPack;
import org.spongepowered.api.datapack.DataPacks;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.recipe.RecipeRegistration;
import org.spongepowered.api.item.recipe.crafting.Ingredient;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.item.recipe.smithing.SmithingRecipe;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.recipe.ingredient.IngredientUtil;
import org.spongepowered.common.item.recipe.smithing.SpongeSmithingRecipeRegistration;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.AbstractResourceKeyedBuilder;
import org.spongepowered.common.util.Preconditions;

public final class SpongeSmithingRecipeBuilder
extends AbstractResourceKeyedBuilder<RecipeRegistration, SmithingRecipe.Builder>
implements SmithingRecipe.Builder,
SmithingRecipe.Builder.BaseStep,
SmithingRecipe.Builder.AdditionStep,
SmithingRecipe.Builder.ResultStep,
SmithingRecipe.Builder.EndStep {
    private ItemStack result;
    private class_1856 template;
    private class_1856 base;
    private class_1856 addition;
    private Function<class_9697, class_1799> resultFunction;
    private @Nullable String group;
    private DataPack<RecipeRegistration> pack = DataPacks.RECIPE;
    private class_7800 recipeCategory = class_7800.field_40642;

    public SmithingRecipe.Builder.BaseStep template(ItemType ingredient) {
        this.template = class_1856.method_8101(() -> (class_1792)ingredient);
        return this;
    }

    public SmithingRecipe.Builder.BaseStep template(Ingredient ingredient) {
        this.template = IngredientUtil.toNative(ingredient);
        return this;
    }

    public SmithingRecipe.Builder.AdditionStep base(ItemType ingredient) {
        this.base = class_1856.method_8101(() -> (class_1792)ingredient);
        return this;
    }

    public SmithingRecipe.Builder.AdditionStep base(Ingredient ingredient) {
        this.base = IngredientUtil.toNative(ingredient);
        return this;
    }

    public SmithingRecipe.Builder.ResultStep addition(ItemType ingredient) {
        this.addition = class_1856.method_8101(() -> (class_1792)ingredient);
        return this;
    }

    public SmithingRecipe.Builder.ResultStep addition(Ingredient ingredient) {
        this.addition = IngredientUtil.toNative(ingredient);
        return this;
    }

    public SmithingRecipe.Builder.EndStep result(ItemStackLike result) {
        Objects.requireNonNull(result, "result");
        this.result = result.asMutable();
        this.resultFunction = null;
        return this;
    }

    public SmithingRecipe.Builder.EndStep result(Function<RecipeInput.Smithing, ? extends ItemStackLike> resultFunction, ItemStackLike exemplaryResult) {
        Objects.requireNonNull(exemplaryResult, "exemplaryResult");
        Preconditions.checkState(!exemplaryResult.isEmpty(), "exemplaryResult must not be empty");
        this.result = exemplaryResult.asMutable();
        this.resultFunction = inv -> ItemStackUtil.fromLikeToNative((ItemStackLike)resultFunction.apply(InventoryUtil.toSponge(inv)));
        return this;
    }

    public SmithingRecipe.Builder.EndStep group(@Nullable String name) {
        this.group = name;
        return this;
    }

    public SmithingRecipe.Builder.EndStep pack(DataPack<RecipeRegistration> pack) {
        this.pack = pack;
        return this;
    }

    @Override
    public RecipeRegistration build0() {
        return new SpongeSmithingRecipeRegistration((class_2960)this.key, this.group, this.template, this.base, this.addition, ItemStackUtil.toNative(this.result), this.resultFunction, this.pack, this.recipeCategory);
    }

    public SmithingRecipe.Builder reset() {
        this.result = null;
        this.resultFunction = null;
        this.base = null;
        this.addition = null;
        this.group = null;
        this.pack = DataPacks.RECIPE;
        return (SmithingRecipe.Builder)super.reset();
    }
}

