/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1799;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.common.item.util.NativeStackException;

public abstract class ItemStackUtil {
    private ItemStackUtil() {
    }

    public static class_1799 toNative(@Nullable ItemStack stack) {
        if (stack instanceof class_1799 || stack == null) {
            return stack == null ? ItemStackUtil.emptyNative() : (class_1799)stack;
        }
        throw new NativeStackException("The supplied item stack was not native to the current platform");
    }

    public static class_1799[] toNative(List<ItemStack> items) {
        return (class_1799[])items.stream().map(ItemStackUtil::toNative).toArray(class_1799[]::new);
    }

    public static class_1799[] fromSnapshotToNative(List<ItemStackSnapshot> items) {
        return (class_1799[])items.stream().map(ItemStackUtil::fromSnapshotToNative).toArray(class_1799[]::new);
    }

    public static List<class_1799> fromSnapshotToNativeList(List<ItemStackSnapshot> items) {
        return items.stream().map(ItemStackUtil::fromSnapshotToNative).toList();
    }

    public static ItemStack fromNative(class_1799 stack) {
        if (stack instanceof ItemStack) {
            return (ItemStack)stack;
        }
        throw new NativeStackException("The supplied native item stack was not compatible with the target environment");
    }

    public static List<ItemStack> fromNative(class_1799[] items) {
        return Arrays.stream(items).map(ItemStackUtil::fromNative).collect(Collectors.toList());
    }

    public static class_1799 cloneDefensiveNative(class_1799 stack) {
        return stack.method_7972();
    }

    public static class_1799 cloneDefensiveNative(class_1799 stack, int newSize) {
        class_1799 clone = stack.method_7972();
        if (!clone.method_7960()) {
            clone.method_7939(newSize);
        }
        return clone;
    }

    public static ItemStack cloneDefensive(class_1799 stack) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack));
    }

    public static ItemStack cloneDefensive(class_1799 stack, int newSize) {
        return (ItemStack)ItemStackUtil.cloneDefensiveNative(stack, newSize);
    }

    public static ItemStack cloneDefensive(@Nullable ItemStack stack, int newSize) {
        return ItemStackUtil.cloneDefensive(ItemStackUtil.toNative(stack), newSize);
    }

    public static Optional<ItemStack> cloneDefensiveOptional(class_1799 stack) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static Optional<ItemStack> cloneDefensiveOptional(class_1799 stack, int withdraw) {
        return Optional.of(ItemStackUtil.cloneDefensive(stack));
    }

    public static boolean compareIgnoreQuantity(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    public static boolean compareIgnoreQuantity(class_1799 stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(stack1, ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, ItemStack stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), ItemStackUtil.toNative(stack2));
    }

    public static boolean compareIgnoreQuantity(ItemStack stack1, class_1799 stack2) {
        return ItemStackUtil.compareIgnoreQuantity(ItemStackUtil.toNative(stack1), stack2);
    }

    public static ItemStackSnapshot snapshotOf(class_1799 itemStack) {
        if (itemStack == null) {
            return ItemStackSnapshot.empty();
        }
        return itemStack.method_7960() ? ItemStackSnapshot.empty() : ItemStackUtil.fromNative(itemStack).asImmutable();
    }

    public static ItemStackSnapshot snapshotOf(@Nullable ItemStackLike itemStack) {
        return itemStack == null ? ItemStackSnapshot.empty() : (itemStack.isEmpty() ? ItemStackSnapshot.empty() : itemStack.asImmutable());
    }

    public static List<ItemStackSnapshot> snapshotOf(List<class_1799> items) {
        return items.stream().map(ItemStackUtil::snapshotOf).toList();
    }

    public static class_1799 fromSnapshotToNative(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.emptyNative() : (snapshot == ItemStackSnapshot.empty() ? ItemStackUtil.emptyNative() : ItemStackUtil.toNative(snapshot.asMutable()));
    }

    public static ItemStack fromSnapshot(@Nullable ItemStackSnapshot snapshot) {
        return snapshot == null ? ItemStackUtil.empty() : (snapshot.isEmpty() ? ItemStackUtil.empty() : snapshot.asMutable());
    }

    public static class_1799 fromLikeToNative(@Nullable ItemStackLike itemStack) {
        return itemStack == null ? ItemStackUtil.emptyNative() : (itemStack.isEmpty() ? ItemStackUtil.emptyNative() : ItemStackUtil.toNative(itemStack.asMutable()));
    }

    public static ItemStack empty() {
        return ItemStackUtil.fromNative(class_1799.field_8037);
    }

    public static class_1799 emptyNative() {
        return class_1799.field_8037;
    }
}

