/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.item.util;

import java.util.Comparator;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackComparators;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.registry.RegistryTypes;

public class SpongeItemStackComparatorFactory
implements ItemStackComparators.Factory {
    private Comparator<ItemStack> comparator;

    public SpongeItemStackComparatorFactory() {
    }

    public SpongeItemStackComparatorFactory(Comparator<ItemStack> comparator) {
        this.comparator = comparator;
    }

    public ItemStackComparators.Factory byType() {
        Comparator<ItemStack> comparator = Comparator.comparing(i -> i.type().key(RegistryTypes.ITEM_TYPE));
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    public ItemStackComparators.Factory byData() {
        ItemDataComparator comparator = new ItemDataComparator(new Key[0]);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    public ItemStackComparators.Factory byDurability() {
        ItemDataComparator comparator = new ItemDataComparator(new Key[0]);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(comparator));
    }

    public ItemStackComparators.Factory bySize() {
        Comparator<ItemStack> comparator = Comparator.comparing(ItemStackLike::quantity);
        return new SpongeItemStackComparatorFactory(this.comparator == null ? comparator : this.comparator.thenComparing(this.comparator));
    }

    public Supplier<Comparator<ItemStack>> asSupplier() {
        Comparator<ItemStack> comparator = this.build();
        return () -> comparator;
    }

    public Comparator<ItemStack> build() {
        return this.comparator;
    }

    private static final class ItemDataComparator
    implements Comparator<ItemStack> {
        private final Key<? extends Value<?>>[] ignored;

        ItemDataComparator(Key<? extends Value<?>> ... ignored) {
            this.ignored = ignored;
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            Map<Key, Object> map = o2.getValues().stream().collect(Collectors.toMap(Value::key, Value::get));
            for (Value.Immutable value : o1.getValues()) {
                if (map.containsKey(value.key()) && map.get(value.key()).equals(value.get())) {
                    map.remove(value.key());
                    continue;
                }
                if (this.isIgnored(map, value)) continue;
                return -1;
            }
            return map.size();
        }

        private boolean isIgnored(Map<? extends Key<? extends Value<?>>, ?> map, Value.Immutable<?> toCheck) {
            for (Key<? extends Value<?>> ignore : this.ignored) {
                if (!toCheck.key().equals(ignore)) continue;
                map.remove(ignore);
                return true;
            }
            return false;
        }
    }
}

