/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.launch;

import com.google.inject.Injector;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.common.applaunch.plugin.PluginPlatform;
import org.spongepowered.common.launch.Lifecycle;
import org.spongepowered.common.launch.plugin.SpongePluginManager;
import org.spongepowered.plugin.PluginContainer;

public abstract class Launch {
    private static Launch INSTANCE;
    private static final String ID = "sponge";
    protected final PluginPlatform pluginPlatform;
    private final Logger logger = LogManager.getLogger((String)"launch");
    private final List<PluginContainer> launcherPlugins;
    private PluginContainer minecraftPlugin;
    private PluginContainer apiPlugin;
    private PluginContainer commonPlugin;
    private Lifecycle lifecycle;

    protected Launch(PluginPlatform pluginPlatform) {
        this.pluginPlatform = pluginPlatform;
        this.launcherPlugins = new ArrayList<PluginContainer>();
    }

    public static <L extends Launch> L instance() {
        return (L)INSTANCE;
    }

    public static void setInstance(Launch instance) {
        if (INSTANCE != null) {
            throw new RuntimeException("Attempt made to re-set launcher instance!");
        }
        INSTANCE = Objects.requireNonNull(instance);
    }

    public final String id() {
        return ID;
    }

    public abstract boolean dedicatedServer();

    public abstract SpongePluginManager pluginManager();

    public Lifecycle lifecycle() {
        if (this.lifecycle == null) {
            throw new RuntimeException("The lifecycle has not been set during launch! Too early?");
        }
        return this.lifecycle;
    }

    public void setLifecycle(Lifecycle lifecycle) {
        if (this.lifecycle != null) {
            throw new RuntimeException("Attempt made to re-set lifecycle instance twice!");
        }
        this.lifecycle = lifecycle;
    }

    public final Logger logger() {
        return this.logger;
    }

    public PluginPlatform pluginPlatform() {
        return this.pluginPlatform;
    }

    public abstract Stage injectionStage();

    public final boolean developerEnvironment() {
        return this.injectionStage() == Stage.DEVELOPMENT;
    }

    public final PluginContainer minecraftPlugin() {
        if (this.minecraftPlugin == null) {
            this.minecraftPlugin = this.pluginManager().plugin("minecraft").orElse(null);
            if (this.minecraftPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing Minecraft, this is a serious issue!");
            }
        }
        return this.minecraftPlugin;
    }

    public final PluginContainer apiPlugin() {
        if (this.apiPlugin == null) {
            this.apiPlugin = this.pluginManager().plugin("spongeapi").orElse(null);
            if (this.apiPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing SpongeAPI, this is a serious issue!");
            }
        }
        return this.apiPlugin;
    }

    public final PluginContainer commonPlugin() {
        if (this.commonPlugin == null) {
            this.commonPlugin = this.pluginManager().plugin(ID).orElse(null);
            if (this.commonPlugin == null) {
                throw new RuntimeException("Could not find the plugin representing Sponge, this is a serious issue!");
            }
        }
        return this.commonPlugin;
    }

    public abstract PluginContainer platformPlugin();

    public final List<PluginContainer> launcherPlugins() {
        if (this.launcherPlugins.isEmpty()) {
            this.launcherPlugins.add(this.minecraftPlugin());
            this.launcherPlugins.add(this.apiPlugin());
            this.launcherPlugins.add(this.commonPlugin());
            this.launcherPlugins.add(this.platformPlugin());
        }
        return this.launcherPlugins;
    }

    public final void auditMixins() {
        MixinEnvironment.getCurrentEnvironment().audit();
    }

    public abstract Injector createInjector();
}

