/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map;

import com.google.common.collect.BiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3978;
import net.minecraft.class_9209;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.map.MapInfo;
import org.spongepowered.api.map.MapStorage;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.map.MapIdTrackerBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.PhaseTracker;

public final class SpongeMapStorage
implements MapStorage {
    private final Map<UUID, MapInfo> loadedMapUUIDs = new HashMap<UUID, MapInfo>();
    private @Nullable BiMap<Integer, UUID> mapIdUUIDIndex = null;

    public Collection<MapInfo> allMapInfos() {
        HashSet<MapInfo> mapInfos = new HashSet<MapInfo>();
        class_3218 defaultWorld = (class_3218)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        int highestId = ((MapIdTrackerBridge)defaultWorld.method_17983().method_17924(class_3978.method_52610(), "idcounts")).bridge$getHighestMapId().orElse(-1);
        for (int i = 0; i <= highestId; ++i) {
            @Nullable MapInfo mapInfo = (MapInfo)defaultWorld.method_17891(new class_9209(i));
            if (mapInfo == null) {
                SpongeCommon.logger().warn("Missing map with id: " + i);
                continue;
            }
            this.addMapInfo(mapInfo);
            mapInfos.add(mapInfo);
        }
        return mapInfos;
    }

    public Optional<MapInfo> mapInfo(UUID uuid) {
        this.ensureHasMapUUIDIndex();
        MapInfo mapInfo = this.loadedMapUUIDs.get(uuid);
        if (mapInfo != null) {
            return Optional.of(mapInfo);
        }
        Integer mapId = (Integer)this.mapIdUUIDIndex.inverse().get((Object)uuid);
        if (mapId == null) {
            return Optional.empty();
        }
        class_3218 defaultWorld = (class_3218)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get();
        MapInfo loadedMapInfo = (MapInfo)defaultWorld.method_17891(new class_9209(mapId.intValue()));
        return Optional.ofNullable(loadedMapInfo);
    }

    public Optional<MapInfo> createNewMapInfo() {
        return SpongeCommonEventFactory.fireCreateMapEvent(PhaseTracker.getInstance().currentCause());
    }

    public UUID requestUUID(int id) {
        this.ensureHasMapUUIDIndex();
        UUID uuid = (UUID)this.mapIdUUIDIndex.get((Object)id);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.mapIdUUIDIndex.put((Object)id, (Object)uuid);
        }
        return uuid;
    }

    public void addMapInfo(MapInfo mapInfo) {
        this.loadedMapUUIDs.put(mapInfo.uniqueId(), mapInfo);
    }

    private void ensureHasMapUUIDIndex() {
        if (this.mapIdUUIDIndex == null) {
            this.mapIdUUIDIndex = ((PrimaryLevelDataBridge)((ServerWorld)Sponge.server().worldManager().world(DefaultWorldKeys.DEFAULT).get()).properties()).bridge$getMapUUIDIndex();
        }
    }
}

