/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.map.decoration;

import java.util.Objects;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.minecraft.class_20;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9428;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.persistence.DataQuery;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientations;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.math.vector.Vector2i;

public final class SpongeMapDecorationBuilder
implements MapDecoration.Builder {
    private @Nullable MapDecorationType type = null;
    private int x;
    private int y;
    private MapDecorationOrientation rot = (MapDecorationOrientation)MapDecorationOrientations.NORTH.get();
    private @Nullable Component customName = null;

    public MapDecoration.Builder type(MapDecorationType type) {
        this.type = type;
        return this;
    }

    public MapDecoration.Builder reset() {
        this.type = null;
        this.x = 0;
        this.y = 0;
        this.rot = (MapDecorationOrientation)MapDecorationOrientations.NORTH.get();
        this.customName = null;
        return this;
    }

    public MapDecoration.Builder from(MapDecoration value) {
        Objects.requireNonNull(value, "MapDecoration cannot be null");
        this.type = value.type();
        this.x = value.position().x();
        this.y = value.position().y();
        this.rot = value.rotation();
        return this;
    }

    public MapDecoration.Builder rotation(MapDecorationOrientation rot) throws IllegalArgumentException {
        Objects.requireNonNull(rot, "Orientation cannot be null");
        this.rot = rot;
        return this;
    }

    public MapDecoration.Builder position(Vector2i position) throws IllegalArgumentException {
        Objects.requireNonNull(position, "position cannot be null");
        if (!MapUtil.isInMapDecorationBounds(position.x())) {
            throw new IllegalArgumentException("x not in bounds");
        }
        if (!MapUtil.isInMapDecorationBounds(position.y())) {
            throw new IllegalArgumentException("y not in bounds");
        }
        this.x = position.x();
        this.y = position.y();
        return this;
    }

    public MapDecoration.Builder customName(Component customName) {
        this.customName = customName;
        return this;
    }

    public MapDecoration.Builder fromContainer(DataView container) {
        if (!container.contains(Constants.Map.DECORATION_TYPE, new DataQuery[]{Constants.Map.DECORATION_ROTATION})) {
            return this;
        }
        this.reset();
        Optional oldType = container.getByte(Constants.Map.DECORATION_TYPE);
        ResourceKey type = (ResourceKey)container.getResourceKey(Constants.Map.DECORATION_TYPE).get();
        byte rot = this.getByteFromContainer(container, Constants.Map.DECORATION_ROTATION);
        class_9428 mcType = (class_9428)class_7923.field_50078.method_63535((class_2960)type);
        if (mcType == null) {
            throw new IllegalStateException("Missing a MapDecorationType, could not find one for Minecraft's MapDecoration.Type: " + String.valueOf(type));
        }
        this.type((MapDecorationType)mcType);
        int intRot = MapUtil.normalizeDecorationOrientation(rot);
        this.rotation(MapUtil.getMapRotById(intRot));
        if (container.contains(Constants.Map.DECORATION_X, new DataQuery[]{Constants.Map.DECORATION_Y})) {
            byte x = this.getByteFromContainer(container, Constants.Map.DECORATION_X);
            byte y = this.getByteFromContainer(container, Constants.Map.DECORATION_Y);
            this.position(Vector2i.from((int)x, (int)y));
        }
        if (container.contains(Constants.Map.NAME)) {
            Component component = GsonComponentSerializer.gson().deserialize((Object)((String)container.getString(Constants.Map.NAME).orElseThrow(() -> new InvalidDataException("Invalid data type for " + String.valueOf(Constants.Map.NAME) + ". Should be String"))));
            this.customName(component);
        }
        return this;
    }

    private byte getByteFromContainer(DataView container, DataQuery query) throws InvalidDataException {
        return (Byte)container.getByte(query).orElseThrow(() -> new InvalidDataException("Invalid data type for " + String.valueOf(query) + ". Should be byte"));
    }

    public MapDecoration build() throws IllegalStateException {
        Objects.requireNonNull(this.type, "Type has not been set");
        MapDecoration decoration = (MapDecoration)new class_20(class_6880.method_40223((Object)((class_9428)this.type)), (byte)this.x, (byte)this.y, (byte)((SpongeMapDecorationOrientation)this.rot).getOrientationNumber(), Optional.ofNullable(this.customName).map(SpongeAdventure::asVanilla));
        ((MapDecorationBridge)decoration).bridge$setPersistent(true);
        return decoration;
    }
}

