/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.advancements;

import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_167;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.advancement.criteria.ScoreCriterionProgress;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.util.Preconditions;

@Mixin(value={class_167.class})
public abstract class AdvancementProgressMixin_API
implements AdvancementProgress {
    public Optional<Instant> get() {
        return this.get(this.advancement().criterion()).get().get();
    }

    public Instant grant() {
        return this.get(this.advancement().criterion()).get().grant();
    }

    public Optional<Instant> revoke() {
        return this.get(this.advancement().criterion()).get().revoke();
    }

    public Advancement advancement() {
        return ((AdvancementProgressBridge)((Object)this)).bridge$getAdvancement();
    }

    public Optional<CriterionProgress> get(AdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        Map<String, ImplementationBackedCriterionProgress> map = ((AdvancementProgressBridge)((Object)this)).bridge$getProgressMap();
        Preconditions.checkState(map != null, "progressMap isn't initialized");
        return Optional.ofNullable((CriterionProgress)map.get(criterion.name()));
    }

    public Optional<ScoreCriterionProgress> get(ScoreAdvancementCriterion criterion) {
        Objects.requireNonNull(criterion);
        Map<String, ImplementationBackedCriterionProgress> map = ((AdvancementProgressBridge)((Object)this)).bridge$getProgressMap();
        Preconditions.checkState(map != null, "progressMap isn't initialized");
        return Optional.ofNullable((ScoreCriterionProgress)map.get(criterion.name()));
    }

    public CriterionProgress require(AdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        return this.get(criterion).orElseThrow(() -> new IllegalStateException("The criterion " + criterion.name() + " isn't present on the advancement '" + String.valueOf(this.advancement()) + "'."));
    }

    public ScoreCriterionProgress require(ScoreAdvancementCriterion criterion) {
        Objects.requireNonNull(criterion, "criterion");
        return this.get(criterion).orElseThrow(() -> new IllegalStateException("The score criterion " + criterion.name() + " isn't present on this advancement"));
    }
}

