/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.client;

import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1132;
import net.minecraft.class_2535;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.client.LocalServer;
import org.spongepowered.api.entity.living.player.client.LocalPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.network.ClientSideConnection;
import org.spongepowered.api.resource.ResourceManager;
import org.spongepowered.api.resource.pack.PackRepository;
import org.spongepowered.api.world.client.ClientWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.client.MinecraftBridge;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.client.SpongeClient;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.ClientScheduler;
import org.spongepowered.common.util.BlockDestructionIdCache;
import org.spongepowered.common.util.LocaleCache;

@Mixin(value={class_310.class})
public abstract class MinecraftMixin_API
implements SpongeClient,
SpongeRegistryHolder {
    @Shadow
    public class_638 field_1687;
    @Shadow
    public class_746 field_1724;
    @Shadow
    private @Nullable class_2535 field_1746;
    @Shadow
    @Final
    public class_315 field_1690;
    private final ClientScheduler api$scheduler = new ClientScheduler();
    private final RegistryHolderLogic api$registryHolder = new RegistryHolderLogic();
    private final BlockDestructionIdCache api$blockDestructionIdCache = new BlockDestructionIdCache(Integer.MIN_VALUE, AtomicInteger::incrementAndGet);

    @Shadow
    public abstract @Nullable class_1132 shadow$method_1576();

    @Shadow
    public abstract class_3283 shadow$method_1520();

    @Shadow
    public abstract class_3300 shadow$method_1478();

    @Shadow
    public abstract @Nullable class_634 shadow$method_1562();

    public Optional<LocalPlayer> player() {
        return Optional.ofNullable((LocalPlayer)this.field_1724);
    }

    public Optional<LocalServer> server() {
        MinecraftBridge minecraftBridge = (MinecraftBridge)((Object)this);
        class_1132 integratedServer = minecraftBridge.bridge$getTemporaryIntegratedServer();
        if (integratedServer != null) {
            return Optional.ofNullable(integratedServer);
        }
        return Optional.ofNullable(this.shadow$method_1576());
    }

    public Optional<ClientWorld> world() {
        return Optional.ofNullable((ClientWorld)this.field_1687);
    }

    public Optional<ClientSideConnection> connection() {
        @Nullable class_634 connection = this.shadow$method_1562();
        if (connection == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ClientSideConnection)((ConnectionBridge)connection.method_48296()).bridge$getEngineConnection());
    }

    public Game game() {
        return Sponge.game();
    }

    public CauseStackManager causeStackManager() {
        return PhaseTracker.getInstance().apiAccess();
    }

    public PackRepository packRepository() {
        return (PackRepository)this.shadow$method_1520();
    }

    public ResourceManager resourceManager() {
        return (ResourceManager)this.shadow$method_1478();
    }

    @Override
    public ClientScheduler scheduler() {
        return this.api$scheduler;
    }

    public boolean onMainThread() {
        return ((class_310)this).method_18854();
    }

    public Locale locale() {
        return LocaleCache.getLocale(this.field_1690.field_1883);
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        return this.api$registryHolder;
    }

    @Override
    public BlockDestructionIdCache getBlockDestructionIdCache() {
        return this.api$blockDestructionIdCache;
    }
}

