/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.commands.arguments.selector;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2096;
import net.minecraft.class_2152;
import net.minecraft.class_2300;
import net.minecraft.class_2303;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.command.selector.Selector;
import org.spongepowered.api.command.selector.SelectorSortAlgorithm;
import org.spongepowered.api.command.selector.SelectorType;
import org.spongepowered.api.data.persistence.DataFormats;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.StringDataFormat;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.util.Range;
import org.spongepowered.api.util.Tristate;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_DoublesAccessor;
import org.spongepowered.common.accessor.advancements.critereon.MinMaxBounds_IntsAccessor;
import org.spongepowered.common.bridge.commands.arguments.selector.EntitySelectorParserBridge;
import org.spongepowered.common.command.selector.SpongeSelectorSortAlgorithm;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={class_2303.class})
public abstract class EntitySelectorParserMixin_API
implements Selector.Builder {
    @Shadow
    @Final
    private StringReader field_10860;
    @Shadow
    private int field_10858;
    @Shadow
    private BiConsumer<class_243, List<? extends class_1297>> field_10847;
    @Shadow
    private class_2096.class_2099 field_10838;
    @Shadow
    private class_2096.class_2100 field_10842;
    @Shadow
    private boolean field_10843;
    @Shadow
    private boolean field_10866;
    @Shadow
    private @Nullable Double field_10857;
    @Shadow
    private @Nullable Double field_10872;
    @Shadow
    private @Nullable Double field_10839;
    @Shadow
    private @Nullable Double field_10862;
    @Shadow
    private @Nullable Double field_10852;
    @Shadow
    private @Nullable Double field_10881;
    @Shadow
    private class_2152 field_10877 = class_2152.field_9780;
    @Shadow
    private class_2152 field_10859 = class_2152.field_9780;
    @Shadow
    @Final
    private List<Predicate<class_1297>> field_10870;
    @Shadow
    private boolean field_10879;
    @Shadow
    private @Nullable String field_10876;
    @Shadow
    private int field_10861;
    @Shadow
    private @Nullable UUID field_10878;
    @Shadow
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_10848;
    @Shadow
    private boolean field_10854;
    @Shadow
    private boolean field_10874;
    @Shadow
    private boolean field_10851;
    @Shadow
    private boolean field_10873;
    @Shadow
    private boolean field_10849;
    @Shadow
    private boolean field_10871;
    @Shadow
    private boolean field_10845;
    @Shadow
    private boolean field_10868;
    @Shadow
    private @Nullable class_1299<?> field_10863;
    @Shadow
    private boolean field_10865;
    @Shadow
    private boolean field_10841;
    @Shadow
    private boolean field_10864;
    @Shadow
    private boolean field_10840;
    private @Nullable Map<String, Range<@NonNull Integer>> api$scores;
    private @Nullable Object2BooleanOpenHashMap<String> api$advancement;
    private @Nullable Map<String, Object2BooleanOpenHashMap<String>> api$criterion;
    private boolean api$forceSelf;

    @Shadow
    public abstract void shadow$method_9877(boolean var1);

    @Shadow
    public abstract void shadow$method_9887(boolean var1);

    @Shadow
    public abstract void shadow$method_9850(double var1);

    @Shadow
    public abstract void shadow$method_9864(double var1);

    @Shadow
    public abstract void shadow$method_9879(double var1);

    @Shadow
    public abstract void shadow$method_9891(double var1);

    @Shadow
    public abstract void shadow$method_9905(double var1);

    @Shadow
    public abstract void shadow$method_9918(double var1);

    @Shadow
    public abstract void shadow$method_9841(boolean var1);

    @Shadow
    public abstract class_2300 shadow$method_9871();

    @Shadow
    public abstract void shadow$method_9916(Predicate<class_1297> var1);

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder applySelectorType(Supplier<? extends SelectorType> selectorType) {
        return this.applySelectorType(selectorType.get());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder applySelectorType(@NonNull SelectorType selectorType) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$parseSelector(selectorType);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            throw new IllegalArgumentException("Could not parse provided SelectorType", commandSyntaxException);
        }
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder includeSelf() {
        this.api$forceSelf = true;
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder limit(int limit) {
        this.field_10858 = limit;
        this.shadow$method_9877(limit != Integer.MAX_VALUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder distance(@NonNull Range<@NonNull Double> range) {
        if (range.min() != null && (Double)range.min() < 0.0) {
            throw new IllegalArgumentException("min must be non-negative");
        }
        if (range.max() != null && (Double)range.max() < 0.0) {
            throw new IllegalArgumentException("max must be non-negative");
        }
        this.field_10838 = MinMaxBounds_DoublesAccessor.invoker$new(Optional.ofNullable((Double)range.min()), Optional.ofNullable((Double)range.max()));
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder volume(@NonNull Vector3d corner1, @NonNull Vector3d corner2) {
        Vector3d minPoint = corner1.min(corner2);
        Vector3d distance = corner1.max(corner2).sub(minPoint);
        this.shadow$method_9850(minPoint.x());
        this.shadow$method_9864(minPoint.y());
        this.shadow$method_9879(minPoint.z());
        this.shadow$method_9891(distance.x());
        this.shadow$method_9905(distance.y());
        this.shadow$method_9918(distance.z());
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder sortAlgorithm(@NonNull Supplier<? extends SelectorSortAlgorithm> algorithm) {
        return this.sortAlgorithm(algorithm.get());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder sortAlgorithm(@NonNull SelectorSortAlgorithm algorithm) {
        Preconditions.checkArgument(algorithm instanceof SpongeSelectorSortAlgorithm, "Must be a SpongeSelectorSortAlgorithm");
        this.shadow$method_9887(true);
        this.field_10847 = ((SpongeSelectorSortAlgorithm)algorithm).getSortAlgorithm();
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addAdvancement(@NonNull ResourceKey advancement) {
        return this.api$advancement(advancement, false);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotAdvancement(@NonNull ResourceKey advancement) {
        return this.api$advancement(advancement, true);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addAdvancementCriterion(@NonNull ResourceKey advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, false);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotAdvancementCriterion(@NonNull ResourceKey advancement, @NonNull AdvancementCriterion criterion) {
        return this.api$advancementCriterion(advancement, criterion, true);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder dataView(@NonNull DataView view) {
        try {
            String json = ((StringDataFormat)DataFormats.JSON.get()).write(view);
            this.api$handle("nbt", json);
            return this;
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create JSON representation of DataView", e);
        }
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type) {
        return this.addNotEntityType(type.get());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotEntityType(@NonNull EntityType<@NonNull ?> type) {
        ResourceKey key = (ResourceKey)SpongeCommon.vanillaRegistry(class_7924.field_41266).method_10221((Object)((class_1299)type));
        this.api$handle("type", "!" + key.asString());
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addEntityType(@NonNull Supplier<@NonNull EntityType<@NonNull ?>> type, boolean inherit) {
        return this.addEntityType(type.get(), inherit);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addEntityType(@NonNull EntityType<@NonNull ?> type, boolean inherit) {
        ResourceKey key = (ResourceKey)SpongeCommon.vanillaRegistry(class_7924.field_41266).method_10221((Object)((class_1299)type));
        this.api$handle("type", String.format("%s%s", inherit ? "#" : "", key.asString()));
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder experienceLevel(@NonNull Range<@NonNull Integer> range) {
        Preconditions.checkArgument(range.min() == null || (Integer)range.min() >= 0, "min must be non-negative");
        Preconditions.checkArgument(range.max() == null || (Integer)range.max() >= 0, "max must be non-negative");
        this.field_10842 = MinMaxBounds_IntsAccessor.invoker$new(Optional.of((Integer)range.min()), Optional.of((Integer)range.max()));
        this.shadow$method_9841(false);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addGameMode(mode.get());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry((RegistryType)RegistryTypes.GAME_MODE).valueKey((Object)mode);
        this.api$handle("gamemode", key.value(), Tristate.FALSE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotGameMode(@NonNull Supplier<? extends GameMode> mode) {
        return this.addNotGameMode(mode.get());
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotGameMode(@NonNull GameMode mode) {
        ResourceKey key = Sponge.game().registry((RegistryType)RegistryTypes.GAME_MODE).valueKey((Object)mode);
        this.api$handle("gamemode", key.value(), Tristate.TRUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder noTeam() {
        this.api$handle("team", "", Tristate.TRUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder anyTeam() {
        this.api$handle("team", "", Tristate.FALSE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.FALSE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotTeam(@NonNull Team team) {
        this.api$handle("team", team.name(), Tristate.TRUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addName(@NonNull String name) {
        this.api$handle("name", name, Tristate.FALSE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotName(@NonNull String name) {
        this.api$handle("name", name, Tristate.TRUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addObjective(@NonNull Objective objective, @NonNull Range<@NonNull Integer> range) {
        if (this.api$scores == null) {
            this.api$scores = new HashMap<String, Range<Integer>>();
        }
        this.api$scores.put(objective.name(), range);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.FALSE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addNotTag(@NonNull String tag) {
        this.api$handle("tag", tag, Tristate.TRUE);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder pitch(@NonNull Range<@NonNull Double> range) {
        this.field_10877 = this.api$getWrappedBounds(range);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder yaw(@NonNull Range<@NonNull Double> range) {
        this.field_10859 = this.api$getWrappedBounds(range);
        return this;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder addFilter(@NonNull Predicate<@NonNull Entity> filter) {
        this.shadow$method_9916(filter);
        return this;
    }

    public @NonNull Selector build() throws IllegalStateException {
        ArrayList entries;
        if (this.api$advancement != null || this.api$criterion != null) {
            entries = new ArrayList();
            if (this.api$advancement != null) {
                this.api$advancement.object2BooleanEntrySet().fastForEach(x -> entries.add((String)x.getKey() + "=" + x.getBooleanValue()));
            }
            if (this.api$criterion != null) {
                this.api$criterion.forEach((key, value) -> value.object2BooleanEntrySet().fastForEach(x -> entries.add(key + "={" + (String)x.getKey() + "=" + x.getBooleanValue() + "}")));
            }
            this.api$handle("advancements", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$advancement = null;
            this.api$criterion = null;
        }
        if (this.api$scores != null) {
            entries = new ArrayList();
            this.api$scores.forEach((key, range) -> entries.add(key + "=" + this.api$intRangeToStringRepresentation((Range<Integer>)range)));
            this.api$handle("scores", "{" + String.join((CharSequence)",", entries) + "}");
            this.api$scores = null;
        }
        if (this.api$forceSelf) {
            this.field_10879 = true;
        }
        return (Selector)this.shadow$method_9871();
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder reset() {
        this.field_10847 = class_2300.field_41524;
        this.field_10838 = class_2096.class_2099.field_9705;
        this.field_10842 = class_2096.class_2100.field_9708;
        this.field_10843 = false;
        this.field_10866 = false;
        this.field_10857 = null;
        this.field_10872 = null;
        this.field_10839 = null;
        this.field_10862 = null;
        this.field_10852 = null;
        this.field_10881 = null;
        this.field_10877 = class_2152.field_9780;
        this.field_10859 = class_2152.field_9780;
        this.field_10870.clear();
        this.field_10879 = false;
        this.field_10876 = null;
        this.field_10861 = 0;
        this.field_10878 = null;
        this.field_10854 = false;
        this.field_10874 = false;
        this.field_10851 = false;
        this.field_10873 = false;
        this.field_10849 = false;
        this.field_10871 = false;
        this.field_10845 = false;
        this.field_10868 = false;
        this.field_10863 = null;
        this.field_10865 = false;
        this.field_10841 = false;
        this.field_10864 = false;
        this.field_10840 = false;
        this.field_10860.setCursor(0);
        this.field_10848 = class_2303.field_10867;
        this.api$forceSelf = false;
        return this;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder api$advancement(@NonNull ResourceKey advancement, boolean inverted) {
        if (this.api$advancement == null) {
            this.api$advancement = new Object2BooleanOpenHashMap();
        }
        this.api$advancement.put((Object)advancement.asString(), inverted);
        return this;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Selector.Builder api$advancementCriterion(@NonNull ResourceKey advancement, @NonNull AdvancementCriterion criterion, boolean inverted) {
        if (this.api$criterion == null) {
            this.api$criterion = new HashMap<String, Object2BooleanOpenHashMap<String>>();
        }
        this.api$criterion.computeIfAbsent(advancement.toString(), k -> new Object2BooleanOpenHashMap()).put((Object)criterion.name(), inverted);
        return this;
    }

    private void api$handle(@NonNull String name, @NonNull String value) {
        this.api$handle(name, value, Tristate.UNDEFINED);
    }

    private void api$handle(@NonNull String name, @NonNull String value, @NonNull Tristate invert) {
        try {
            ((EntitySelectorParserBridge)((Object)this)).bridge$handleValue(name, value, invert);
        }
        catch (CommandSyntaxException ex) {
            throw new IllegalArgumentException(String.format("Could not create selector criteria based on input (name = '%s', value = '%s', invert = %s)", name, value, invert.name()), ex);
        }
    }

    private @Nullable Float api$floatFromDouble(@Nullable Double d, Function<Float, Float> mapping) {
        if (d == null) {
            return null;
        }
        return mapping.apply(Float.valueOf(d.floatValue()));
    }

    private class_2152 api$getWrappedBounds(Range<@NonNull Double> range) {
        Float a = this.api$floatFromDouble((Double)range.min(), class_3532::method_15393);
        Float b = this.api$floatFromDouble((Double)range.max(), class_3532::method_15393);
        if (a == null) {
            return new class_2152(null, b);
        }
        if (b == null) {
            return new class_2152(a, null);
        }
        if (a.floatValue() <= b.floatValue()) {
            return new class_2152(a, b);
        }
        return new class_2152(b, a);
    }

    private String api$intRangeToStringRepresentation(@NonNull Range<@NonNull Integer> range) {
        if (range.min() != null && range.max() != null && ((Integer)range.min()).intValue() == ((Integer)range.max()).intValue()) {
            return String.valueOf((Integer)range.max());
        }
        return String.format("%s..%s", range.min() == null ? "" : String.valueOf((Integer)range.min()), range.max() == null ? "" : String.valueOf((Integer)range.max()));
    }
}

