/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.core;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_9248;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.registry.RegistryEntry;
import org.spongepowered.api.registry.RegistryType;
import org.spongepowered.api.registry.ValueNotFoundException;
import org.spongepowered.api.tag.Tag;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.core.RegistryBridge;
import org.spongepowered.common.bridge.core.WritableRegistryBridge;

@Mixin(value={class_2370.class})
@Implements(value={@Interface(iface=Registry.class, prefix="registry$", remap=Interface.Remap.NONE)})
public abstract class MappedRegistryMixin_API<T>
implements Registry<T> {
    @Shadow
    public abstract class_6880.class_6883<T> shadow$method_10272(class_5321<T> var1, T var2, class_9248 var3);

    @Shadow
    public abstract class_5321<? extends class_2378<T>> shadow$method_46765();

    @Shadow
    public abstract @Nullable T shadow$method_63535(@Nullable class_2960 var1);

    private class_2960 impl$getKey(T value) {
        return ((class_2378)this).method_10221(value);
    }

    private Optional<T> impl$getOptional(@Nullable class_2960 param0) {
        return ((class_2378)this).method_17966(param0);
    }

    private Optional<class_6885.class_6888<T>> impl$getTag(class_6862<T> var1) {
        return ((class_2378)this).method_46733(var1);
    }

    private Stream<class_6862<T>> impl$getTagNames() {
        return ((class_2378)this).method_40272().map(class_6885.class_6888::method_40251);
    }

    public RegistryType<T> type() {
        return ((RegistryBridge)((Object)this)).bridge$type();
    }

    public ResourceKey valueKey(T value) {
        Objects.requireNonNull(value, "value");
        class_2960 key = this.impl$getKey(value);
        if (key == null) {
            throw new IllegalStateException(String.format("No key was found for '%s'!", value));
        }
        return (ResourceKey)key;
    }

    public Optional<ResourceKey> findValueKey(T value) {
        Objects.requireNonNull(value, "value");
        return Optional.ofNullable(this.impl$getKey(value)).map(l -> (ResourceKey)l);
    }

    public <V extends T> Optional<RegistryEntry<V>> findEntry(ResourceKey key) {
        return ((RegistryBridge)((Object)this)).bridge$get(Objects.requireNonNull(key, "key"));
    }

    public <V extends T> Optional<V> findValue(ResourceKey key) {
        return this.impl$getOptional((class_2960)Objects.requireNonNull(key, "key"));
    }

    public <V extends T> V value(ResourceKey key) {
        T value = this.shadow$method_63535((class_2960)Objects.requireNonNull(key, "key"));
        if (value != null) {
            return (V)value;
        }
        throw new ValueNotFoundException(String.format("No value was found for key '%s'!", key));
    }

    public <V extends T> Set<V> taggedValues(Tag<T> tag) {
        return this.impl$getTag((class_6862)tag).stream().flatMap(class_6885.class_6887::method_40239).map(h -> h.comp_349()).collect(Collectors.toSet());
    }

    public <V extends T> Stream<Tag<V>> tags() {
        return this.impl$getTagNames().map(Tag.class::cast);
    }

    public Stream<RegistryEntry<T>> streamEntries() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries();
    }

    @Intrinsic
    public Stream<T> registry$stream() {
        return ((RegistryBridge)((Object)this)).bridge$streamEntries().map(RegistryEntry::value);
    }

    public boolean isDynamic() {
        MappedRegistryMixin_API mappedRegistryMixin_API = this;
        if (mappedRegistryMixin_API instanceof WritableRegistryBridge) {
            WritableRegistryBridge bridge = (WritableRegistryBridge)((Object)mappedRegistryMixin_API);
            return bridge.bridge$isDynamic();
        }
        return false;
    }

    public <V extends T> Optional<RegistryEntry<V>> register(ResourceKey key, V value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.isDynamic()) {
            class_5321 mcKey = class_5321.method_29179(this.shadow$method_46765(), (class_2960)((class_2960)key));
            this.shadow$method_10272(mcKey, value, class_9248.field_49136);
            return ((RegistryBridge)((Object)this)).bridge$get(key);
        }
        return Optional.empty();
    }
}

