/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.map;

import java.util.Optional;
import net.minecraft.class_20;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9428;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.map.decoration.MapDecoration;
import org.spongepowered.api.map.decoration.MapDecorationType;
import org.spongepowered.api.map.decoration.orientation.MapDecorationOrientation;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.world.storage.MapDecorationBridge;
import org.spongepowered.common.map.decoration.orientation.SpongeMapDecorationOrientation;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MapUtil;
import org.spongepowered.common.util.Preconditions;
import org.spongepowered.math.vector.Vector2i;

@Mixin(value={class_20.class})
public abstract class MapDecorationMixin_API
implements MapDecoration {
    @Shadow
    @Final
    private class_6880<class_9428> comp_1842;
    @Shadow
    @Final
    @Mutable
    private byte comp_1843;
    @Shadow
    @Final
    @Mutable
    private byte comp_1844;
    @Shadow
    @Final
    @Mutable
    private byte comp_1845;
    @Shadow
    @Final
    private Optional<class_2561> comp_1846;

    public MapDecorationType type() {
        return (MapDecorationType)this.comp_1842.comp_349();
    }

    public Vector2i position() {
        return new Vector2i((int)this.comp_1843, (int)this.comp_1844);
    }

    public void setPosition(Vector2i position) {
        Preconditions.checkState(MapUtil.isInMapDecorationBounds(position.x()), "x position out of bounds");
        Preconditions.checkState(MapUtil.isInMapDecorationBounds(position.y()), "y position out of bounds");
        this.comp_1843 = (byte)position.x();
        this.comp_1844 = (byte)position.y();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    public void setRotation(MapDecorationOrientation dir) {
        this.comp_1845 = (byte)((SpongeMapDecorationOrientation)dir).getOrientationNumber();
        ((MapDecorationBridge)((Object)this)).bridge$markAllDirty();
    }

    public MapDecorationOrientation rotation() {
        int rot = MapUtil.normalizeDecorationOrientation(this.comp_1845);
        return MapUtil.getMapRotById(rot);
    }

    public boolean isPersistent() {
        return ((MapDecorationBridge)((Object)this)).bridge$isPersistent();
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        DataContainer data = DataContainer.createNew().set(Constants.Map.DECORATION_TYPE, (Object)class_7923.field_50078.method_10221((Object)((class_9428)this.comp_1842.comp_349()))).set(Constants.Map.DECORATION_ID, (Object)((MapDecorationBridge)((Object)this)).bridge$getKey()).set(Constants.Map.DECORATION_X, (Object)this.comp_1843).set(Constants.Map.DECORATION_Y, (Object)this.comp_1844).set(Constants.Map.DECORATION_ROTATION, (Object)((byte)MapUtil.normalizeDecorationOrientation(this.comp_1845)));
        this.comp_1846.ifPresent(component -> data.set(Constants.Map.NAME, (Object)class_2561.class_2562.method_10867((class_2561)component, (class_7225.class_7874)SpongeCommon.server().method_30611())));
        return data;
    }
}

