/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.network.channel.ChannelBuffers;

@Mixin(value={class_2540.class})
@Implements(value={@Interface(iface=ChannelBuf.class, prefix="cbuf$", remap=Interface.Remap.NONE)})
public abstract class FriendlyByteBufMixin_API
extends ByteBuf {
    @Shadow
    public abstract class_2540 shadow$method_10813(byte[] var1);

    @Shadow
    public abstract class_2540 shadow$method_10804(int var1);

    @Shadow
    public abstract class_2540 shadow$method_10791(long var1);

    @Shadow
    public abstract class_2540 shadow$method_10814(String var1);

    @Shadow
    public abstract class_2540 shadow$method_10794(@Nullable class_2520 var1);

    @Shadow
    public abstract class_2540 shadow$method_10797(UUID var1);

    @Shadow
    public abstract byte[] shadow$method_10795();

    @Shadow
    public abstract byte[] shadow$method_10803(int var1);

    @Shadow
    public abstract int shadow$method_10816();

    @Shadow
    public abstract long shadow$method_10792();

    @Shadow
    public abstract String shadow$method_10800(int var1);

    @Shadow
    public abstract class_2487 shadow$method_10798() throws IOException;

    @Shadow
    public abstract UUID shadow$method_10790();

    @Intrinsic
    public int cbuf$capacity() {
        return this.capacity();
    }

    public int cbuf$available() {
        return this.writerIndex() - this.readerIndex();
    }

    @Intrinsic
    public int cbuf$readerIndex() {
        return this.readerIndex();
    }

    public ChannelBuf cbuf$readerIndex(int index) {
        this.readerIndex(index);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public int cbuf$writerIndex() {
        return this.writerIndex();
    }

    public ChannelBuf cbuf$writerIndex(int index) {
        this.writerIndex(index);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setIndex(int readIndex, int writeIndex) {
        this.setIndex(readIndex, writeIndex);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$clear() {
        this.clear();
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$slice() {
        return ChannelBuffers.wrap(this.slice());
    }

    public ChannelBuf cbuf$slice(int index, int length) {
        return ChannelBuffers.wrap(this.slice(index, length));
    }

    public ChannelBuf cbuf$readSlice(int length) {
        return ChannelBuffers.wrap(this.readSlice(length));
    }

    @Intrinsic
    public boolean cbuf$hasArray() {
        return this.hasArray();
    }

    @Intrinsic
    public byte[] cbuf$array() {
        return this.array();
    }

    public ChannelBuf cbuf$writeBoolean(boolean data) {
        this.writeBoolean(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setBoolean(int index, boolean data) {
        this.setBoolean(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public boolean cbuf$readBoolean() {
        return this.readBoolean();
    }

    @Intrinsic
    public boolean cbuf$getBoolean(int index) {
        return this.getBoolean(index);
    }

    public ChannelBuf cbuf$writeByte(byte data) {
        this.writeByte(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setByte(int index, byte data) {
        this.setByte(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public byte cbuf$readByte() {
        return this.readByte();
    }

    @Intrinsic
    public byte cbuf$getByte(int index) {
        return this.getByte(index);
    }

    public ChannelBuf cbuf$writeByteArray(byte[] data) {
        return (ChannelBuf)this.shadow$method_10813(data);
    }

    public ChannelBuf cbuf$writeByteArray(byte[] data, int start, int length) {
        this.writeBytes(data, start, length);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setByteArray(int index, byte[] data) {
        this.setBytes(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setByteArray(int index, byte[] data, int start, int length) {
        this.setBytes(index, data, start, length);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public byte[] cbuf$readByteArray() {
        return this.shadow$method_10795();
    }

    @Intrinsic
    public byte[] cbuf$readByteArray(int limit) {
        return this.shadow$method_10803(limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] cbuf$getByteArray(int index) {
        int readerIndex = this.readerIndex();
        try {
            this.readerIndex(index);
            byte[] byArray = this.shadow$method_10795();
            return byArray;
        }
        finally {
            this.readerIndex(readerIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] cbuf$getByteArray(int index, int limit) {
        int readerIndex = this.readerIndex();
        try {
            this.readerIndex(index);
            byte[] byArray = this.shadow$method_10803(limit);
            return byArray;
        }
        finally {
            this.readerIndex(readerIndex);
        }
    }

    public ChannelBuf cbuf$writeBytes(byte[] data) {
        this.writeBytes(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeBytes(byte[] data, int start, int length) {
        this.writeBytes(data, start, length);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setBytes(int index, byte[] data) {
        this.setBytes(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setBytes(int index, byte[] data, int start, int length) {
        this.setBytes(index, data, start, length);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public byte[] cbuf$readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    public byte[] cbuf$readBytes(int index, int length) {
        byte[] dest = new byte[length];
        this.readBytes(dest, index, length);
        return dest;
    }

    public ChannelBuf cbuf$writeShort(short data) {
        this.writeShort(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeShortLE(short data) {
        this.writeShortLE(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setShort(int index, short data) {
        this.setShort(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setShortLE(int index, short data) {
        this.setShortLE(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public short cbuf$readShort() {
        return this.readShort();
    }

    @Intrinsic
    public short cbuf$readShortLE() {
        return this.readShortLE();
    }

    @Intrinsic
    public short cbuf$getShort(int index) {
        return this.getShort(index);
    }

    @Intrinsic
    public short cbuf$getShortLE(int index) {
        return this.getShortLE(index);
    }

    public ChannelBuf cbuf$writeChar(char data) {
        this.writeChar(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setChar(int index, char data) {
        this.setChar(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public char cbuf$readChar() {
        return this.readChar();
    }

    @Intrinsic
    public char cbuf$getChar(int index) {
        return this.getChar(index);
    }

    public ChannelBuf cbuf$writeInt(int data) {
        this.writeInt(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeIntLE(int data) {
        this.writeIntLE(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setInt(int index, int data) {
        this.setInt(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setIntLE(int index, int data) {
        this.setIntLE(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public int cbuf$readInt() {
        return this.readInt();
    }

    @Intrinsic
    public int cbuf$readIntLE() {
        return this.readIntLE();
    }

    @Intrinsic
    public int cbuf$getInt(int index) {
        return this.getInt(index);
    }

    @Intrinsic
    public int cbuf$getIntLE(int index) {
        return this.getIntLE(index);
    }

    public ChannelBuf cbuf$writeLong(long data) {
        this.writeLong(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeLongLE(long data) {
        this.writeLongLE(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setLong(int index, long data) {
        this.setLong(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setLongLE(int index, long data) {
        this.setLongLE(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public long cbuf$readLong() {
        return this.readLong();
    }

    @Intrinsic
    public long cbuf$readLongLE() {
        return this.readLongLE();
    }

    @Intrinsic
    public long cbuf$getLong(int index) {
        return this.getLong(index);
    }

    @Intrinsic
    public long cbuf$getLongLE(int index) {
        return this.getLongLE(index);
    }

    public ChannelBuf cbuf$writeFloat(float data) {
        this.writeFloat(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeFloatLE(float data) {
        this.writeFloatLE(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setFloat(int index, float data) {
        this.setFloat(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setFloatLE(int index, float data) {
        this.setFloatLE(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public float cbuf$readFloat() {
        return this.readFloat();
    }

    @Intrinsic
    public float cbuf$readFloatLE() {
        return this.readFloatLE();
    }

    @Intrinsic
    public float cbuf$getFloat(int index) {
        return this.getFloat(index);
    }

    @Intrinsic
    public float cbuf$getFloatLE(int index) {
        return this.getFloatLE(index);
    }

    public ChannelBuf cbuf$writeDouble(double data) {
        this.writeDouble(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$writeDoubleLE(double data) {
        this.writeDoubleLE(data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setDouble(int index, double data) {
        this.setDouble(index, data);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setDoubleLE(int index, double data) {
        this.setDoubleLE(index, data);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public double cbuf$readDouble() {
        return this.readDouble();
    }

    @Intrinsic
    public double cbuf$readDoubleLE() {
        return this.readDoubleLE();
    }

    @Intrinsic
    public double cbuf$getDouble(int index) {
        return this.getDouble(index);
    }

    @Intrinsic
    public double cbuf$getDoubleLE(int index) {
        return this.getDoubleLE(index);
    }

    public ChannelBuf cbuf$writeVarInt(int value) {
        return (ChannelBuf)this.shadow$method_10804(value);
    }

    public ChannelBuf cbuf$setVarInt(int index, int value) {
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.shadow$method_10804(value);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public int cbuf$readVarInt() {
        return this.shadow$method_10816();
    }

    public int cbuf$getVarInt(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        int value = this.shadow$method_10816();
        this.readerIndex(oldIndex);
        return value;
    }

    public ChannelBuf cbuf$writeVarLong(long value) {
        return (ChannelBuf)this.shadow$method_10791(value);
    }

    public ChannelBuf cbuf$setVarLong(int index, long value) {
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.shadow$method_10791(value);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public long cbuf$readVarLong() {
        return this.shadow$method_10792();
    }

    public long cbuf$getVarLong(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        long value = this.shadow$method_10792();
        this.readerIndex(oldIndex);
        return value;
    }

    public ChannelBuf cbuf$writeString(String data) {
        return (ChannelBuf)this.shadow$method_10814(Objects.requireNonNull(data));
    }

    public ChannelBuf cbuf$setString(int index, String data) {
        Objects.requireNonNull(data);
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.shadow$method_10814(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    public String cbuf$readString() {
        return this.shadow$method_10800(8191);
    }

    public String cbuf$getString(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        String value = this.shadow$method_10800(8191);
        this.readerIndex(oldIndex);
        return value;
    }

    public ChannelBuf cbuf$writeUTF(String data) {
        byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > Short.MAX_VALUE) {
            throw new EncoderException("String too big (was " + data.length() + " bytes encoded, max 32767)");
        }
        this.writeShort(bytes.length);
        this.writeBytes(bytes);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setUTF(int index, String data) {
        Objects.requireNonNull(data, "data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.cbuf$writeUTF(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    public String cbuf$readUTF() {
        short length = this.readShort();
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public String cbuf$getUTF(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        short length = this.readShort();
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        String data = new String(bytes, StandardCharsets.UTF_8);
        this.readerIndex(oldIndex);
        return data;
    }

    public ChannelBuf cbuf$writeUniqueId(UUID data) {
        Objects.requireNonNull(data, "data");
        return (ChannelBuf)this.shadow$method_10797(data);
    }

    public ChannelBuf cbuf$setUniqueId(int index, UUID data) {
        Objects.requireNonNull(data, "data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.shadow$method_10797(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    @Intrinsic
    public UUID cbuf$readUniqueId() {
        return this.shadow$method_10790();
    }

    public UUID getUniqueId(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        UUID data = this.shadow$method_10790();
        this.readerIndex(oldIndex);
        return data;
    }

    public ChannelBuf cbuf$writeDataView(DataView data) {
        class_2487 compound = NBTTranslator.INSTANCE.translate(Objects.requireNonNull(data, "data"));
        this.shadow$method_10794((class_2520)compound);
        return (ChannelBuf)this;
    }

    public ChannelBuf cbuf$setDataView(int index, DataView data) {
        Objects.requireNonNull(data, "data");
        int oldIndex = this.writerIndex();
        this.writerIndex(index);
        this.cbuf$writeDataView(data);
        this.writerIndex(oldIndex);
        return (ChannelBuf)this;
    }

    public DataView cbuf$readDataView() {
        try {
            return NBTTranslator.INSTANCE.translateFrom(this.shadow$method_10798());
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
    }

    public DataView cbuf$getDataView(int index) {
        int oldIndex = this.readerIndex();
        this.readerIndex(index);
        DataView data = this.cbuf$readDataView();
        this.readerIndex(oldIndex);
        return data;
    }
}

