/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.llamalad7.mixinextras.sugar.Local;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_1863;
import net.minecraft.class_2170;
import net.minecraft.class_2995;
import net.minecraft.class_3176;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3324;
import net.minecraft.class_5218;
import net.minecraft.class_5219;
import net.minecraft.class_5455;
import net.minecraft.class_6904;
import net.minecraft.class_7723;
import net.minecraft.class_7726;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.item.recipe.RecipeManager;
import org.spongepowered.api.map.MapStorage;
import org.spongepowered.api.profile.GameProfileManager;
import org.spongepowered.api.resource.ResourceManager;
import org.spongepowered.api.resource.pack.PackRepository;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.service.ServiceProvider;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.generation.config.WorldGenerationConfig;
import org.spongepowered.api.world.server.DataPackManager;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.teleport.TeleportHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.commands.CommandsBridge;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.command.manager.SpongeCommandManager;
import org.spongepowered.common.command.sponge.SpongeCommand;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.map.SpongeMapStorage;
import org.spongepowered.common.profile.SpongeGameProfileManager;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.scheduler.ServerScheduler;
import org.spongepowered.common.user.SpongeUserManager;
import org.spongepowered.common.util.BlockDestructionIdCache;
import org.spongepowered.common.util.UsernameCache;
import org.spongepowered.common.world.server.SpongeWorldManager;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.storage.SpongePlayerDataManager;
import org.spongepowered.common.world.teleport.SpongeTeleportHelper;

@Mixin(value={MinecraftServer.class})
@Implements(value={@Interface(iface=Server.class, prefix="server$", remap=Interface.Remap.NONE)})
public abstract class MinecraftServerMixin_API
implements SpongeServer,
SpongeRegistryHolder {
    @Shadow
    @Final
    private long[] field_47136;
    @Shadow
    @Final
    protected class_5219 field_24372;
    @Shadow
    @Final
    protected class_32.class_5143 field_23784;
    private Iterable<? extends Audience> audiences;
    private ServerScheduler api$scheduler;
    private SpongeWorldManager api$worldManager;
    private SpongeTeleportHelper api$teleportHelper;
    private SpongePlayerDataManager api$playerDataHandler;
    private UsernameCache api$usernameCache;
    private Audience api$broadcastAudience;
    private class_2995 api$scoreboard;
    private SpongeGameProfileManager api$profileManager;
    private MapStorage api$mapStorage;
    private RegistryHolderLogic api$registryHolder;
    private SpongeUserManager api$userManager;
    private SpongeDataPackManager api$dataPackManager;
    private final BlockDestructionIdCache api$blockDestructionIdCache = new BlockDestructionIdCache(0, AtomicInteger::decrementAndGet);

    @Shadow
    public abstract class_1863 shadow$method_3772();

    @Shadow
    public abstract class_3324 shadow$method_3760();

    @Shadow
    public abstract boolean shadow$method_3828();

    @Shadow
    public abstract String shadow$method_3818();

    @Shadow
    public abstract int shadow$method_3780();

    @Shadow
    public abstract void shadow$method_3747(boolean var1);

    @Shadow
    public abstract int shadow$method_3862();

    @Shadow
    public abstract void shadow$method_3803(int var1);

    @Shadow
    public abstract boolean shadow$method_3754();

    @Shadow
    public abstract boolean shadow$method_3852();

    @Shadow
    public abstract boolean shadow$method_3812();

    @Shadow
    public abstract boolean shadow$method_3783();

    @Shadow
    public abstract class_2170 shadow$method_3734();

    @Shadow
    public abstract class_3283 shadow$method_3836();

    @Shadow
    public abstract class_3300 shadow$method_34864();

    @Shadow
    public abstract class_5219 shadow$method_27728();

    @Shadow
    public abstract class_5455.class_6890 method_30611();

    @Shadow
    public abstract boolean method_27902();

    @Shadow
    public abstract boolean method_3724();

    @Inject(method={"<init>(Ljava/lang/Thread;Lnet/minecraft/class_32$class_5143;Lnet/minecraft/class_3283;Lnet/minecraft/class_6904;Ljava/net/Proxy;Lcom/mojang/datafixers/DataFixer;Lnet/minecraft/class_7497;Lnet/minecraft/class_3950;)V"}, at={@At(value="TAIL")})
    public void api$initializeSpongeFieldsfinal(CallbackInfo ci, @Local(argsOnly=true) class_6904 levelStem) {
        this.api$scheduler = new ServerScheduler();
        this.api$worldManager = new SpongeWorldManager((MinecraftServer)this);
        this.api$playerDataHandler = new SpongePlayerDataManager(this);
        this.api$teleportHelper = new SpongeTeleportHelper();
        this.api$mapStorage = new SpongeMapStorage();
        this.api$registryHolder = new RegistryHolderLogic((class_5455)levelStem.comp_358().method_45926());
        this.api$userManager = new SpongeUserManager((MinecraftServer)this);
        this.api$dataPackManager = new SpongeDataPackManager((MinecraftServer)this, this.field_23784.method_27010(class_5218.field_24186));
    }

    public RecipeManager recipeManager() {
        return (RecipeManager)this.shadow$method_3772();
    }

    public DataPackManager dataPackManager() {
        return this.api$dataPackManager;
    }

    public @NonNull Iterable<? extends Audience> audiences() {
        if (this.audiences == null) {
            this.audiences = Iterables.concat((Iterable)this.shadow$method_3760().method_14571(), Collections.singleton(Sponge.game().systemSubject()));
        }
        return this.audiences;
    }

    public ChunkLayout chunkLayout() {
        return SpongeChunkLayout.INSTANCE;
    }

    public Audience broadcastAudience() {
        if (this.api$broadcastAudience == null) {
            this.api$broadcastAudience = this;
        }
        return this.api$broadcastAudience;
    }

    public void setBroadcastAudience(Audience channel) {
        this.api$broadcastAudience = Objects.requireNonNull(channel, "channel");
    }

    public Optional<InetSocketAddress> boundAddress() {
        return Optional.empty();
    }

    public boolean isWhitelistEnabled() {
        return this.shadow$method_3760().method_14614();
    }

    public void setHasWhitelist(boolean enabled) {
        this.shadow$method_3760().method_14557(enabled);
    }

    public boolean isOnlineModeEnabled() {
        return this.shadow$method_3828();
    }

    public boolean isHardcoreModeEnabled() {
        return this.shadow$method_3754();
    }

    public Difficulty difficulty() {
        return (Difficulty)this.field_24372.method_207();
    }

    public GameMode gameMode() {
        return (GameMode)this.field_24372.method_210();
    }

    public boolean isGameModeEnforced() {
        throw new UnsupportedOperationException("Seemingly this disappeared from being possible???");
    }

    public boolean isPVPEnabled() {
        return this.shadow$method_3852();
    }

    public boolean areCommandBlocksEnabled() {
        return this.shadow$method_3812();
    }

    public boolean isMonsterSpawnsEnabled() {
        return this.shadow$method_3783();
    }

    public boolean isAnimalSpawnsEnabled() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMultiWorldEnabled() {
        if (this.method_3724()) return true;
        MinecraftServerMixin_API minecraftServerMixin_API = this;
        if (!(minecraftServerMixin_API instanceof class_3176)) return false;
        class_3176 ds = (class_3176)minecraftServerMixin_API;
        if (!ds.method_16705().field_16811) return false;
        return true;
    }

    public WorldGenerationConfig worldGenerationConfig() {
        class_5219 overworldData = this.shadow$method_27728();
        class_7726 settings = new class_7726(overworldData.method_28057(), new class_7723(this.method_30611().method_30530(class_7924.field_41224)));
        return (WorldGenerationConfig)settings;
    }

    @Override
    public SpongeUserManager userManager() {
        return this.api$userManager;
    }

    @Override
    public SpongeWorldManager worldManager() {
        return this.api$worldManager;
    }

    public TeleportHelper teleportHelper() {
        return this.api$teleportHelper;
    }

    public Stream<ServerPlayer> streamOnlinePlayers() {
        if (this.shadow$method_3760() == null || this.shadow$method_3760().method_14571() == null) {
            return Stream.empty();
        }
        return this.shadow$method_3760().method_14571().stream();
    }

    public Collection<ServerPlayer> onlinePlayers() {
        if (this.shadow$method_3760() == null || this.shadow$method_3760().method_14571() == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Collection)this.shadow$method_3760().method_14571());
    }

    public Optional<ServerPlayer> player(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        if (this.shadow$method_3760() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$method_3760().method_14602(uniqueId));
    }

    public Optional<ServerPlayer> player(String name) {
        if (this.shadow$method_3760() == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ServerPlayer)this.shadow$method_3760().method_14566(name));
    }

    public Component motd() {
        return LegacyComponentSerializer.legacySection().deserialize(this.shadow$method_3818());
    }

    public int maxPlayers() {
        if (this.shadow$method_3760() == null) {
            return 0;
        }
        return this.shadow$method_3760().method_14592();
    }

    public @NonNull Ticks runningTimeTicks() {
        return Ticks.of((long)this.shadow$method_3780());
    }

    public double ticksPerSecond() {
        return 1000.0 / Math.max(50.0, this.averageTickTime());
    }

    public double averageTickTime() {
        return SpongeCommand.getAverage(this.field_47136) / 1000000.0;
    }

    public int targetTicksPerSecond() {
        return 20;
    }

    public void shutdown() {
        this.shadow$method_3747(false);
    }

    public void shutdown(Component kickMessage) {
        Objects.requireNonNull(kickMessage, "kickMessage");
        for (class_3222 player : new ArrayList(this.shadow$method_3760().method_14571())) {
            ((ServerPlayer)player).kick(kickMessage);
        }
        this.shadow$method_3747(false);
    }

    public GameProfileManager gameProfileManager() {
        if (this.api$profileManager == null) {
            this.api$profileManager = new SpongeGameProfileManager(this);
        }
        return this.api$profileManager;
    }

    @Override
    public SpongeGameProfileManager gameProfileManagerIfPresent() {
        return this.api$profileManager;
    }

    @Override
    public SpongeCommandManager commandManager() {
        return ((CommandsBridge)this.shadow$method_3734()).bridge$commandManager();
    }

    public Optional<ResourcePackRequest> server$resourcePack() {
        return Optional.ofNullable(((MinecraftServerBridge)((Object)this)).bridge$getResourcePack());
    }

    public Optional<Scoreboard> serverScoreboard() {
        if (this.api$scoreboard == null) {
            class_3218 world = SpongeCommon.server().method_30002();
            if (world == null) {
                return Optional.empty();
            }
            this.api$scoreboard = world.method_14170();
        }
        return Optional.of((Scoreboard)this.api$scoreboard);
    }

    @Intrinsic
    public int server$playerIdleTimeout() {
        return this.shadow$method_3862();
    }

    @Intrinsic
    public void server$setPlayerIdleTimeout(int timeout) {
        this.shadow$method_3803(timeout);
    }

    public Game game() {
        return Sponge.game();
    }

    public CauseStackManager causeStackManager() {
        return PhaseTracker.getInstance().apiAccess();
    }

    public PackRepository packRepository() {
        return (PackRepository)this.shadow$method_3836();
    }

    public ResourceManager resourceManager() {
        return (ResourceManager)this.shadow$method_34864();
    }

    @Override
    public ServerScheduler scheduler() {
        return this.api$scheduler;
    }

    public boolean onMainThread() {
        return ((MinecraftServer)this).method_18854();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public SpongePlayerDataManager getPlayerDataManager() {
        return this.api$playerDataHandler;
    }

    @Override
    public UsernameCache getUsernameCache() {
        if (this.api$usernameCache == null) {
            this.api$usernameCache = new UsernameCache(this);
        }
        return this.api$usernameCache;
    }

    @Override
    public BlockDestructionIdCache getBlockDestructionIdCache() {
        return this.api$blockDestructionIdCache;
    }

    public void sendMessage(Identity identity, Component message, MessageType type) {
        this.shadow$method_3760().method_43514(SpongeAdventure.asVanilla(message), false);
    }

    public ServiceProvider.ServerScoped serviceProvider() {
        return ((MinecraftServerBridge)((Object)this)).bridge$getServiceProvider();
    }

    public MapStorage mapStorage() {
        return this.api$mapStorage;
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        return this.api$registryHolder;
    }
}

