/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.minecraft.class_266;
import net.minecraft.class_269;
import net.minecraft.class_2995;
import net.minecraft.class_8646;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.scoreboard.Score;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.criteria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.scores.ScoreboardAccessor;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.world.scores.ObjectiveBridge;
import org.spongepowered.common.scoreboard.SpongeObjective;

@Mixin(value={class_2995.class})
public abstract class ServerScoreboardMixin_API
implements Scoreboard {
    @Shadow
    public abstract void method_1158(class_8646 var1, @Nullable class_266 var2);

    public Optional<Objective> objective(String name) {
        Objects.requireNonNull(name);
        class_266 objective = (class_266)((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().get((Object)name);
        return Optional.ofNullable(objective == null ? null : ((ObjectiveBridge)objective).bridge$getSpongeObjective());
    }

    public Optional<Objective> objective(DisplaySlot slot) {
        class_266 objective = ((ScoreboardAccessor)((Object)this)).accessor$displayObjectives().get(slot);
        if (objective != null) {
            return Optional.of(((ObjectiveBridge)objective).bridge$getSpongeObjective());
        }
        return Optional.empty();
    }

    public Set<Objective> objectivesByCriterion(Criterion criterion) {
        if (((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().containsKey((Object)criterion)) {
            return ((List)((ScoreboardAccessor)((Object)this)).accessor$objectivesByCriteria().get((Object)criterion)).stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
        }
        return new HashSet<Objective>();
    }

    public void addObjective(Objective objective) throws IllegalArgumentException {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$addAPIObjective(objective);
    }

    public void updateDisplaySlot(@org.checkerframework.checker.nullness.qual.Nullable Objective objective, DisplaySlot displaySlot) throws IllegalStateException {
        Objects.requireNonNull(displaySlot);
        class_266 mcObjective = ((class_269)this).method_1170(objective.name());
        this.method_1158((class_8646)displaySlot, mcObjective);
    }

    public Set<Objective> objectives() {
        return ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values().stream().map(objective -> ((ObjectiveBridge)objective).bridge$getSpongeObjective()).collect(Collectors.toSet());
    }

    public void removeObjective(Objective objective) {
        Objects.requireNonNull(objective);
        ((ServerScoreboardBridge)((Object)this)).bridge$removeAPIObjective(objective);
    }

    public Set<Score> scores() {
        HashSet<Score> scores = new HashSet<Score>();
        for (class_266 objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            scores.addAll(((ObjectiveBridge)objective).bridge$getSpongeObjective().scores().values());
        }
        return scores;
    }

    public Set<Score> scores(String name) {
        Objects.requireNonNull(name);
        HashSet<Score> scores = new HashSet<Score>();
        for (class_266 objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            ((ObjectiveBridge)objective).bridge$getSpongeObjective().findScore(name).ifPresent(scores::add);
        }
        return scores;
    }

    public void removeScores(String name) {
        Objects.requireNonNull(name);
        for (class_266 objective : ((ScoreboardAccessor)((Object)this)).accessor$objectivesByName().values()) {
            SpongeObjective spongeObjective = ((ObjectiveBridge)objective).bridge$getSpongeObjective();
            spongeObjective.findScore(name).ifPresent(spongeObjective::removeScore);
        }
    }

    @Intrinsic
    public Optional<Team> team(String name) {
        Objects.requireNonNull(name);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByName().get((Object)name));
    }

    public void registerTeam(Team team) throws IllegalArgumentException {
        Objects.requireNonNull(team);
        ((ServerScoreboardBridge)((Object)this)).bridge$registerTeam(team);
    }

    public Set<Team> teams() {
        return new HashSet<Team>((Collection)((ScoreboardAccessor)((Object)this)).accessor$teamsByName().values());
    }

    public Optional<Team> memberTeam(Component member) {
        Objects.requireNonNull(member);
        return Optional.ofNullable((Team)((ScoreboardAccessor)((Object)this)).accessor$teamsByPlayer().get((Object)LegacyComponentSerializer.legacySection().serialize(member)));
    }
}

