/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.pointer.Pointers;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1941;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2784;
import net.minecraft.class_2818;
import net.minecraft.class_2861;
import net.minecraft.class_2881;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3536;
import net.minecraft.class_3611;
import net.minecraft.class_3765;
import net.minecraft.class_3767;
import net.minecraft.class_5218;
import net.minecraft.class_5268;
import net.minecraft.class_5579;
import net.minecraft.class_6757;
import net.minecraft.class_9240;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.raid.Raid;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.OfflineChunk;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.explosion.Explosion;
import org.spongepowered.api.world.generation.ChunkGenerator;
import org.spongepowered.api.world.server.ChunkManager;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.storage.ChunkLayout;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.world.entity.raid.RaidsAccessor;
import org.spongepowered.common.accessor.world.level.dimension.end.EndDragonFightAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.bridge.world.level.chunk.storage.RegionFileBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.data.holder.SpongeServerLocationBaseDataHolder;
import org.spongepowered.common.mixin.api.minecraft.world.level.LevelMixin_API;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.level.chunk.SpongeOfflineChunk;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vector4i;

@Mixin(value={class_3218.class})
public abstract class ServerLevelMixin_API
extends LevelMixin_API<ServerWorld, ServerLocation>
implements ServerWorld,
SpongeServerLocationBaseDataHolder {
    @Shadow
    @Final
    private class_6757<class_2248> field_13949;
    @Shadow
    @Final
    private class_6757<class_3611> field_13951;
    @Shadow
    @Final
    private class_5579<class_1297> field_26935;
    @Shadow
    @Final
    private class_5268 field_24456;
    private volatile @MonotonicNonNull Pointers api$pointers;

    @Shadow
    public abstract void shadow$method_14176(@Nullable class_3536 var1, boolean var2, boolean var3);

    @Shadow
    public abstract void shadow$method_18764(class_2818 var1);

    @Shadow
    public abstract class_3215 shadow$method_14178();

    @Override
    @Shadow
    public abstract @NonNull MinecraftServer shadow$method_8503();

    @Shadow
    public abstract @Nullable class_1297 shadow$method_14190(UUID var1);

    @Shadow
    public abstract List<class_3222> shadow$method_18456();

    @Shadow
    public abstract class_3767 shadow$method_19495();

    @Shadow
    public abstract @Nullable class_3765 shadow$method_19502(class_2338 var1);

    @Shadow
    public abstract @Nullable class_2881 shadow$method_29198();

    @Shadow
    public abstract long shadow$method_8412();

    public long seed() {
        return this.shadow$method_8412();
    }

    public boolean isLoaded() {
        return ((ServerLevelBridge)((Object)this)).bridge$isLoaded();
    }

    public @NonNull Pointers pointers() {
        if (this.api$pointers == null) {
            this.api$pointers = (Pointers)Pointers.builder().withDynamic(Identity.UUID, () -> ((ServerLevelMixin_API)this).uniqueId()).withDynamic(Identity.NAME, () -> this.key().formatted()).withDynamic(Identity.DISPLAY_NAME, () -> this.properties().displayName().orElse(null)).build();
            return this.api$pointers;
        }
        return this.api$pointers;
    }

    public ServerLocation location(Vector3i position) {
        return ServerLocation.of((ServerWorld)this, (Vector3i)Objects.requireNonNull(position, "position"));
    }

    public ServerLocation location(Vector3d position) {
        return ServerLocation.of((ServerWorld)this, (Vector3d)Objects.requireNonNull(position, "position"));
    }

    public ServerWorldProperties properties() {
        return (ServerWorldProperties)this.shadow$method_8401();
    }

    public ChunkGenerator generator() {
        return (ChunkGenerator)this.shadow$method_14178().method_12129();
    }

    public ResourceKey key() {
        return (ResourceKey)this.shadow$method_27983().method_29177();
    }

    public Server engine() {
        return (Server)this.shadow$method_8503();
    }

    public BlockSnapshot createSnapshot(int x, int y, int z) {
        return ((ServerLevelBridge)((Object)this)).bridge$createSnapshot(x, y, z);
    }

    public boolean restoreSnapshot(BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)Objects.requireNonNull(snapshot, "snapshot").withLocation(this.location(snapshot.position()))).restore(force, Objects.requireNonNull(flag, "flag"));
    }

    public boolean restoreSnapshot(int x, int y, int z, BlockSnapshot snapshot, boolean force, BlockChangeFlag flag) {
        return ((BlockSnapshot)Objects.requireNonNull(snapshot, "snapshot").withLocation((ServerLocation)this.location(x, y, z))).restore(force, Objects.requireNonNull(flag, "flag"));
    }

    public Path directory() {
        return ((ServerLevelBridge)((Object)this)).bridge$getLevelSave().method_27010(class_5218.field_24188);
    }

    private boolean impl$save(boolean flush) {
        SerializationBehavior behavior = ((ServerLevelDataBridge)this.field_24456).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
        ((ServerLevelBridge)((Object)this)).bridge$setManualSave(true);
        this.shadow$method_14176(null, flush, false);
        return !behavior.equals((Object)SerializationBehavior.NONE);
    }

    public boolean save() {
        return this.impl$save(false);
    }

    public boolean saveAndFlush() {
        return this.impl$save(true);
    }

    public boolean unloadChunk(WorldChunk chunk) {
        this.shadow$method_18764((class_2818)Objects.requireNonNull(chunk, "chunk"));
        return true;
    }

    public void triggerExplosion(Explosion explosion) {
        ((ServerLevelBridge)((Object)this)).bridge$triggerExplosion(Objects.requireNonNull(explosion, "explosion"));
    }

    @Override
    public Collection<ServerPlayer> players() {
        return Collections.unmodifiableCollection(ImmutableList.copyOf(this.shadow$method_18456()));
    }

    public Collection<Entity> entities() {
        Iterable all = this.field_26935.method_31841().method_31803();
        List returningList = StreamSupport.stream(all.spliterator(), false).collect(Collectors.toList());
        return Collections.unmodifiableCollection(returningList);
    }

    public Collection<Raid> raids() {
        return ((RaidsAccessor)this.shadow$method_19495()).accessor$raidMap().values();
    }

    public Optional<Raid> raidAt(Vector3i blockPosition) {
        return Optional.ofNullable((Raid)this.shadow$method_19502(VecHelper.toBlockPos(Objects.requireNonNull(blockPosition, "blockPosition"))));
    }

    public Optional<BossBar> dragonFightBossBar() {
        @Nullable class_2881 fight = this.shadow$method_29198();
        if (fight != null) {
            return Optional.of(SpongeAdventure.asAdventure((class_1259)((EndDragonFightAccessor)fight).accessor$dragonEvent()));
        }
        return Optional.empty();
    }

    public boolean contains(int x, int y, int z) {
        return ((class_3218)this).method_24794(new class_2338(x, y, z));
    }

    @Override
    public Optional<Entity> entity(UUID uniqueId) {
        return Optional.ofNullable((Entity)this.shadow$method_14190(Objects.requireNonNull(uniqueId, "uniqueId")));
    }

    public void removeBlockEntity(int x, int y, int z) {
        this.blockEntity(x, y, z).ifPresent(ignored -> this.removeBlock(x, y, z));
    }

    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        return (ScheduledUpdateList)this.field_13949;
    }

    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        return (ScheduledUpdateList)this.field_13951;
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        return ServerLocation.of((ServerWorld)this, (int)x, (int)y, (int)z);
    }

    public void setWeather(WeatherType type) {
        this.properties().setWeather(Objects.requireNonNull(type, "type"));
    }

    public void setWeather(WeatherType type, Ticks ticks) {
        this.properties().setWeather(Objects.requireNonNull(type, "type"), Objects.requireNonNull(ticks, "ticks"));
    }

    public ChunkLayout chunkLayout() {
        if (this.api$chunkLayout == null) {
            int height = ((class_3218)this).method_31605();
            int min = ((class_3218)this).method_31607();
            this.api$chunkLayout = new SpongeChunkLayout(min, height);
        }
        return this.api$chunkLayout;
    }

    public WorldBorder setBorder(WorldBorder border) {
        WorldBorderBridge borderBridge = (WorldBorderBridge)((class_1941)this).method_8621();
        borderBridge.bridge$setAssociatedWorld(this.key());
        WorldBorder worldBorder = borderBridge.bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)class_2784.field_24122;
        }
        this.field_24456.method_27415((class_2784.class_5200)border);
        return worldBorder;
    }

    public ChunkManager chunkManager() {
        return (ChunkManager)this.shadow$method_14178().field_17254;
    }

    public <T> Stream<T> api$chunkPosStream(BiFunction<class_2861, Stream<class_1923>, Stream<T>> mapper) {
        Path dimensionPath = ((ServerLevelBridge)((Object)this)).bridge$getLevelSave().method_27424(this.shadow$method_27983());
        Path regionPath = dimensionPath.resolve("region");
        return Stream.generate(() -> {
            try {
                return Stream.of(Files.newDirectoryStream(regionPath, "*.mca"));
            }
            catch (IOException ex) {
                SpongeCommon.logger().error("Could not find region files", (Throwable)ex);
                return Stream.empty();
            }
        }).limit(1L).flatMap(Function.identity()).flatMap(stream -> (Stream)StreamSupport.stream(stream.spliterator(), false).flatMap(path -> {
            try {
                class_2861 regionFile = new class_2861(new class_9240("sponge:chunkPosStream:" + String.valueOf(this.shadow$method_27983()), this.shadow$method_27983(), "chunk"), path, regionPath, true);
                Vector4i regionBound = this.api$pathToRegionPos((Path)path);
                Stream chunkPosStream = IntStream.rangeClosed(regionBound.x(), regionBound.z()).mapToObj(x -> IntStream.rangeClosed(regionBound.y(), regionBound.w()).mapToObj(z -> new class_1923(x, z))).flatMap(Function.identity());
                return (Stream)((Stream)mapper.apply(regionFile, chunkPosStream)).onClose(() -> this.api$close((AutoCloseable)regionFile));
            }
            catch (IOException ignored) {
                return Stream.empty();
            }
        }).onClose(() -> this.api$close((AutoCloseable)stream)));
    }

    public Stream<Vector3i> chunkPositions() {
        return this.api$chunkPosStream((regionFile, stream) -> stream.filter(cp -> ((RegionFileBridge)regionFile).bridge$doesChunkExist((class_1923)cp)).map(cp -> new Vector3i(cp.field_9181, 0, cp.field_9180)));
    }

    public Stream<OfflineChunk> offlineChunks() {
        return this.api$chunkPosStream((regionFile, stream) -> stream.map(cp -> SpongeOfflineChunk.of(regionFile, cp)).filter(Objects::nonNull));
    }

    private void api$close(AutoCloseable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Vector4i api$pathToRegionPos(Path regionPath) {
        String[] split = regionPath.getFileName().toString().split("\\.");
        int rx = Integer.parseInt(split[1]);
        int ry = Integer.parseInt(split[2]);
        class_1923 min = class_1923.method_42305((int)rx, (int)ry);
        class_1923 max = class_1923.method_42306((int)rx, (int)ry);
        return new Vector4i(min.field_9181, min.field_9180, max.field_9181, max.field_9180);
    }
}

