/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.chat.SignedMessage;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.text.Component;
import net.minecraft.class_1297;
import net.minecraft.class_161;
import net.minecraft.class_243;
import net.minecraft.class_2535;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5889;
import net.minecraft.class_7469;
import net.minecraft.class_7471;
import net.minecraft.class_7617;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.AdvancementTemplate;
import org.spongepowered.api.advancement.AdvancementTree;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.entity.living.player.tab.TabList;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.message.PlayerChatEvent;
import org.spongepowered.api.event.world.ChangeWorldBorderEvent;
import org.spongepowered.api.network.ServerConnectionState;
import org.spongepowered.api.network.ServerSideConnection;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.accessor.server.network.ServerCommonPacketListenerImplAccessor;
import org.spongepowered.common.accessor.server.network.ServerGamePacketListenerImplAccessor;
import org.spongepowered.common.accessor.world.level.border.WorldBorderAccessor;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.bridge.server.ServerScoreboardBridge;
import org.spongepowered.common.bridge.server.level.ServerPlayerBridge;
import org.spongepowered.common.bridge.server.network.ServerCommonPacketListenerImplBridge;
import org.spongepowered.common.bridge.server.network.ServerGamePacketListenerImplBridge;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.entity.player.SpongeUserView;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.mixin.api.minecraft.world.entity.player.PlayerMixin_API;
import org.spongepowered.common.profile.SpongeGameProfile;
import org.spongepowered.common.util.NetworkUtil;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerMixin_API
extends PlayerMixin_API
implements ServerPlayer {
    @Shadow
    @Final
    public MinecraftServer field_13995;
    @Shadow
    @Final
    private class_2985 field_13970;
    @Shadow
    public class_3244 field_13987;
    @Shadow
    private @Nullable class_243 field_35008;
    private volatile Pointers api$pointers;

    @Shadow
    public abstract class_3218 shadow$method_51469();

    @Shadow
    public abstract void shadow$method_64398(class_2561 var1);

    public ServerWorld world() {
        return (ServerWorld)this.shadow$method_51469();
    }

    public User user() {
        return SpongeUserView.create(this.field_6021);
    }

    public boolean isOnline() {
        if (this.impl$isFake) {
            return true;
        }
        return this.field_13995.method_3760().method_14602(this.field_6021) == (class_3222)this;
    }

    public GameProfile profile() {
        return SpongeGameProfile.of(this.shadow$method_7334());
    }

    public ServerSideConnection connection() {
        class_2535 connection = ((ServerCommonPacketListenerImplAccessor)this.field_13987).accessor$connection();
        return (ServerSideConnection)((ConnectionBridge)connection).bridge$getEngineConnection();
    }

    public ServerConnectionState.Game connectionState() {
        return (ServerConnectionState.Game)this.field_13987;
    }

    @Overwrite
    public String method_14209() {
        return NetworkUtil.getHostString(((ServerCommonPacketListenerImplAccessor)this.field_13987).accessor$connection().method_10755());
    }

    public String identifier() {
        return this.field_6021.toString();
    }

    public void setScoreboard(Scoreboard scoreboard) {
        Objects.requireNonNull(scoreboard, "scoreboard");
        ((ServerScoreboardBridge)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard()).bridge$removePlayer((class_3222)this, true);
        ((ServerPlayerBridge)((Object)this)).bridge$replaceScoreboard(scoreboard);
        ((ServerScoreboardBridge)((ServerPlayerBridge)((Object)this)).bridge$getScoreboard()).bridge$addPlayer((class_3222)this, true);
    }

    @Override
    public Component teamRepresentation() {
        return SpongeAdventure.asAdventure(this.shadow$method_5477());
    }

    public Scoreboard scoreboard() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getScoreboard();
    }

    public boolean kick() {
        return this.kick((Component)Component.translatable((String)"disconnect.disconnected"));
    }

    public boolean kick(Component message) {
        return ((ServerPlayerBridge)((Object)this)).bridge$kick(Objects.requireNonNull(message, "message"));
    }

    public TabList tabList() {
        return ((ServerGamePacketListenerImplBridge)this.field_13987).bridge$tabList();
    }

    public boolean respawn() {
        if (this.impl$isFake) {
            return false;
        }
        if (this.shadow$method_6032() > 0.0f) {
            return false;
        }
        this.field_13987.field_14140 = this.field_13995.method_3760().method_14556((class_3222)this, false, class_1297.class_5529.field_26999);
        return true;
    }

    public void simulateChat(Component message, Cause cause) {
        Objects.requireNonNull(message, "message");
        Objects.requireNonNull(cause, "cause");
        PlayerChatEvent.Decorate event = SpongeEventFactory.createPlayerChatEventDecorate((Cause)cause, (Component)message, (Component)message, Optional.of(this));
        if (!SpongeCommon.post((Event)event)) {
            class_2561 decoratedMessage = SpongeAdventure.asVanilla(event.message());
            class_2556.class_7602 boundType = class_2556.method_44834((class_5321)class_2556.field_11737, (class_5455)this.field_13995.method_30611(), (class_2561)this.method_5477());
            class_3222 thisPlayer = (class_3222)this;
            this.field_13995.method_3760().method_43673(class_7471.method_45041((String)decoratedMessage.getString()), thisPlayer, boundType);
        }
    }

    public @NonNull Optional<WorldBorder> worldBorder() {
        @Nullable class_2784 border = ((ServerPlayerBridge)((Object)this)).bridge$getWorldBorder();
        if (border == null) {
            return Optional.empty();
        }
        return Optional.of(((WorldBorderBridge)border).bridge$asImmutable());
    }

    public CooldownTracker cooldownTracker() {
        return (CooldownTracker)this.shadow$method_7357();
    }

    public AdvancementProgress progress(AdvancementTemplate advancement) {
        Objects.requireNonNull(advancement, "advancement");
        class_8779 holder = new class_8779((class_2960)advancement.key(), (class_161)advancement.advancement());
        return (AdvancementProgress)this.field_13970.method_12882(holder);
    }

    public Collection<AdvancementTree> unlockedAdvancementTrees() {
        if (this.impl$isFake) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(((PlayerAdvancementsBridge)this.field_13970).bridge$getAdvancementTrees());
    }

    public @NonNull Optional<WorldBorder> setWorldBorder(@Nullable WorldBorder border) {
        Optional toSet;
        if (this.impl$isFake) {
            return Optional.empty();
        }
        Optional<WorldBorder> currentBorder = this.worldBorder();
        if (Objects.equals(currentBorder.orElse(null), border)) {
            return currentBorder;
        }
        ChangeWorldBorderEvent.Player event = SpongeEventFactory.createChangeWorldBorderEventPlayer((Cause)PhaseTracker.getInstance().currentCause(), Optional.ofNullable(border), Optional.ofNullable(border), (ServerPlayer)this, Optional.ofNullable(border));
        if (SpongeCommon.post((Event)event)) {
            return currentBorder;
        }
        @Nullable class_2784 oldWorldBorder = ((ServerPlayerBridge)((Object)this)).bridge$getWorldBorder();
        if (oldWorldBorder != null) {
            ((WorldBorderAccessor)oldWorldBorder).accessor$listeners().remove(((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
        }
        if ((toSet = event.newBorder()).isPresent()) {
            class_2784 mutableWorldBorder = new class_2784();
            ((WorldBorderBridge)mutableWorldBorder).bridge$applyFrom((WorldBorder)toSet.get());
            ((ServerPlayerBridge)((Object)this)).bridge$replaceWorldBorder(mutableWorldBorder);
            mutableWorldBorder.method_11983((class_2780)((ServerPlayerBridge)((Object)this)).bridge$getWorldBorderListener());
            this.field_13987.method_14364((class_2596)new class_5889(mutableWorldBorder));
        } else {
            ((ServerPlayerBridge)((Object)this)).bridge$replaceWorldBorder(null);
            this.field_13987.method_14364((class_2596)new class_5889(this.shadow$method_5770().method_8621()));
        }
        return toSet;
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.requireValue(Keys.CHAT_COLORS_ENABLED).asImmutable());
        values.add(this.requireValue(Keys.CHAT_VISIBILITY).asImmutable());
        values.add(this.requireValue(Keys.GAME_MODE).asImmutable());
        values.add(this.requireValue(Keys.HAS_VIEWED_CREDITS).asImmutable());
        values.add(this.requireValue(Keys.LOCALE).asImmutable());
        values.add(this.requireValue(Keys.PREVIOUS_GAME_MODE).asImmutable());
        values.add((Value.Immutable<?>)((SetValue)this.requireValue(Keys.SKIN_PARTS)).asImmutable());
        values.add(this.requireValue(Keys.SPECTATOR_TARGET).asImmutable());
        values.add(this.requireValue(Keys.VIEW_DISTANCE).asImmutable());
        this.getValue(Keys.HEALTH_SCALE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SKIN_PROFILE_PROPERTY).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Pointers pointers() {
        Pointers pointers = this.api$pointers;
        if (pointers == null) {
            ServerPlayerMixin_API serverPlayerMixin_API = this;
            synchronized (serverPlayerMixin_API) {
                if (this.api$pointers != null) {
                    return this.api$pointers;
                }
                this.api$pointers = pointers = (Pointers)Pointers.builder().withDynamic(Identity.NAME, () -> ((class_3222)this).method_7334().getName()).withDynamic(Identity.DISPLAY_NAME, () -> (Component)this.displayName().get()).withDynamic(Identity.UUID, () -> ((class_1297)((class_1297)this)).method_5667()).withDynamic(Identity.LOCALE, this::locale).withStatic(PermissionChecker.POINTER, permission -> SpongeAdventure.asAdventure(this.permissionValue(permission))).build();
            }
        }
        return pointers;
    }

    @Deprecated
    public void sendMessage(Identity identity, Component message, MessageType type) {
        if (this.impl$isFake) {
            return;
        }
        this.shadow$method_64398(SpongeAdventure.asVanilla(Objects.requireNonNull(message, "message")));
    }

    public void sendMessage(@NonNull Component message) {
        if (this.impl$isFake) {
            return;
        }
        this.shadow$method_64398(SpongeAdventure.asVanilla(message));
    }

    public void sendMessage(@NonNull Component message, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ChatType.Bound boundChatType) {
        if (this.impl$isFake) {
            return;
        }
        this.field_13987.method_45168(SpongeAdventure.asVanilla(message), SpongeAdventure.asVanilla(this.shadow$method_37908().method_30349(), boundChatType));
    }

    public void sendMessage(@NonNull SignedMessage signedMessage, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull ChatType.Bound boundChatType) {
        if (this.impl$isFake) {
            return;
        }
        this.field_13987.method_45168(SpongeAdventure.asVanilla((Component)Objects.requireNonNullElse(signedMessage.unsignedContent(), Component.text((String)signedMessage.message()))), SpongeAdventure.asVanilla(this.shadow$method_37908().method_30349(), boundChatType));
    }

    public void deleteMessage(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull SignedMessage.Signature signature) {
        if (this.impl$isFake) {
            return;
        }
        this.field_13987.method_14364((class_2596)new class_7617(((class_7469)signature).method_46277(((ServerGamePacketListenerImplAccessor)this.field_13987).accessor$messageSignatureCache())));
    }

    public void sendPlayerListHeader(Component header) {
        this.tabList().setHeader(Objects.requireNonNull(header, "header"));
    }

    public void sendPlayerListFooter(Component footer) {
        this.tabList().setFooter(Objects.requireNonNull(footer, "footer"));
    }

    public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.tabList().setHeaderAndFooter(Objects.requireNonNull(header, "header"), Objects.requireNonNull(footer, "footer"));
    }

    public void showBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        class_3213 vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.method_14088((class_3222)this);
    }

    public void hideBossBar(BossBar bar) {
        if (this.impl$isFake) {
            return;
        }
        class_3213 vanilla = SpongeAdventure.asVanillaServer(Objects.requireNonNull(bar, "bar"));
        vanilla.method_14089((class_3222)this);
    }

    public @NonNull Locale locale() {
        return ((ServerPlayerBridge)((Object)this)).bridge$getLanguage();
    }

    public void sendResourcePacks(@NonNull ResourcePackRequest request) {
        ((ServerCommonPacketListenerImplBridge)this.field_13987).bridge$sendResourcePacks(request);
    }

    public void removeResourcePacks(@NonNull UUID id, UUID ... others) {
        ((ServerCommonPacketListenerImplBridge)this.field_13987).bridge$removeResourcePacks(id, others);
    }

    public void clearResourcePacks() {
        ((ServerCommonPacketListenerImplBridge)this.field_13987).bridge$clearResourcePacks();
    }
}

