/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.level;

import net.minecraft.class_1923;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_9762;
import net.minecraft.class_9770;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.Server;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.generation.GenerationRegion;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_3233.class})
public abstract class WorldGenRegionMixin_API
implements GenerationRegion {
    @Shadow
    @Final
    private class_3218 field_14093;
    @Shadow
    @Final
    private class_2791 field_28557;
    @Shadow
    @Final
    private class_9770 field_51876;
    private ResourceKey api$serverWorldKey;
    private @MonotonicNonNull Vector3i api$minChunk;
    private @MonotonicNonNull Vector3i api$maxChunk;
    private @MonotonicNonNull Vector3i api$minBlock;
    private @MonotonicNonNull Vector3i api$maxBlock;
    private @MonotonicNonNull Vector3i api$size;

    @Shadow
    public abstract class_2791 shadow$method_8392(int var1, int var2);

    @Inject(method={"<init>(Lnet/minecraft/class_3218;Lnet/minecraft/class_9762;Lnet/minecraft/class_9770;Lnet/minecraft/class_2791;)V"}, at={@At(value="RETURN")})
    private void api$getWorldKeyOnConstruction(class_3218 $$0, class_9762 $$1, class_9770 $$2, class_2791 $$3, CallbackInfo ci) {
        this.api$serverWorldKey = (ResourceKey)$$0.method_27983().method_29177();
    }

    public @NonNull ResourceKey worldKey() {
        return this.api$serverWorldKey;
    }

    public @NonNull Server engine() {
        return SpongeCommon.game().server();
    }

    public @NonNull GenerationChunk chunk(int cx, int cy, int cz) {
        class_2791 chunk;
        try {
            chunk = this.shadow$method_8392(cx, cz);
        }
        catch (RuntimeException exception) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Chunk coordinates (%d, %d, %d) is out of bounds.", cx, cy, cz));
        }
        if (chunk instanceof class_2818) {
            return (GenerationChunk)new class_2821((class_2818)chunk, false);
        }
        return (GenerationChunk)chunk;
    }

    public @NonNull Vector3i chunkMin() {
        if (this.api$minChunk == null) {
            class_1923 center = this.field_28557.method_12004();
            int radius = this.field_51876.comp_2804().method_60516();
            this.api$minChunk = VecHelper.toVector3i(center).sub(radius, 0, radius);
        }
        return this.api$minChunk;
    }

    public @NonNull Vector3i chunkMax() {
        if (this.api$maxChunk == null) {
            class_1923 center = this.field_28557.method_12004();
            int radius = this.field_51876.comp_2804().method_60516();
            this.api$maxChunk = VecHelper.toVector3i(center).add(radius, 0, radius);
        }
        return this.api$maxChunk;
    }

    public @NonNull Vector3i min() {
        if (this.api$minBlock == null) {
            this.api$minBlock = this.convertToBlock(this.chunkMin(), false);
        }
        return this.api$minBlock;
    }

    public @NonNull Vector3i max() {
        if (this.api$maxBlock == null) {
            this.api$maxBlock = this.convertToBlock(this.chunkMax(), true);
        }
        return this.api$maxBlock;
    }

    public @NonNull Vector3i size() {
        if (this.api$size == null) {
            this.api$size = this.max().sub(this.min()).add(Vector3i.ONE);
        }
        return this.api$size;
    }

    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    private Vector3i convertToBlock(Vector3i chunk, boolean isMax) {
        SpongeChunkLayout layout = (SpongeChunkLayout)((ServerWorld)this.field_14093).chunkLayout();
        Vector3i chunkMin = layout.forceToWorld(chunk);
        if (isMax) {
            return chunkMin.add(layout.getMask());
        }
        return chunkMin;
    }
}

