/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.packs;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.resource.Resource;
import org.spongepowered.api.resource.ResourcePath;
import org.spongepowered.api.resource.pack.PackContents;
import org.spongepowered.api.resource.pack.PackType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.resource.SpongeResource;
import org.spongepowered.common.resource.SpongeResourcePath;

@Mixin(value={class_3262.class})
public interface PackResourcesMixin_API
extends PackContents {
    @Shadow
    public String shadow$method_14409();

    @Shadow
    public class_7367<InputStream> shadow$method_14405(class_3264 var1, class_2960 var2) throws IOException;

    @Shadow
    public Set<String> shadow$method_14406(class_3264 var1);

    @Shadow
    public void shadow$method_14408(class_3264 var1, String var2, String var3, class_3262.class_7664 var4);

    default public String name() {
        return this.shadow$method_14409();
    }

    default public Optional<Resource> resource(PackType root, ResourcePath path) throws IOException {
        return Optional.ofNullable(this.api$createResource(root, path));
    }

    default public Resource requireResource(PackType root, ResourcePath path) throws IOException {
        Resource resource = this.api$createResource(root, path);
        if (resource == null) {
            throw new NoSuchElementException(MessageFormat.format("Pack type {} does not contain a resource at {}", root, path));
        }
        return resource;
    }

    default public @Nullable Resource api$createResource(PackType root, ResourcePath path) throws IOException {
        class_3264 packType = (class_3264)Objects.requireNonNull(root, "root");
        class_2960 loc = (class_2960)Objects.requireNonNull(path, "path").key();
        class_7367<InputStream> ioSupplier = this.shadow$method_14405(packType, loc);
        return new SpongeResource(path, (InputStream)ioSupplier.get());
    }

    default public Collection<ResourcePath> paths(PackType root, String namespace, String prefix, Predicate<ResourceKey> filter) {
        Objects.requireNonNull(filter, "filter");
        class_3264 packType = (class_3264)Objects.requireNonNull(root, "root");
        HashSet resources = new HashSet();
        this.shadow$method_14408(packType, Objects.requireNonNull(namespace, "namespace"), Objects.requireNonNull(prefix, "prefix"), (loc, stream) -> {
            if (filter.test((ResourceKey)loc)) {
                resources.add(loc);
            }
        });
        return resources.stream().map(r -> new SpongeResourcePath((ResourceKey)r)).collect(Collectors.toList());
    }

    default public boolean exists(PackType root, ResourcePath path) {
        try {
            class_3264 packType = (class_3264)Objects.requireNonNull(root, "root");
            class_2960 loc = (class_2960)Objects.requireNonNull(path, "path").key();
            class_7367<InputStream> ioSupplier = this.shadow$method_14405(packType, loc);
            return ioSupplier != null;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    default public Set<String> namespaces(PackType root) {
        return this.shadow$method_14406((class_3264)Objects.requireNonNull(root, "root"));
    }
}

