/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.server.players;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_3312;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.profile.GameProfileCache;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.players.GameProfileCache_GameProfileInfoAccessor;
import org.spongepowered.common.profile.SpongeGameProfile;

@Mixin(value={class_3312.class})
public abstract class GameProfileCacheMixin_API
implements GameProfileCache {
    @Shadow
    @Final
    @Mutable
    private final Map<String, GameProfileCache_GameProfileInfoAccessor> field_14312 = new ConcurrentHashMap<String, GameProfileCache_GameProfileInfoAccessor>();
    @Shadow
    @Final
    @Mutable
    private final Map<UUID, GameProfileCache_GameProfileInfoAccessor> field_14310 = new ConcurrentHashMap<UUID, GameProfileCache_GameProfileInfoAccessor>();

    @Shadow
    public abstract Optional<com.mojang.authlib.GameProfile> shadow$method_14512(UUID var1);

    @Shadow
    protected abstract long shadow$method_30169();

    public boolean remove(GameProfile profile) {
        Objects.requireNonNull(profile, "profile");
        UUID uniqueId = profile.uniqueId();
        GameProfileCache_GameProfileInfoAccessor entry = this.field_14310.remove(uniqueId);
        if (entry != null) {
            if (profile.name().isPresent()) {
                this.field_14312.remove(((String)profile.name().get()).toLowerCase(Locale.ROOT));
            }
            return entry.invoker$getExpirationDate().getTime() >= System.currentTimeMillis();
        }
        return false;
    }

    public Collection<GameProfile> remove(Iterable<GameProfile> profiles) {
        Objects.requireNonNull(profiles, "profiles");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        for (GameProfile profile : profiles) {
            if (!this.remove(profile)) continue;
            result.add(profile);
        }
        return result;
    }

    public Collection<GameProfile> removeIf(Predicate<GameProfile> filter) {
        Objects.requireNonNull(filter, "filter");
        ArrayList<GameProfile> result = new ArrayList<GameProfile>();
        Iterator<GameProfileCache_GameProfileInfoAccessor> it = this.field_14310.values().iterator();
        while (it.hasNext()) {
            boolean isExpired;
            GameProfileCache_GameProfileInfoAccessor entry = it.next();
            SpongeGameProfile profile = SpongeGameProfile.of(entry.invoker$getProfile());
            boolean bl = isExpired = entry.invoker$getExpirationDate().getTime() < System.currentTimeMillis();
            if (!isExpired && !filter.test(profile)) continue;
            it.remove();
            profile.name().ifPresent(name -> this.field_14312.remove(name, entry));
            if (isExpired) continue;
            result.add(profile);
        }
        return result;
    }

    public void clear() {
        this.field_14310.clear();
        this.field_14312.clear();
    }

    public Optional<GameProfile> findById(UUID uniqueId) {
        Objects.requireNonNull(uniqueId, "uniqueId");
        return this.shadow$method_14512(uniqueId).map(SpongeGameProfile::of);
    }

    public Map<UUID, Optional<GameProfile>> findByIds(Iterable<UUID> uniqueIds) {
        Objects.requireNonNull(uniqueIds, "uniqueIds");
        HashMap<UUID, Optional<GameProfile>> result = new HashMap<UUID, Optional<GameProfile>>();
        for (UUID uniqueId : uniqueIds) {
            result.put(uniqueId, this.shadow$method_14512(uniqueId).map(SpongeGameProfile::of));
        }
        return result.isEmpty() ? ImmutableMap.of() : ImmutableMap.copyOf(result);
    }

    public Optional<GameProfile> findByName(String name) {
        Objects.requireNonNull(name, "name");
        @Nullable GameProfileCache_GameProfileInfoAccessor entry = this.field_14312.get(name.toLowerCase(Locale.ROOT));
        if (entry != null && System.currentTimeMillis() >= entry.invoker$getExpirationDate().getTime()) {
            com.mojang.authlib.GameProfile profile = entry.invoker$getProfile();
            this.field_14310.remove(profile.getId());
            this.field_14312.remove(profile.getName().toLowerCase(Locale.ROOT));
            entry = null;
        }
        return Optional.ofNullable(this.api$updateLastAccess(entry));
    }

    public Map<String, Optional<GameProfile>> findByNames(Iterable<String> names) {
        Objects.requireNonNull(names, "names");
        HashMap result = Maps.newHashMap();
        for (String name : names) {
            result.put(name, this.findByName(name));
        }
        return ImmutableMap.copyOf((Map)result);
    }

    public Stream<GameProfile> stream() {
        return this.field_14312.values().stream().map(entry -> SpongeGameProfile.of(entry.invoker$getProfile()));
    }

    public Collection<GameProfile> all() {
        return (Collection)this.field_14312.values().stream().map(this::api$updateLastAccess).collect(ImmutableSet.toImmutableSet());
    }

    public Stream<GameProfile> streamOfMatches(String name) {
        String search = Objects.requireNonNull(name, "name").toLowerCase(Locale.ROOT);
        return this.field_14312.values().stream().filter(profile -> profile.invoker$getProfile().getName() != null).filter(profile -> profile.invoker$getProfile().getName().toLowerCase(Locale.ROOT).startsWith(search)).map(this::api$updateLastAccess);
    }

    public Collection<GameProfile> allMatches(String name) {
        return (Collection)this.streamOfMatches(name).collect(ImmutableSet.toImmutableSet());
    }

    private @Nullable SpongeGameProfile api$updateLastAccess(@Nullable GameProfileCache_GameProfileInfoAccessor entry) {
        if (entry == null) {
            return null;
        }
        entry.invoker$setLastAccess(this.shadow$method_30169());
        return SpongeGameProfile.of(entry.invoker$getProfile());
    }
}

