/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.minecraft.class_10182;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.ListValue;
import org.spongepowered.api.data.value.SetValue;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.entity.damage.source.DamageSource;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.util.Transform;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.data.VanishableBridge;
import org.spongepowered.common.bridge.world.entity.EntityBridge;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={class_1297.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$", remap=Interface.Remap.NONE)})
public abstract class EntityMixin_API
implements Entity {
    @Shadow
    private class_243 field_22467;
    @Shadow
    private float field_6031;
    @Shadow
    private float field_5965;
    @Shadow
    @Final
    protected class_5819 field_5974;
    @Shadow
    protected UUID field_6021;
    @Shadow
    @Final
    private class_1299<?> field_5961;
    @Shadow
    private class_1937 field_6002;

    @Shadow
    public abstract double shadow$method_23317();

    @Shadow
    public abstract double shadow$method_23318();

    @Shadow
    public abstract double shadow$method_23321();

    @Shadow
    public abstract class_1937 shadow$method_5770();

    @Shadow
    public abstract @Nullable MinecraftServer shadow$method_5682();

    @Shadow
    public abstract boolean shadow$method_31481();

    @Shadow
    public abstract UUID shadow$method_5667();

    @Shadow
    public abstract boolean shadow$method_64420(class_1282 var1, float var2);

    @Shadow
    protected abstract void shadow$method_5710(float var1, float var2);

    @Shadow
    public abstract class_238 shadow$method_5829();

    @Shadow
    public abstract void shadow$method_31745(class_1297.class_5529 var1);

    @Shadow
    public abstract void shadow$method_31472();

    @Shadow
    public abstract void shadow$method_5702(class_2183.class_2184 var1, class_243 var2);

    @Shadow
    public abstract class_2487 shadow$method_5647(class_2487 var1);

    @Shadow
    public abstract class_1937 shadow$method_37908();

    @Shadow
    public abstract class_243 shadow$method_19538();

    public RandomProvider.Source random() {
        return (RandomProvider.Source)this.field_5974;
    }

    public Vector3d position() {
        return new Vector3d(this.shadow$method_23317(), this.shadow$method_23318(), this.shadow$method_23321());
    }

    public boolean setPosition(Vector3d position) {
        return ((EntityBridge)((Object)this)).bridge$setPosition(Objects.requireNonNull(position, "The position was null!"));
    }

    public World<?, ?> world() {
        return (World)this.field_6002;
    }

    public ServerLocation location() {
        return ServerLocation.of((ServerWorld)((ServerWorld)this.shadow$method_5770()), (Vector3d)this.position());
    }

    public boolean setLocation(ServerLocation location) {
        return ((EntityBridge)((Object)this)).bridge$setLocation(Objects.requireNonNull(location, "The location was null!"));
    }

    public boolean setLocationAndRotation(ServerLocation location, Vector3d rotation) {
        if (this.setLocation(location)) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    public Vector3d scale() {
        return Vector3d.ONE;
    }

    public void setScale(Vector3d scale) {
    }

    public Transform transform() {
        return Transform.of((Vector3d)this.position(), (Vector3d)this.rotation(), (Vector3d)this.scale());
    }

    public boolean setTransform(Transform transform) {
        if (!PhaseTracker.getWorldInstance((class_3218)this.shadow$method_37908()).onSidedThread()) {
            return false;
        }
        Objects.requireNonNull(transform, "The transform cannot be null!");
        if (((EntityBridge)((Object)this)).bridge$setPosition(transform.position())) {
            this.setRotation(transform.rotation());
            this.setScale(transform.scale());
            return true;
        }
        return false;
    }

    public boolean transferToWorld(ServerWorld world, Vector3d position) {
        Objects.requireNonNull(world, "World was null!");
        Objects.requireNonNull(position, "Position was null!");
        return this.setLocation(ServerLocation.of((ServerWorld)world, (Vector3d)position));
    }

    public Vector3d rotation() {
        return new Vector3d(this.field_5965, this.field_6031, 0.0f);
    }

    public void setRotation(Vector3d rotation) {
        Objects.requireNonNull(rotation, "Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if ((class_1297)this instanceof class_3222 && ((class_3222)this).field_13987 != null) {
            ((class_3222)this).field_13987.method_14360(new class_10182(this.field_22467, class_243.field_1353, (float)rotation.y(), (float)rotation.x()), EnumSet.noneOf(class_2709.class));
        } else {
            this.shadow$method_5710((float)rotation.y(), (float)rotation.x());
        }
    }

    public Optional<AABB> boundingBox() {
        class_238 boundingBox = this.shadow$method_5829();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Intrinsic
    public boolean entity$isRemoved() {
        return this.shadow$method_31481();
    }

    public boolean isLoaded() {
        return !this.shadow$method_31481();
    }

    @Intrinsic
    public void entity$remove() {
        this.shadow$method_31745(class_1297.class_5529.field_26999);
    }

    public boolean damage(double damage, DamageSource damageSource) {
        if (!(damageSource instanceof class_1282)) {
            SpongeCommon.logger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.shadow$method_64420((class_1282)damageSource, (float)damage);
    }

    public EntityType type() {
        return (EntityType)this.field_5961;
    }

    public UUID uniqueId() {
        return this.field_6021;
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
        class_2487 compound = new class_2487();
        compound.method_10582("id", entityTypeRegistry.method_10221((Object)((class_1299)this.type())).toString());
        this.shadow$method_5647(compound);
        DataContainer unsafeNbt = NBTTranslator.INSTANCE.translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Entity.CLASS, (Object)this.getClass().getName()).set(Queries.WORLD_KEY, (Object)((ServerWorld)this.world()).key().formatted()).createView(Constants.Sponge.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)this.position().x()).set(Queries.POSITION_Y, (Object)this.position().y()).set(Queries.POSITION_Z, (Object)this.position().z()).container().createView(Constants.Entity.ROTATION).set(Queries.POSITION_X, (Object)this.rotation().x()).set(Queries.POSITION_Y, (Object)this.rotation().y()).set(Queries.POSITION_Z, (Object)this.rotation().z()).container().createView(Constants.Entity.SCALE).set(Queries.POSITION_X, (Object)this.scale().x()).set(Queries.POSITION_Y, (Object)this.scale().y()).set(Queries.POSITION_Z, (Object)this.scale().z()).container().set(Constants.Entity.TYPE, (Object)entityTypeRegistry.method_10221((Object)((class_1299)this.type()))).set(Constants.Sponge.UNSAFE_NBT, (Object)unsafeNbt);
        return container;
    }

    public Entity copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
            class_2487 compound = new class_2487();
            compound.method_10582("id", entityTypeRegistry.method_10221((Object)((class_1299)this.type())).toString());
            this.shadow$method_5647(compound);
            class_1297 entity = class_1299.method_17842((class_2487)compound, (class_1937)this.shadow$method_5770(), (class_3730)class_3730.field_16462, createdEntity -> {
                createdEntity.method_5826(UUID.randomUUID());
                return createdEntity;
            });
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    public boolean canSee(Entity entity) {
        return !((VanishableBridge)entity).bridge$vanishState().invisible();
    }

    public void lookAt(Vector3d targetPos) {
        class_243 vec = VecHelper.toVanillaVector3d(targetPos);
        this.shadow$method_5702(class_2183.class_2184.field_9851, vec);
    }

    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    public EntitySnapshot createSnapshot() {
        return (EntitySnapshot)EntitySnapshot.builder().from((Entity)this).build();
    }

    public EntityArchetype createArchetype() {
        return SpongeEntityArchetypeBuilder.pooled().from(this).build();
    }

    public HoverEvent<HoverEvent.ShowEntity> asHoverEvent(UnaryOperator<HoverEvent.ShowEntity> op) {
        class_2378 entityTypeRegistry = SpongeCommon.vanillaRegistry(class_7924.field_41266);
        class_2960 entityTypeKey = entityTypeRegistry.method_10221((Object)((class_1299)this.type()));
        return HoverEvent.showEntity((HoverEvent.ShowEntity)((HoverEvent.ShowEntity)op.apply(HoverEvent.ShowEntity.of((Key)((Key)entityTypeKey), (UUID)this.uniqueId(), (Component)((Component)this.displayName().get())))));
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        HashSet values = new HashSet();
        values.add(this.requireValue(Keys.AGE).asImmutable());
        values.add(this.requireValue(Keys.BASE_SIZE).asImmutable());
        values.add(this.requireValue(Keys.DISPLAY_NAME).asImmutable());
        values.add(this.requireValue(Keys.EYE_HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.EYE_POSITION).asImmutable());
        values.add(this.requireValue(Keys.FALL_DISTANCE).asImmutable());
        values.add(this.requireValue(Keys.FIRE_DAMAGE_DELAY).asImmutable());
        values.add(this.requireValue(Keys.FROZEN_TIME).asImmutable());
        values.add(this.requireValue(Keys.HEIGHT).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABILITY_TICKS).asImmutable());
        values.add(this.requireValue(Keys.INVULNERABLE).asImmutable());
        values.add(this.requireValue(Keys.IS_CUSTOM_NAME_VISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_GLOWING).asImmutable());
        values.add(this.requireValue(Keys.IS_GRAVITY_AFFECTED).asImmutable());
        values.add(this.requireValue(Keys.IS_INVISIBLE).asImmutable());
        values.add(this.requireValue(Keys.IS_SILENT).asImmutable());
        values.add(this.requireValue(Keys.IS_SNEAKING).asImmutable());
        values.add(this.requireValue(Keys.IS_SPRINTING).asImmutable());
        values.add(this.requireValue(Keys.IS_WET).asImmutable());
        values.add(this.requireValue(Keys.MAX_AIR).asImmutable());
        values.add(this.requireValue(Keys.MAX_FROZEN_TIME).asImmutable());
        values.add(this.requireValue(Keys.ON_GROUND).asImmutable());
        values.add((Value.Immutable<?>)((ListValue)this.requireValue(Keys.PASSENGERS)).asImmutable());
        values.add(this.requireValue(Keys.REMAINING_AIR).asImmutable());
        values.add(this.requireValue(Keys.SCALE).asImmutable());
        values.add((Value.Immutable<?>)((SetValue)this.requireValue(Keys.SCOREBOARD_TAGS)).asImmutable());
        values.add(this.requireValue(Keys.TRANSIENT).asImmutable());
        values.add(this.requireValue(Keys.VANISH_STATE).asImmutable());
        values.add(this.requireValue(Keys.VELOCITY).asImmutable());
        this.getValue(Keys.BASE_VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CREATOR).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.CUSTOM_NAME).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.FIRE_TICKS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.NOTIFIER).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.SWIFTNESS).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.VEHICLE).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    public Component teamRepresentation() {
        return Component.text((String)this.shadow$method_5667().toString());
    }
}

