/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.entity.player;

import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.inventory.Book;
import net.kyori.adventure.sound.Sound;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1796;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.effect.ViewerBridge;
import org.spongepowered.common.bridge.world.entity.PlatformEntityBridge;
import org.spongepowered.common.bridge.world.entity.player.PlayerBridge;
import org.spongepowered.common.effect.SpongeViewer;
import org.spongepowered.common.effect.util.ViewerPacketUtil;
import org.spongepowered.common.mixin.api.minecraft.world.entity.LivingEntityMixin_API;
import org.spongepowered.common.util.BookUtil;

@Mixin(value={class_1657.class})
@Implements(value={@Interface(iface=Identified.class, prefix="identified$", remap=Interface.Remap.NONE)})
public abstract class PlayerMixin_API
extends LivingEntityMixin_API
implements Player,
SpongeViewer {
    @Shadow
    public class_1703 field_7512;
    public final boolean impl$isFake = ((PlatformEntityBridge)((Object)this)).bridge$isFakePlayer();

    @Shadow
    public abstract class_1796 shadow$method_7357();

    @Shadow
    public abstract class_2561 shadow$method_5477();

    @Shadow
    public abstract GameProfile shadow$method_7334();

    @Shadow
    public abstract class_2561 method_5477();

    public String name() {
        return this.shadow$method_5477().getString();
    }

    @Override
    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        Set<Value.Immutable<?>> values = super.api$getVanillaValues();
        values.add(this.requireValue(Keys.AFFECTS_SPAWNING).asImmutable());
        values.add(this.requireValue(Keys.CAN_FLY).asImmutable());
        values.add(this.requireValue(Keys.DOMINANT_HAND).asImmutable());
        values.add(this.requireValue(Keys.EXHAUSTION).asImmutable());
        values.add(this.requireValue(Keys.EXPERIENCE).asImmutable());
        values.add(this.requireValue(Keys.EXPERIENCE_FROM_START_OF_LEVEL).asImmutable());
        values.add(this.requireValue(Keys.EXPERIENCE_LEVEL).asImmutable());
        values.add(this.requireValue(Keys.EXPERIENCE_SINCE_LEVEL).asImmutable());
        values.add(this.requireValue(Keys.FLYING_SPEED).asImmutable());
        values.add(this.requireValue(Keys.FOOD_LEVEL).asImmutable());
        values.add(this.requireValue(Keys.IS_FLYING).asImmutable());
        values.add(this.requireValue(Keys.IS_SLEEPING).asImmutable());
        values.add(this.requireValue(Keys.IS_SLEEPING_IGNORED).asImmutable());
        values.add(this.requireValue(Keys.MAX_EXHAUSTION).asImmutable());
        values.add(this.requireValue(Keys.MAX_FOOD_LEVEL).asImmutable());
        values.add(this.requireValue(Keys.MAX_SATURATION).asImmutable());
        values.add(this.requireValue(Keys.SATURATION).asImmutable());
        values.add(this.requireValue(Keys.SLEEP_TIMER).asImmutable());
        values.add(this.requireValue(Keys.WALKING_SPEED).asImmutable());
        this.getValue(Keys.FIRST_DATE_JOINED).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.LAST_DATE_JOINED).map(Value::asImmutable).ifPresent(values::add);
        this.getValue(Keys.LAST_DATE_PLAYED).map(Value::asImmutable).ifPresent(values::add);
        return values;
    }

    public Identity identified$identity() {
        return this.profile();
    }

    @Override
    public void playMusicDisc(int x, int y, int z, MusicDisc musicDisc) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playMusicDisc(x, y, z, musicDisc, this.shadow$method_37908().method_30349()));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.blockUpdate(x, y, z, this.world()));
    }

    @Override
    public void sendBlockProgress(int x, int y, int z, double progress) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.blockProgress(x, y, z, progress, this.world().engine()));
    }

    @Override
    public void resetBlockProgress(int x, int y, int z) {
        ViewerPacketUtil.resetBlockProgress(x, y, z, this.world().engine()).ifPresent(((ViewerBridge)((Object)this))::bridge$sendToViewer);
    }

    public void playSound(Sound sound, double x, double y, double z) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playSound(sound, this.shadow$method_37908().field_9229, x, y, z));
    }

    public void playSound(Sound sound) {
        this.playSound(sound, this.shadow$method_23317(), this.shadow$method_23318(), this.shadow$method_23321());
    }

    public void playSound(Sound sound, Sound.Emitter emitter) {
        Objects.requireNonNull(emitter, "emitter");
        if (emitter == Sound.Emitter.self()) {
            ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playSound(sound, this));
        } else if (emitter instanceof Entity) {
            Entity entityEmitter = (Entity)emitter;
            ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playSound(sound, entityEmitter));
        } else {
            throw new IllegalArgumentException("Specified emitter '" + String.valueOf(emitter) + "' is not a Sponge Entity or Emitter.self(), was of type '" + String.valueOf(emitter.getClass()) + "'");
        }
    }

    public void openBook(Book book) {
        ((ViewerBridge)((Object)this)).bridge$sendToViewer((class_2596<class_2602>)BookUtil.createFakeBookViewPacket(this, Objects.requireNonNull(book, "book")));
    }

    public Iterable<? extends BossBar> activeBossBars() {
        return ((PlayerBridge)((Object)this)).bridge$getActiveBossBars();
    }
}

