/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import net.minecraft.class_1796;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.entity.living.player.CooldownTracker;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.item.ItemCooldowns_CooldownInstanceAccessor;
import org.spongepowered.common.bridge.world.item.ItemCooldownsBridge;
import org.spongepowered.common.item.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeTicks;

@Mixin(value={class_1796.class})
public abstract class ItemCooldownsMixin_API
implements CooldownTracker {
    @Shadow
    private int field_8025;
    @Shadow
    @Final
    private Map<class_2960, ItemCooldowns_CooldownInstanceAccessor> field_8024;

    @Shadow
    public abstract boolean shadow$method_7904(class_1799 var1);

    @Shadow
    public abstract float shadow$method_7905(class_1799 var1, float var2);

    @Shadow
    public abstract void shadow$method_62835(class_1799 var1, int var2);

    @Shadow
    public abstract void shadow$method_7906(class_2960 var1, int var2);

    @Shadow
    public abstract class_2960 method_62836(class_1799 var1);

    public boolean hasCooldown(ItemStack stack) {
        Objects.requireNonNull(stack, "ItemStack cannot be null!");
        return this.shadow$method_7904(ItemStackUtil.toNative(stack));
    }

    public boolean hasCooldown(ResourceKey group) {
        Objects.requireNonNull(group, "group cannot be null!");
        return this.impl$getCooldownPercent(group) > 0.0f;
    }

    private float impl$getCooldownPercent(Object group) {
        ItemCooldowns_CooldownInstanceAccessor cooldown = this.field_8024.get((class_2960)group);
        if (cooldown != null) {
            float $$4 = cooldown.accessor$endTime() - cooldown.accessor$startTime();
            float $$5 = (float)cooldown.accessor$endTime() - (float)this.field_8025;
            return class_3532.method_15363((float)($$5 / $$4), (float)0.0f, (float)1.0f);
        }
        return 0.0f;
    }

    public Optional<Ticks> cooldown(ItemStack stack) {
        Objects.requireNonNull(stack, "ItemStack cannot be null!");
        class_2960 group = this.method_62836(ItemStackUtil.toNative(stack));
        return this.cooldown((ResourceKey)group);
    }

    public Optional<Ticks> cooldown(ResourceKey group) {
        int remainingCooldown;
        Objects.requireNonNull(group, "group cannot be null!");
        ItemCooldowns_CooldownInstanceAccessor cooldown = this.field_8024.get(group);
        if (cooldown != null && (remainingCooldown = cooldown.accessor$endTime() - this.field_8025) > 0) {
            return Optional.of(Ticks.of((long)remainingCooldown));
        }
        return Optional.empty();
    }

    public boolean setCooldown(ItemStack stack, Ticks ticks) {
        Objects.requireNonNull(stack, "ItemStack cannot be null!");
        this.shadow$method_62835(ItemStackUtil.toNative(stack), SpongeTicks.toSaturatedIntOrInfinite(ticks));
        return ((ItemCooldownsBridge)((Object)this)).bridge$getSetCooldownResult();
    }

    public boolean setCooldown(ResourceKey group, Ticks ticks) {
        Objects.requireNonNull(group, "group cannot be null!");
        this.shadow$method_7906((class_2960)group, SpongeTicks.toSaturatedIntOrInfinite(ticks));
        return ((ItemCooldownsBridge)((Object)this)).bridge$getSetCooldownResult();
    }

    public boolean resetCooldown(ItemStack stack) {
        return this.setCooldown(stack, Ticks.zero());
    }

    public boolean resetCooldown(ResourceKey group) {
        return this.setCooldown(group, Ticks.zero());
    }

    public OptionalDouble fractionRemaining(ItemStack stack) {
        Objects.requireNonNull(stack, "ItemStack cannot be null!");
        float cooldown = this.shadow$method_7905(ItemStackUtil.toNative(stack), 0.0f);
        if (cooldown > 0.0f) {
            return OptionalDouble.of(cooldown);
        }
        return OptionalDouble.empty();
    }

    public OptionalDouble fractionRemaining(ResourceKey group) {
        Objects.requireNonNull(group, "group cannot be null!");
        float cooldown = this.impl$getCooldownPercent(group);
        if (cooldown > 0.0f) {
            return OptionalDouble.of(cooldown);
        }
        return OptionalDouble.empty();
    }
}

