/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9285;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.spongepowered.api.data.SerializableDataHolder;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.entity.attribute.AttributeModifier;
import org.spongepowered.api.entity.attribute.type.AttributeType;
import org.spongepowered.api.item.ItemType;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.equipment.EquipmentType;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.adventure.SpongeAdventure;
import org.spongepowered.common.item.SpongeItemStack;
import org.spongepowered.common.item.SpongeItemStackSnapshot;

@Mixin(value={class_1799.class})
@Implements(value={@Interface(iface=ItemStack.class, prefix="itemStack$", remap=Interface.Remap.NONE)})
public abstract class ItemStackMixin_API
implements SerializableDataHolder.Mutable,
ComponentLike,
HoverEventSource<HoverEvent.ShowItem> {
    @Shadow
    public abstract int shadow$method_7947();

    @Shadow
    public abstract void shadow$method_7939(int var1);

    @Shadow
    public abstract int shadow$method_7914();

    @Shadow
    public abstract boolean shadow$method_7960();

    @Shadow
    public abstract class_1799 shadow$method_7972();

    @Shadow
    public abstract class_1792 shadow$method_7909();

    @Shadow
    public abstract class_2561 shadow$method_7954();

    @Shadow
    public abstract void shadow$method_57366(class_9326 var1);

    @Shadow
    public abstract class_9326 shadow$method_57380();

    @Shadow
    @Nullable
    public abstract <T> T shadow$method_57368(class_9331<T> var1, T var2, UnaryOperator<T> var3);

    public int itemStack$quantity() {
        return this.shadow$method_7947();
    }

    public ItemType itemStack$type() {
        return (ItemType)this.shadow$method_7909();
    }

    public void itemStack$setQuantity(int quantity) throws IllegalArgumentException {
        this.shadow$method_7939(quantity);
    }

    public boolean validateRawData(DataView container) {
        Objects.requireNonNull(container);
        return false;
    }

    public void setRawData(DataView container) throws InvalidDataException {
        Objects.requireNonNull(container);
        if (this.shadow$method_7960()) {
            throw new IllegalArgumentException("Cannot set data on empty item stacks!");
        }
        try {
            this.shadow$method_57366(SpongeItemStack.patchFromData(container));
        }
        catch (Exception e) {
            throw new InvalidDataException("Unable to set raw data or translate raw data for ItemStack setting", (Throwable)e);
        }
    }

    public ItemStack itemStack$asMutable() {
        return (ItemStack)this;
    }

    public ItemStack itemStack$asMutableCopy() {
        return this.itemStack$copy();
    }

    public ItemStackSnapshot itemStack$asImmutable() {
        return new SpongeItemStackSnapshot((ItemStack)this);
    }

    public SerializableDataHolder.Mutable copy() {
        return this.itemStack$copy();
    }

    public ItemStack itemStack$copy() {
        return (ItemStack)this.shadow$method_7972();
    }

    public Collection<AttributeModifier> itemStack$attributeModifiers(AttributeType attributeType, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        ImmutableList.Builder builder = ImmutableList.builder();
        class_9285 modifiers = (class_9285)((class_1799)this).method_57825(class_9334.field_49636, (Object)class_9285.field_49326);
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            if (!((class_1320)entry.comp_2395().comp_349()).equals(attributeType) || !entry.comp_2397().method_57286((class_1304)equipmentType)) continue;
            builder.add((Object)((AttributeModifier)entry.comp_2396()));
        }
        return builder.build();
    }

    public void itemStack$addAttributeModifier(AttributeType attributeType, AttributeModifier modifier, EquipmentType equipmentType) {
        Objects.requireNonNull(attributeType, "Attribute type cannot be null");
        Objects.requireNonNull(modifier, "Attribute modifier cannot be null");
        Objects.requireNonNull(equipmentType, "Equipment type cannot be null");
        this.shadow$method_57368(class_9334.field_49636, class_9285.field_49326, component -> component.method_57484(class_7923.field_41190.method_47983((Object)((class_1320)attributeType)), (class_1322)modifier, SpongeItemStack.asEquipmentSlotGroup(equipmentType)));
    }

    public int contentVersion() {
        return 3;
    }

    public DataContainer toContainer() {
        return SpongeItemStack.getDataContainer((class_1799)this);
    }

    public boolean itemStack$equalTo(ItemStack that) {
        return class_1799.method_7973((class_1799)((class_1799)this), (class_1799)((class_1799)that));
    }

    @Intrinsic
    public boolean itemStack$isEmpty() {
        return this.shadow$method_7960();
    }

    public Component asComponent() {
        return SpongeAdventure.asAdventure(this.shadow$method_7954());
    }

    public @NonNull HoverEvent<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> asHoverEvent(@NonNull UnaryOperator<// Could not load outer class - annotation placement on inner may be incorrect
    HoverEvent.ShowItem> op) {
        HoverEvent.ShowItem event = HoverEvent.ShowItem.showItem((Keyed)SpongeAdventure.asAdventure(SpongeCommon.vanillaRegistry(class_7924.field_41197).method_10221((Object)this.shadow$method_7909())), (int)this.shadow$method_7947(), Map.of());
        return HoverEvent.showItem((HoverEvent.ShowItem)((HoverEvent.ShowItem)Objects.requireNonNull(op, "op").apply(event)));
    }
}

