/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.item.crafting;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_10289;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.item.inventory.ItemStackLike;
import org.spongepowered.api.item.recipe.Recipe;
import org.spongepowered.api.item.recipe.RecipeManager;
import org.spongepowered.api.item.recipe.RecipeType;
import org.spongepowered.api.item.recipe.cooking.CookingRecipe;
import org.spongepowered.api.item.recipe.crafting.RecipeInput;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.item.crafting.RecipeMapAccessor;
import org.spongepowered.common.inventory.util.InventoryUtil;
import org.spongepowered.common.item.util.ItemStackUtil;

@Mixin(value={class_1863.class})
public abstract class RecipeManagerMixin_API
implements RecipeManager {
    @Shadow
    private class_10289 field_54638;

    @Shadow
    public abstract Collection<class_8786<?>> shadow$method_8126();

    @Shadow
    public abstract <I extends class_9695, T extends class_1860<I>> Optional<class_8786<T>> shadow$method_8132(class_3956<T> var1, I var2, class_1937 var3);

    public Optional<Recipe<?>> byKey(ResourceKey key) {
        Objects.requireNonNull(key);
        for (Map.Entry<class_5321<class_1860<?>>, class_8786<?>> entry : ((RecipeMapAccessor)this.field_54638).accessor$byKey().entrySet()) {
            if (!entry.getKey().method_29177().equals((Object)key)) continue;
            return Optional.of(entry.getValue()).map(class_8786::comp_1933).map(Recipe.class::cast);
        }
        return Optional.empty();
    }

    public Collection<Recipe<?>> all() {
        return this.shadow$method_8126().stream().map(class_8786::comp_1933).toList();
    }

    public <T extends Recipe<?>> Collection<T> allOfType(RecipeType<T> type) {
        Objects.requireNonNull(type);
        return this.field_54638.method_64698((class_3956)type).stream().map(h -> ((class_8786)h).comp_1933()).toList();
    }

    public <T extends Recipe<?>> Collection<T> findByResult(RecipeType<T> type, ItemStackLike result) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(result);
        return this.allOfType(type).stream().filter(r -> r.exemplaryResult().equals((Object)result.asImmutable())).collect(Collectors.toList());
    }

    public <I extends RecipeInput, T extends Recipe<I>> Optional<T> findMatchingRecipe(RecipeType<T> type, I inventory, ServerWorld world) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(inventory);
        Objects.requireNonNull(world);
        if (!(inventory instanceof class_1263)) {
            return Optional.empty();
        }
        class_3956 mcRecipeType = (class_3956)type;
        class_1863.class_7266 checker = class_1863.method_42302((class_3956)mcRecipeType);
        class_3218 level = (class_3218)world;
        return InventoryUtil.toCraftingInput(inventory).flatMap(in -> RecipeManagerMixin_API.impl$getRecipe(level, checker, in));
    }

    private static <I extends class_9695, T extends class_1860<I>> Optional<Recipe<?>> impl$getRecipe(class_3218 level, class_1863.class_7266<I, T> checker, I input) {
        return checker.method_42303(input, level).map(class_8786::comp_1933).map(Recipe.class::cast);
    }

    public <T extends CookingRecipe> Optional<T> findCookingRecipe(RecipeType<T> type, ItemStackLike ingredient) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(ingredient);
        class_9696 input = new class_9696(ItemStackUtil.fromLikeToNative(ingredient));
        return this.shadow$method_8132((class_3956)type, input, null).map(h -> ((class_8786)h).comp_1933());
    }
}

