/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_238;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.volume.entity.EntityVolume;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_1924.class})
public interface EntityGetterMixin_API
extends EntityVolume {
    @Shadow
    public List<class_1297> shadow$method_8333(@Nullable class_1297 var1, class_238 var2, @Nullable Predicate<? super class_1297> var3);

    @Shadow
    public <T extends class_1297> List<T> shadow$method_8390(Class<? extends T> var1, class_238 var2, @Nullable Predicate<? super T> var3);

    @Shadow
    public List<? extends class_1657> shadow$method_18456();

    @Shadow
    public List<class_1297> shadow$method_8335(@Nullable class_1297 var1, class_238 var2);

    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    default public boolean contains(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    default public boolean isAreaAvailable(int x, int y, int z) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of EntityGetter that isn't part of Sponge API");
    }

    default public Optional<Entity> entity(UUID uuid) {
        return Optional.empty();
    }

    default public Collection<? extends Player> players() {
        return Collections.unmodifiableCollection(this.shadow$method_18456());
    }

    default public Collection<? extends Entity> entities() {
        return (Collection)ImmutableList.copyOf(this.shadow$method_8335(null, VecHelper.toMinecraftAABB(AABB.of((Vector3i)this.min(), (Vector3i)this.max()))));
    }

    default public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        return this.shadow$method_8333(null, VecHelper.toMinecraftAABB(box), VolumeStreamUtils.apiToImplPredicate(filter));
    }

    default public <E extends Entity> Collection<? extends E> entities(Class<? extends E> entityClass, AABB box, @Nullable Predicate<? super E> predicate) {
        Predicate<class_1297> filter = entity -> predicate == null || entityClass.isInstance(entity) && predicate.test((Object)((Entity)entity));
        List<class_1297> ts = this.shadow$method_8390(entityClass, VecHelper.toMinecraftAABB(box), filter);
        return ts;
    }
}

