/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_4538;
import net.minecraft.class_5217;
import net.minecraft.class_5819;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.difficulty.Difficulty;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={class_1936.class})
@Implements(value={@Interface(iface=WorldLike.class, prefix="worldLike$", remap=Interface.Remap.NONE)})
public interface LevelAccessorMixin_API<P extends WorldLike<P>>
extends WorldLike<P> {
    @Shadow
    public boolean shadow$method_8393(int var1, int var2);

    @Shadow
    public class_5819 shadow$method_8409();

    @Shadow
    public class_5217 shadow$method_8401();

    default public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), class_2248.field_10651, (Registry)((class_1936)this).method_30349().method_30530(class_7924.field_41254));
    }

    default public boolean setBiome(int x, int y, int z, Biome biome) {
        Objects.requireNonNull(biome, "biome");
        class_2791 iChunk = ((class_4538)this).method_22350(new class_2338(x, y, z));
        if (iChunk == null) {
            return false;
        }
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> iChunk.method_38259(iChunk.method_31602(y)), () -> ((class_2791)iChunk).method_65063());
    }

    default public Vector3i min() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + String.valueOf(this.getClass()));
    }

    default public Vector3i max() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + String.valueOf(this.getClass()));
    }

    default public Vector3i size() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + String.valueOf(this.getClass()));
    }

    default public boolean contains(int x, int y, int z) {
        return this.shadow$method_8393(x >> 4, z >> 4);
    }

    default public boolean isAreaAvailable(int x, int y, int z) {
        return this.shadow$method_8393(x >> 4, z >> 4);
    }

    default public Optional<Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of LevelAccessor that isn't part of Sponge API: " + String.valueOf(this.getClass()));
    }

    @Intrinsic
    default public RandomProvider.Source worldLike$random() {
        return (RandomProvider.Source)this.shadow$method_8409();
    }

    default public Difficulty difficulty() {
        return (Difficulty)this.shadow$method_8401().method_207();
    }

    default public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        Objects.requireNonNull(entities, "entities");
        return EntityUtil.spawnEntities(entities, x -> true, e -> e.method_37908().method_8649(e));
    }

    default public boolean spawnEntity(Entity entity) {
        return ((class_1936)this).method_8649((class_1297)Objects.requireNonNull(entity, "entity"));
    }

    default public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        Objects.requireNonNull(blockState, "blockState");
        Objects.requireNonNull(flag, "flag");
        if (!((class_1937)this).method_24794(new class_2338(x, y, z))) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        try (@Nullable PhaseContext<@NonNull ?> context = PluginPhase.State.BLOCK_WORKER.switchIfNecessary(PhaseTracker.getWorldInstance((class_1936)this));){
            if (context != null) {
                context.buildAndSwitch();
            }
            boolean bl = ((class_1936)this).method_8652(new class_2338(x, y, z), (class_2680)blockState, ((SpongeBlockChangeFlag)flag).getRawFlag());
            return bl;
        }
    }
}

