/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.kyori.adventure.sound.Sound;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_3215;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import net.minecraft.class_5217;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.effect.sound.music.MusicDisc;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.service.context.Context;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.LightType;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.volume.MutableVolume;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.biome.BiomeVolume;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeApplicator;
import org.spongepowered.api.world.volume.stream.VolumeApplicators;
import org.spongepowered.api.world.volume.stream.VolumeCollectors;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslator;
import org.spongepowered.api.world.volume.stream.VolumePositionTranslators;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ChunkMapAccessor;
import org.spongepowered.common.accessor.world.entity.EntityAccessor;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.effect.SpongeForwardingViewer;
import org.spongepowered.common.effect.util.ViewerPacketUtil;
import org.spongepowered.common.entity.SpongeEntityTypes;
import org.spongepowered.common.registry.RegistryHolderLogic;
import org.spongepowered.common.registry.SpongeRegistryHolder;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.level.chunk.SpongeEmptyChunk;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.archetype.SpongeArchetypeVolume;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_1937.class})
public abstract class LevelMixin_API<W extends World<W, L>, L extends Location<W, L>>
implements World<W, L>,
SpongeRegistryHolder,
SpongeForwardingViewer,
AutoCloseable {
    @Shadow
    @Final
    public class_5819 field_9229;
    private Context api$context;
    private RegistryHolderLogic api$registryHolder;
    protected @MonotonicNonNull SpongeChunkLayout api$chunkLayout;

    @Shadow
    public abstract @Nullable MinecraftServer shadow$method_8503();

    @Shadow
    public abstract class_5217 shadow$method_8401();

    @Shadow
    public abstract class_5321<class_1937> shadow$method_27983();

    @Shadow
    public abstract void shadow$method_8438(class_2586 var1);

    @Shadow
    public abstract class_2818 shadow$method_8500(class_2338 var1);

    @Shadow
    public abstract List<class_1297> shadow$method_8333(@Nullable class_1297 var1, class_238 var2, @Nullable Predicate<? super class_1297> var3);

    @Shadow
    public abstract <T extends class_1297> List<T> shadow$method_18023(class_5575<class_1297, T> var1, class_238 var2, @Nullable Predicate<? super T> var3);

    public Optional<? extends Player> closestPlayer(int x, int y, int z, double distance, Predicate<? super Player> predicate) {
        return Optional.ofNullable((Player)((class_1937)this).method_8604((double)x, (double)y, (double)z, distance, Objects.requireNonNull(predicate, "predicate")));
    }

    public WorldChunk chunk(int cx, int cy, int cz) {
        class_2791 chunk = ((class_1937)this).method_8402(cx, cz, class_2806.field_12798, true);
        if (chunk instanceof WorldChunk) {
            return (WorldChunk)chunk;
        }
        if (chunk instanceof class_2821) {
            return (WorldChunk)((class_2821)chunk).method_12240();
        }
        return new SpongeEmptyChunk((class_1937)this, chunk);
    }

    public Optional<WorldChunk> loadChunk(int cx, int cy, int cz, boolean shouldGenerate) {
        class_2806 status;
        if (!this.api$chunkLayout().isValidChunk(cx, cy, cz)) {
            return Optional.empty();
        }
        class_2802 chunkProvider = ((class_1936)this).method_8398();
        @Nullable class_2791 chunkAccess = chunkProvider.method_12121(cx, cz, status = shouldGenerate ? class_2806.field_12803 : class_2806.field_12798, true);
        if (chunkAccess == null) {
            return Optional.empty();
        }
        if (chunkAccess instanceof class_2821) {
            return Optional.of((WorldChunk)((class_2821)chunkAccess).method_12240());
        }
        if (chunkAccess instanceof WorldChunk) {
            return Optional.of((WorldChunk)chunkAccess);
        }
        return Optional.empty();
    }

    public Iterable<WorldChunk> loadedChunks() {
        class_2802 chunkProvider = ((class_1936)this).method_8398();
        if (chunkProvider instanceof class_3215) {
            ChunkMapAccessor chunkManager = (ChunkMapAccessor)((class_3215)chunkProvider).field_17254;
            ArrayList<WorldChunk> chunks = new ArrayList<WorldChunk>();
            chunkManager.invoker$getChunks().forEach(holder -> {
                WorldChunk chunk = (WorldChunk)holder.method_16144();
                if (chunk != null) {
                    chunks.add(chunk);
                }
            });
            return chunks;
        }
        return Collections.emptyList();
    }

    @Override
    public RegistryHolderLogic registryHolder() {
        if (this.api$registryHolder == null) {
            this.api$registryHolder = new RegistryHolderLogic(((class_1936)this).method_30349());
        }
        return this.api$registryHolder;
    }

    public int highestYAt(int x, int z) {
        return this.height((HeightType)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    public Vector3i min() {
        return this.api$chunkLayout().spaceMin();
    }

    public Vector3i max() {
        return this.api$chunkLayout().spaceMax();
    }

    public Vector3i size() {
        return this.api$chunkLayout().spaceSize();
    }

    private SpongeChunkLayout api$chunkLayout() {
        if (this.api$chunkLayout == null) {
            int min = ((class_1937)this).method_31607();
            int height = ((class_1937)this).method_31605();
            this.api$chunkLayout = new SpongeChunkLayout(min, height);
        }
        return this.api$chunkLayout;
    }

    public Context context() {
        if (this.api$context == null) {
            this.api$context = new Context("world", this.shadow$method_27983().method_29177().toString());
        }
        return this.api$context;
    }

    @Override
    public void playMusicDisc(int x, int y, int z, MusicDisc musicDisc) {
        this.bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playMusicDisc(x, y, z, musicDisc, ((class_1936)this).method_30349()));
    }

    @Override
    public void resetBlockChange(int x, int y, int z) {
        this.bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.blockUpdate(x, y, z, this));
    }

    @Override
    public void sendBlockProgress(int x, int y, int z, double progress) {
        this.bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.blockProgress(x, y, z, progress, this.engine()));
    }

    @Override
    public void resetBlockProgress(int x, int y, int z) {
        ViewerPacketUtil.resetBlockProgress(x, y, z, this.engine()).ifPresent(this::bridge$sendToViewer);
    }

    public void playSound(Sound sound, double x, double y, double z) {
        this.bridge$sendToViewer((class_2596<class_2602>)ViewerPacketUtil.playSound(sound, this.field_9229, x, y, z));
    }

    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.emptyList();
    }

    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        class_2586 mcOriginalBlockEntity = (class_2586)Objects.requireNonNull(blockEntity, "blockEntity");
        class_2487 tag = mcOriginalBlockEntity.method_38243((class_7225.class_7874)mcOriginalBlockEntity.method_10997().method_30349());
        this.world().setBlock(x, y, z, (BlockState)mcOriginalBlockEntity.method_11010());
        class_2586 mcNewBlockEntity = (class_2586)this.blockEntity(x, y, z).orElseThrow(() -> new IllegalStateException("Failed to create Block Entity at " + String.valueOf(this.location(Vector3i.from((int)x, (int)y, (int)z)))));
        mcNewBlockEntity.method_58690(tag, (class_7225.class_7874)mcOriginalBlockEntity.method_10997().method_30349());
        this.shadow$method_8438(mcNewBlockEntity);
    }

    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), false);
    }

    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        return ((LevelBridge)((Object)this)).bridge$createEntity(Objects.requireNonNull(type, "type"), Objects.requireNonNull(position, "position"), true);
    }

    public Optional<Entity> createEntity(DataContainer container) {
        return (Optional)((LevelBridge)((Object)this)).bridge$createEntity(container, null, null);
    }

    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        return Optional.ofNullable(((LevelBridge)((Object)this)).bridge$createEntity(container, position, null));
    }

    public ArchetypeVolume createArchetypeVolume(Vector3i min, Vector3i max, Vector3i origin) {
        Vector3i rawVolMin = Objects.requireNonNull(min, "min").min(Objects.requireNonNull(max, "max"));
        Vector3i volMax = max.max(min);
        Vector3i size = volMax.sub(rawVolMin).add(1, 1, 1);
        Vector3i relativeMin = rawVolMin.sub(Objects.requireNonNull(origin, "origin"));
        SpongeArchetypeVolume volume = new SpongeArchetypeVolume(relativeMin, size, this);
        this.blockStateStream(min, max, StreamOptions.lazily()).apply(VolumeCollectors.of((MutableVolume)volume, (VolumePositionTranslator)VolumePositionTranslators.offset((Vector3i)origin), (VolumeApplicator)VolumeApplicators.applyBlocks()));
        this.blockEntityStream(min, max, StreamOptions.lazily()).map((world, blockEntity, x, y, z) -> ((BlockEntity)blockEntity.get()).createArchetype()).apply(VolumeCollectors.of((MutableVolume)volume, (VolumePositionTranslator)VolumePositionTranslators.offset((Vector3i)origin), (VolumeApplicator)VolumeApplicators.applyBlockEntityArchetypes()));
        this.biomeStream(min, max, StreamOptions.lazily()).apply(VolumeCollectors.of((MutableVolume)volume, (VolumePositionTranslator)VolumePositionTranslators.offset((Vector3i)origin), (VolumeApplicator)VolumeApplicators.applyBiomes()));
        this.entityStream(min, max, StreamOptions.lazily()).filter((world, entity, x, y, z) -> ((EntityAccessor)entity.get()).invoker$getEncodeId() != null || ((Entity)entity.get()).type() == SpongeEntityTypes.HUMAN).map((world, entity, x, y, z) -> ((Entity)entity.get()).createArchetype()).apply(VolumeCollectors.of((MutableVolume)volume, (VolumePositionTranslator)VolumePositionTranslators.offset((Vector3i)origin), (VolumeApplicator)VolumeApplicators.applyEntityArchetypes()));
        return volume;
    }

    public Optional<Entity> entity(UUID uuid) {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    public Collection<? extends Player> players() {
        throw new UnsupportedOperationException("Unfortunately, you've found an extended class of Level that isn't part of Sponge API");
    }

    public VolumeStream<W, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(min, max, options, this, VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, (class_1937)this), VolumeStreamUtils.getChunkAccessorByStatus((class_4538)this, options.loadingStyle().generateArea()), (key, entity) -> entity.method_5667(), chunk -> chunk instanceof class_2818 ? VolumeStreamUtils.getEntitiesFromChunk(min, max, (class_2818)chunk) : Stream.empty(), (entityUuid, world) -> {
            class_1297 entity;
            class_1297 class_12972 = entity = shouldCarbonCopy ? (class_1297)backingVolume.entity((UUID)entityUuid).orElse(null) : (class_1297)world.entity(entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new class_3545((Object)entity.method_24515(), (Object)entity);
        });
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        if (!((class_1937)this).method_8393(x >> 4, z >> 4)) {
            return false;
        }
        class_2818 levelChunk = this.shadow$method_8500(new class_2338(x, y, z));
        return ((BiomeVolume.Modifiable)levelChunk).setBiome(x, y, z, biome);
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (Entity entity : entities) {
            if (!this.spawnEntity(entity)) continue;
            entityList.add(entity);
        }
        return entityList;
    }

    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> filter) {
        return this.shadow$method_18023(class_5575.method_31795(entityClass), VecHelper.toMinecraftAABB(box), filter);
    }

    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        return this.shadow$method_8333(null, VecHelper.toMinecraftAABB(box), filter);
    }

    public Weather weather() {
        return ((WorldProperties)this.shadow$method_8401()).weather();
    }

    public int light(LightType type, int x, int y, int z) {
        class_1920 thisLevel = (class_1920)this;
        return thisLevel.method_8314((class_1944)type, new class_2338(x, y, z));
    }
}

