/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1920;
import net.minecraft.class_1941;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2874;
import net.minecraft.class_2902;
import net.minecraft.class_4538;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.RandomProvider;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.WorldType;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.border.WorldBorder;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.volume.game.Region;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.bridge.world.level.border.WorldBorderBridge;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_4538.class})
public interface LevelReaderMixin_API<R extends Region<R>>
extends Region<R> {
    @Shadow
    public @Nullable class_2791 shadow$method_8402(int var1, int var2, class_2806 var3, boolean var4);

    @Deprecated
    @Shadow
    public boolean shadow$method_8393(int var1, int var2);

    @Shadow
    public int shadow$method_8624(class_2902.class_2903 var1, int var2, int var3);

    @Shadow
    public int shadow$method_8594();

    @Shadow
    public int shadow$method_8615();

    @Shadow
    public boolean shadow$method_22351(class_2338 var1);

    @Deprecated
    @Shadow
    public boolean shadow$method_22341(int var1, int var2, int var3, int var4, int var5, int var6);

    @Shadow
    public class_2874 shadow$method_8597();

    @Shadow
    public boolean shadow$method_22345(class_238 var1);

    @Shadow
    public class_6880<class_1959> shadow$method_23753(class_2338 var1);

    @Shadow
    public class_5455 shadow$method_30349();

    default public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), class_2248.field_10651, (Registry)this.shadow$method_30349().method_30530(class_7924.field_41254));
    }

    default public WorldType worldType() {
        return (WorldType)this.shadow$method_8597();
    }

    default public WorldBorder border() {
        return ((WorldBorderBridge)((class_1941)this).method_8621()).bridge$asImmutable();
    }

    default public WorldBorder setBorder(WorldBorder border) {
        WorldBorder worldBorder = ((WorldBorderBridge)((class_1941)this).method_8621()).bridge$applyFrom(border);
        if (worldBorder == null) {
            return (WorldBorder)class_2784.field_24122;
        }
        return worldBorder;
    }

    default public boolean isInBorder(Entity entity) {
        return ((class_1941)this).method_8621().method_11966(((class_1297)Objects.requireNonNull(entity, "entity")).method_5829());
    }

    default public boolean canSeeSky(int x, int y, int z) {
        return ((class_1920)this).method_8311(new class_2338(x, y, z));
    }

    default public boolean hasLiquid(int x, int y, int z) {
        return this.shadow$method_22351(new class_2338(x, y, z));
    }

    default public boolean containsAnyLiquids(AABB aabb) {
        Vector3d max = Objects.requireNonNull(aabb, "aabb").max();
        Vector3d min = aabb.min();
        return this.shadow$method_22345(new class_238(min.x(), min.y(), min.z(), max.x(), max.y(), max.z()));
    }

    default public int skylightSubtracted() {
        return this.shadow$method_8594();
    }

    default public int seaLevel() {
        return this.shadow$method_8615();
    }

    default public boolean isAreaLoaded(int xStart, int yStart, int zStart, int xEnd, int yEnd, int zEnd, boolean allowEmpty) {
        return this.shadow$method_22341(xStart, yStart, zStart, xEnd, yEnd, zEnd);
    }

    default public RandomProvider.Source random() {
        return (RandomProvider.Source)class_5819.method_43047();
    }

    default public Chunk<@NonNull ?> chunk(int x, int y, int z) {
        return (Chunk)this.shadow$method_8402(x, z, class_2806.field_12798, true);
    }

    default public boolean isChunkLoaded(int cx, int cy, int cz, boolean allowEmpty) {
        return this.shadow$method_8393(cx, cz);
    }

    default public boolean hasChunk(int cx, int cy, int cz) {
        return this.shadow$method_8393(cx, cz);
    }

    default public int height(HeightType type, int x, int z) {
        return this.shadow$method_8624((class_2902.class_2903)Objects.requireNonNull(type, "type"), x, z);
    }

    default public Biome biome(int x, int y, int z) {
        return (Biome)this.shadow$method_23753(new class_2338(x, y, z)).comp_349();
    }

    default public VolumeStream<R, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBiomeStream((class_4538)this, min, max, options);
    }

    default public VolumeStream<R, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.generateBlockStream((class_4538)this, min, max, options);
    }

    default public VolumeStream<R, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        return VolumeStreamUtils.getBlockEntityStream((class_4538)this, min, max, options);
    }
}

