/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.entity;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.block.entity.SpongeBlockEntityArchetypeBuilder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.server.SpongeLocatableBlockBuilder;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_2586.class})
public abstract class BlockEntityMixin_API
implements BlockEntity {
    @Shadow
    @Final
    private class_2591<?> field_11864;
    @Shadow
    protected class_1937 field_11863;
    @Shadow
    protected boolean field_11865;
    @Shadow
    @Final
    protected class_2338 field_11867;
    private @Nullable LocatableBlock api$LocatableBlock;
    private boolean api$canTickRequested = false;
    private boolean api$canTick;
    private boolean api$isTicking = true;

    @Shadow
    public abstract class_2338 shadow$method_11016();

    @Shadow
    public abstract class_2487 shadow$method_38242(class_7225.class_7874 var1);

    @Shadow
    public abstract class_2680 shadow$method_11010();

    @Shadow
    public abstract void shadow$method_5431();

    public ServerLocation location() {
        return ServerLocation.of((ServerWorld)((ServerWorld)this.field_11863), (Vector3i)VecHelper.toVector3i(this.shadow$method_11016()));
    }

    public ServerLocation serverLocation() {
        if (this.field_11863 == null) {
            throw new RuntimeException("The TileEntity has not been spawned in a world yet!");
        }
        if (this.field_11863.field_9236) {
            throw new RuntimeException("You should not attempt to make a server-side location on the client!");
        }
        class_2338 pos = this.shadow$method_11016();
        return ServerLocation.of((ServerWorld)((ServerWorld)this.field_11863), (int)pos.method_10263(), (int)pos.method_10264(), (int)pos.method_10260());
    }

    public World<?, ?> world() {
        return (World)this.field_11863;
    }

    public Vector3i blockPosition() {
        return VecHelper.toVector3i(this.shadow$method_11016());
    }

    public int contentVersion() {
        return 1;
    }

    public DataContainer toContainer() {
        ResourceKey key = (ResourceKey)SpongeCommon.vanillaRegistry(class_7924.field_41255).method_10221(this.field_11864);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Queries.WORLD_KEY, (Object)((ServerWorld)this.field_11863).key()).set(Queries.POSITION_X, (Object)this.shadow$method_11016().method_10263()).set(Queries.POSITION_Y, (Object)this.shadow$method_11016().method_10264()).set(Queries.POSITION_Z, (Object)this.shadow$method_11016().method_10260()).set(Constants.TileEntity.TILE_TYPE, (Object)key);
        class_2487 compound = this.shadow$method_38242((class_7225.class_7874)this.field_11863.method_30349());
        Constants.NBT.filterSpongeCustomData(compound);
        container.set(Constants.Sponge.UNSAFE_NBT, (Object)NBTTranslator.INSTANCE.translateFrom(compound));
        return container;
    }

    public boolean validateRawData(DataView container) {
        return container.contains(Queries.WORLD_KEY) && container.contains(Queries.POSITION_X) && container.contains(Queries.POSITION_Y) && container.contains(Queries.POSITION_Z) && container.contains(Constants.TileEntity.TILE_TYPE) && container.contains(Constants.Sponge.UNSAFE_NBT);
    }

    public boolean isRemoved() {
        return this.field_11865;
    }

    public void remove() {
        if (!this.field_11865) {
            this.world().removeBlockEntity(this.blockPosition());
        }
    }

    public boolean canTick() {
        if (!this.api$canTickRequested) {
            this.api$canTick = this.shadow$method_11010().method_31708(this.field_11863, this.field_11864) != null;
            this.api$canTickRequested = true;
        }
        return this.api$canTick;
    }

    public boolean isTicking() {
        return !this.field_11865 && this.canTick() && this.api$isTicking;
    }

    public boolean setTicking(boolean ticking) {
        if (this.isRemoved() || !this.canTick()) {
            return false;
        }
        this.api$isTicking = ticking;
        return true;
    }

    public final BlockEntityType type() {
        return (BlockEntityType)this.field_11864;
    }

    public BlockState block() {
        return (BlockState)this.field_11863.method_8320(this.shadow$method_11016());
    }

    public BlockEntityArchetype createArchetype() {
        return SpongeBlockEntityArchetypeBuilder.pooled().blockEntity(this).build();
    }

    public LocatableBlock locatableBlock() {
        if (this.api$LocatableBlock == null) {
            BlockState blockState = this.block();
            this.api$LocatableBlock = new SpongeLocatableBlockBuilder().world((ServerWorld)this.field_11863).position(this.shadow$method_11016().method_10263(), this.shadow$method_11016().method_10264(), this.shadow$method_11016().method_10260()).state(blockState).build();
        }
        return this.api$LocatableBlock;
    }

    public Set<Value.Immutable<?>> getValues() {
        return this.api$getVanillaValues();
    }

    protected Set<Value.Immutable<?>> api$getVanillaValues() {
        return new HashSet();
    }
}

