/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.state;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataManipulator;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.persistence.Queries;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.block.BlockStateSerializerDeserializer;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.bridge.data.SpongeDataHolderBridge;
import org.spongepowered.common.mixin.api.minecraft.world.level.block.state.BlockBehaviour_BlockStateBaseMixin_API;
import org.spongepowered.common.util.Constants;

@Mixin(value={class_2680.class})
public abstract class BlockStateMixin_API
extends BlockBehaviour_BlockStateBaseMixin_API {
    private String api$serializedState;

    public int contentVersion() {
        return 2;
    }

    public DataContainer toContainer() {
        return DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.contentVersion()).set(Constants.Block.BLOCK_STATE, (Object)this.asString());
    }

    public BlockSnapshot snapshotFor(ServerLocation location) {
        SpongeBlockSnapshot.BuilderImpl builder = SpongeBlockSnapshot.BuilderImpl.pooled().blockState((class_2680)this).position(location.blockPosition()).world((class_3218)location.world());
        if (this.shadow$method_31709() && location.block().type().equals((Object)this.shadow$method_26204())) {
            BlockEntity blockEntity = (BlockEntity)location.blockEntity().orElseThrow(() -> new IllegalStateException("Unable to retrieve a TileEntity for location: " + String.valueOf(location)));
            builder.add((DataManipulator)((SpongeDataHolderBridge)blockEntity).bridge$getManipulator());
            class_2586 mcBlockEntity = (class_2586)blockEntity;
            class_2487 compound = mcBlockEntity.method_38242((class_7225.class_7874)mcBlockEntity.method_10997().method_30349());
            builder.addUnsafeCompound(compound);
        }
        return builder.build();
    }

    public boolean validateRawData(DataView container) {
        return container.contains(Constants.Block.BLOCK_STATE);
    }

    public <E> Optional<E> get(Direction direction, Key<? extends Value<E>> key) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BlockState withRawData(DataView container) throws InvalidDataException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public BlockState copy() {
        return this;
    }

    public String asString() {
        if (this.api$serializedState == null) {
            this.api$serializedState = BlockStateSerializerDeserializer.serialize(this);
        }
        return this.api$serializedState;
    }

    @Override
    public List<DataHolder> impl$delegateDataHolder() {
        return Arrays.asList(this, this.type());
    }
}

