/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.block.state;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2350;
import net.minecraft.class_2688;
import net.minecraft.class_2741;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import org.spongepowered.api.data.Key;
import org.spongepowered.api.data.type.PortionType;
import org.spongepowered.api.data.value.Value;
import org.spongepowered.api.state.State;
import org.spongepowered.api.state.StateProperty;
import org.spongepowered.api.util.Axis;
import org.spongepowered.api.util.Cycleable;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeImmutableDataHolder;
import org.spongepowered.common.util.AxisUtil;
import org.spongepowered.common.util.DirectionUtil;
import org.spongepowered.common.util.PortionTypeUtil;

@Mixin(value={class_2688.class})
public abstract class StateHolderMixin_API<S extends State<S>, C>
implements State<S>,
SpongeImmutableDataHolder<S> {
    @Shadow
    public abstract <V extends Comparable<V>> boolean shadow$method_28498(class_2769<V> var1);

    @Shadow
    public abstract <T extends Comparable<T>> T shadow$method_11654(class_2769<T> var1);

    @Shadow
    public abstract <T extends Comparable<T>, V extends T> C shadow$method_11657(class_2769<T> var1, V var2);

    @Shadow
    public abstract <T extends Comparable<T>> C shadow$method_28493(class_2769<T> var1);

    @Shadow
    public abstract Map<class_2769<?>, Comparable<?>> shadow$method_11656();

    private <ApiT extends Comparable<ApiT>, T extends Comparable<?>> ApiT api$mapToApi(T value) {
        if (value instanceof class_2350.class_2351) {
            class_2350.class_2351 axis = (class_2350.class_2351)value;
            return (ApiT)AxisUtil.getFor(axis);
        }
        if (value instanceof class_2350) {
            class_2350 dir = (class_2350)value;
            return (ApiT)DirectionUtil.getFor(dir);
        }
        if (value instanceof class_2742) {
            class_2742 bedPart = (class_2742)value;
            return (ApiT)PortionTypeUtil.getFor(bedPart);
        }
        if (value instanceof class_2756) {
            class_2756 half = (class_2756)value;
            return (ApiT)PortionTypeUtil.getFor(half);
        }
        return (ApiT)value;
    }

    private <ApiT extends Comparable<ApiT>, T extends Comparable<T>, V extends T> V api$mapFromApi(StateProperty<ApiT> stateProperty, ApiT value) {
        if (value instanceof Axis) {
            Axis axis = (Axis)value;
            return (V)AxisUtil.getFor(axis);
        }
        if (value instanceof Direction) {
            Direction dir = (Direction)value;
            class_2350 mappedValue = DirectionUtil.getFor(dir);
            if (mappedValue == null) {
                throw new UnsupportedOperationException("Unsupported Direction " + String.valueOf(dir));
            }
            return (V)mappedValue;
        }
        if (value instanceof PortionType) {
            PortionType portion = (PortionType)value;
            Object mappedValue = stateProperty.equals((Object)class_2741.field_12483) ? PortionTypeUtil.getBedPartFor(portion) : (stateProperty.equals((Object)class_2741.field_12533) ? PortionTypeUtil.getDoubleBlockHalfFor(portion) : (stateProperty.equals((Object)class_2741.field_12518) ? PortionTypeUtil.getHalfFor(portion) : null));
            if (mappedValue == null) {
                throw new UnsupportedOperationException("Unsupported Portion " + String.valueOf(portion) + " for " + String.valueOf(this));
            }
            return (V)mappedValue;
        }
        return (V)value;
    }

    public <T extends Comparable<T>> Optional<T> stateProperty(StateProperty<T> stateProperty) {
        if (!this.shadow$method_28498((class_2769)stateProperty)) {
            return Optional.empty();
        }
        T value = this.shadow$method_11654((class_2769)stateProperty);
        return Optional.of(this.api$mapToApi(value));
    }

    public Optional<StateProperty<?>> findStateProperty(String name) {
        return this.stateProperties().stream().filter(p -> p.name().equals(name)).findFirst();
    }

    public <T extends Comparable<T>, V extends T> Optional<S> withStateProperty(StateProperty<T> stateProperty, V value) {
        if (!this.shadow$method_28498((class_2769)stateProperty)) {
            return Optional.empty();
        }
        return Optional.of((State)this.shadow$method_11657((class_2769)stateProperty, this.api$mapFromApi((StateProperty)stateProperty, (Comparable)value)));
    }

    public <T extends Comparable<T>> Optional<S> cycleStateProperty(StateProperty<T> stateProperty) {
        if (!this.shadow$method_28498((class_2769)stateProperty)) {
            return Optional.empty();
        }
        return Optional.of((State)this.shadow$method_28493((class_2769)stateProperty));
    }

    public <T extends Cycleable<T>> Optional<S> cycleValue(Key<? extends Value<T>> key) {
        Optional optionalValue = this.get(key);
        if (optionalValue.isPresent() && optionalValue.get() instanceof Cycleable) {
            Cycleable next = ((Cycleable)optionalValue.get()).cycleNext();
            return this.with(key, next);
        }
        return Optional.empty();
    }

    public Collection<StateProperty<?>> stateProperties() {
        return this.shadow$method_11656().keySet();
    }

    public Collection<?> statePropertyValues() {
        return this.shadow$method_11656().values().stream().map(this::api$mapToApi).toList();
    }

    public Map<StateProperty<?>, ?> statePropertyMap() {
        return this.shadow$method_11656().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.api$mapToApi((Comparable)e.getValue())));
    }
}

