/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_5539;
import net.minecraft.class_7924;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.fluid.FluidType;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.scheduler.ScheduledUpdateList;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.HeightType;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.Chunk;
import org.spongepowered.api.world.chunk.ChunkState;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_2791.class})
public abstract class ChunkAccessMixin_API<P extends Chunk<P>>
implements Chunk<P>,
class_5539 {
    @Shadow
    public abstract class_2806 shadow$method_12009();

    @Shadow
    public abstract void shadow$method_12002(class_1297 var1);

    @Shadow
    public abstract void shadow$method_12028(long var1);

    @Shadow
    public abstract long shadow$method_12033();

    @Shadow
    public abstract class_1923 shadow$method_12004();

    @Shadow
    public abstract int shadow$method_12005(class_2902.class_2903 var1, int var2, int var3);

    @Shadow
    public abstract class_2826 shadow$method_38259(int var1);

    @Shadow
    public abstract void shadow$method_65063();

    public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), class_2248.field_10651, (Registry)class_7924.field_41254);
    }

    public void addEntity(Entity entity) {
        this.shadow$method_12002((class_1297)entity);
    }

    public ChunkState state() {
        return (ChunkState)this.shadow$method_12009();
    }

    public boolean isEmpty() {
        return this.shadow$method_12009() == class_2806.field_12798;
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> this.shadow$method_38259(this.method_31602(y)), this::shadow$method_65063);
    }

    public Ticks inhabitedTime() {
        return new SpongeTicks(this.shadow$method_12033());
    }

    public void setInhabitedTime(Ticks newInhabitedTime) {
        Objects.requireNonNull(newInhabitedTime);
        if (newInhabitedTime.isInfinite()) {
            throw new IllegalArgumentException("Inhabited time cannot be infinite!");
        }
        this.shadow$method_12028(newInhabitedTime.ticks());
    }

    public Vector3i chunkPosition() {
        class_1923 chunkPos = this.shadow$method_12004();
        return new Vector3i(chunkPos.field_9181, 0, chunkPos.field_9180);
    }

    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public int highestYAt(int x, int z) {
        return this.shadow$method_12005((class_2902.class_2903)HeightTypes.WORLD_SURFACE.get(), x, z);
    }

    public int height(HeightType type, int x, int z) {
        return this.shadow$method_12005((class_2902.class_2903)Objects.requireNonNull(type, "type"), x, z);
    }

    public ScheduledUpdateList<BlockType> scheduledBlockUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledBlockUpdates");
    }

    public ScheduledUpdateList<FluidType> scheduledFluidUpdates() {
        throw new MissingImplementationException("ChunkAccess", "scheduledFluidUpdates");
    }
}

