/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_2843;
import net.minecraft.class_2902;
import net.minecraft.class_3545;
import net.minecraft.class_4538;
import net.minecraft.class_5539;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5579;
import net.minecraft.class_6749;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.HeightTypes;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.WorldLike;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.chunk.WorldChunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.server.level.ServerLevelAccessor;
import org.spongepowered.common.accessor.world.level.LevelAccessor;
import org.spongepowered.common.accessor.world.level.entity.PersistentEntitySectionManagerAccessor;
import org.spongepowered.common.bridge.world.level.LevelBridge;
import org.spongepowered.common.bridge.world.level.chunk.LevelChunkBridge;
import org.spongepowered.common.data.holder.SpongeServerLocationBaseDataHolder;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.common.world.volume.buffer.biome.ObjectArrayMutableBiomeBuffer;
import org.spongepowered.common.world.volume.buffer.block.ArrayMutableBlockBuffer;
import org.spongepowered.common.world.volume.buffer.blockentity.ObjectArrayMutableBlockEntityBuffer;
import org.spongepowered.common.world.volume.buffer.entity.ObjectArrayMutableEntityBuffer;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={class_2818.class})
@Implements(value={@Interface(iface=WorldChunk.class, prefix="worldChunk$", remap=Interface.Remap.NONE)})
public abstract class LevelChunkMixin_API
extends class_2791
implements WorldChunk,
SpongeServerLocationBaseDataHolder {
    @Shadow
    @Final
    class_1937 field_12858;
    private @Nullable Vector3i api$blockMin;
    private @Nullable Vector3i api$blockMax;
    private @Nullable SpongeChunkLayout api$chunkLayout;

    @Shadow
    public abstract boolean shadow$method_12223();

    @Shadow
    public abstract Map<class_2338, class_2586> shadow$method_12214();

    public LevelChunkMixin_API(class_1923 $$0, class_2843 $$1, class_5539 $$2, class_2378<class_1959> $$3, long $$4, class_2826[] $$5, class_6749 $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), class_2248.field_10651, (Registry)this.field_12858.method_30349().method_30530(class_7924.field_41254));
    }

    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        return (Biome)this.field_12858.method_23753(new class_2338(x, y, z)).comp_349();
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> this.method_38259(this.method_31602(y)), () -> ((LevelChunkMixin_API)this).method_65063());
    }

    @Intrinsic
    public long impl$getInhabitedTime() {
        return this.method_12033();
    }

    public Ticks inhabitedTime() {
        return new SpongeTicks(this.method_12033());
    }

    public void setInhabitedTime(Ticks newInhabitedTime) {
        Objects.requireNonNull(newInhabitedTime);
        if (newInhabitedTime.isInfinite()) {
            throw new IllegalArgumentException("Inhabited time cannot be infinite!");
        }
        this.method_12028(newInhabitedTime.ticks());
    }

    public Vector3i chunkPosition() {
        return new Vector3i(this.field_34538.field_9181, 0, this.field_34538.field_9180);
    }

    public double regionalDifficultyFactor() {
        return new class_1266(this.field_12858.method_8407(), this.field_12858.method_8532(), this.inhabitedTime().ticks(), this.field_12858.method_30272()).method_5457();
    }

    public double regionalDifficultyPercentage() {
        return new class_1266(this.field_12858.method_8407(), this.field_12858.method_8532(), this.inhabitedTime().ticks(), this.field_12858.method_30272()).method_5458();
    }

    public World<@NonNull ?, @NonNull ?> world() {
        return (World)this.field_12858;
    }

    @Intrinsic
    public boolean worldChunk$isEmpty() {
        return this.shadow$method_12223();
    }

    public VolumeStream<WorldChunk, Entity> entityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (class_2818)this, chunk -> VolumeStreamUtils.getEntitiesFromChunk(min, max, chunk), VolumeStreamUtils.getOrCloneEntityWithVolume(shouldCarbonCopy, backingVolume, this.field_12858), (key, entity) -> entity.method_5667(), (entityUuid, chunk) -> {
            class_1297 entity;
            class_1297 class_12972 = entity = shouldCarbonCopy ? (class_1297)backingVolume.entity((UUID)entityUuid).orElse(null) : (class_1297)chunk.world().entity(entityUuid).orElse(null);
            if (entity == null) {
                return null;
            }
            return new class_3545((Object)entity.method_24515(), (Object)entity);
        });
    }

    public VolumeStream<WorldChunk, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ArrayMutableBlockBuffer backingVolume = shouldCarbonCopy ? new ArrayMutableBlockBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (class_2818)this, VolumeStreamUtils.getBlockStatesForSections(min, max), (pos, blockState) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBlock((class_2338)pos, (class_2680)blockState);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            class_2680 tileEntity = shouldCarbonCopy ? backingVolume.getBlock((class_2338)blockPos) : ((class_1922)world).method_8320(blockPos);
            return new class_3545(blockPos, (Object)tileEntity);
        });
    }

    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$method_12214().values());
    }

    public VolumeStream<WorldChunk, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        ObjectArrayMutableBlockEntityBuffer backingVolume = shouldCarbonCopy ? new ObjectArrayMutableBlockEntityBuffer(min, size) : null;
        return VolumeStreamUtils.generateStream(options, this, (class_2818)this, this::impl$getBlockEntitiesStream, VolumeStreamUtils.getBlockEntityOrCloneToBackingVolume(shouldCarbonCopy, backingVolume, this.field_12858), (key, biome) -> key, (blockPos, world) -> {
            @Nullable class_2586 tileEntity = shouldCarbonCopy ? (class_2586)backingVolume.blockEntity(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()).orElse(null) : ((class_4538)world).method_8321(blockPos);
            return new class_3545(blockPos, (Object)tileEntity);
        });
    }

    private Stream<Map.Entry<class_2338, class_2586>> impl$getBlockEntitiesStream(class_2791 chunk) {
        return chunk instanceof class_2818 ? ((class_2818)chunk).method_12214().entrySet().stream() : Stream.empty();
    }

    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.world().addBlockEntity(x, y, z, blockEntity);
    }

    public void removeBlockEntity(int x, int y, int z) {
        this.world().removeBlockEntity(x, y, z);
    }

    public VolumeStream<WorldChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        ObjectArrayMutableBiomeBuffer backingVolume;
        VolumeStreamUtils.validateStreamArgs(Objects.requireNonNull(min, "min"), Objects.requireNonNull(max, "max"), Objects.requireNonNull(options, "options"));
        boolean shouldCarbonCopy = options.carbonCopy();
        Vector3i size = max.sub(min).add(1, 1, 1);
        if (shouldCarbonCopy) {
            class_2378 biomeRegistry = this.field_12858.method_30349().method_30530(class_7924.field_41236);
            backingVolume = new ObjectArrayMutableBiomeBuffer(min, size, VolumeStreamUtils.nativeToSpongeRegistry(biomeRegistry));
        } else {
            backingVolume = null;
        }
        return VolumeStreamUtils.generateStream(options, this, (class_2818)this, VolumeStreamUtils.getBiomesForChunkByPos((class_4538)this, min, max), (pos, biome) -> {
            if (shouldCarbonCopy) {
                backingVolume.setBiome((class_2338)pos, (class_1959)biome);
            }
        }, (key, biome) -> key, (blockPos, world) -> {
            class_1959 biome = shouldCarbonCopy ? backingVolume.getNativeBiome(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()) : (class_1959)((class_4538)world.world()).method_23753(blockPos).comp_349();
            return new class_3545(blockPos, (Object)biome);
        });
    }

    public int highestYAt(int x, int z) {
        return this.method_12032((class_2902.class_2903)HeightTypes.WORLD_SURFACE.get()).method_35334(x, z);
    }

    public Vector3i min() {
        if (this.api$blockMin == null) {
            if (this.api$chunkLayout == null) {
                this.api$chunkLayout = new SpongeChunkLayout(this.field_12858.method_31607(), this.field_12858.method_31605());
            }
            this.api$blockMin = this.api$chunkLayout.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    public Vector3i max() {
        if (this.api$blockMax == null) {
            if (this.api$chunkLayout == null) {
                this.api$chunkLayout = new SpongeChunkLayout(this.field_12858.method_31607(), this.field_12858.method_31605());
            }
            this.api$blockMax = this.min().add(this.api$chunkLayout.chunkSize()).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    public Vector3i size() {
        if (this.api$chunkLayout == null) {
            this.api$chunkLayout = new SpongeChunkLayout(this.field_12858.method_31607(), this.field_12858.method_31605());
        }
        return this.api$chunkLayout.chunkSize();
    }

    public Collection<? extends Player> players() {
        return this.field_12858.method_18456().stream().filter(x -> this.field_34538.equals((Object)x.method_31476())).collect(Collectors.toList());
    }

    public Optional<Entity> entity(UUID uuid) {
        return Optional.ofNullable((class_1297)((LevelAccessor)this.field_12858).invoker$getEntities().method_31808(uuid)).filter(x -> x.method_31476().equals((Object)this.field_34538));
    }

    public Collection<? extends Entity> entities() {
        class_5579<class_1297> entityManager = ((ServerLevelAccessor)this.field_12858).accessor$getEntityManager();
        class_5573 entitySectionStorage = ((PersistentEntitySectionManagerAccessor)entityManager).accessor$sectionStorage();
        return entitySectionStorage.method_31782(this.field_34538.method_8324()).flatMap(class_5572::method_31766).toList();
    }

    public <T extends Entity> Collection<? extends T> entities(Class<? extends T> entityClass, AABB box, @Nullable Predicate<? super T> predicate) {
        return this.field_12858.method_8390(entityClass, VecHelper.toMinecraftAABB(box), predicate).stream().filter(x -> this.field_34538.equals((Object)x.method_31476())).collect(Collectors.toList());
    }

    public Collection<? extends Entity> entities(AABB box, Predicate<? super Entity> filter) {
        return this.field_12858.method_8333((class_1297)null, VecHelper.toMinecraftAABB(box), filter).stream().filter(x -> this.field_34538.equals((Object)x.method_31476())).collect(Collectors.toList());
    }

    public <E extends Entity> E createEntity(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.field_12858).bridge$createEntity(type, position, false);
    }

    public <E extends Entity> E createEntityNaturally(EntityType<E> type, Vector3d position) throws IllegalArgumentException, IllegalStateException {
        this.api$checkPositionInChunk(position);
        return ((LevelBridge)this.field_12858).bridge$createEntity(type, position, true);
    }

    public Optional<Entity> createEntity(DataContainer container) {
        return Optional.ofNullable(((LevelBridge)this.field_12858).bridge$createEntity(container, null, position -> VecHelper.inBounds(position, this.min(), this.max())));
    }

    public Optional<Entity> createEntity(DataContainer container, Vector3d position) {
        this.api$checkPositionInChunk(position);
        return Optional.ofNullable(((LevelBridge)this.field_12858).bridge$createEntity(container, position, null));
    }

    public boolean spawnEntity(Entity entity) {
        return ((LevelChunkBridge)((Object)this)).bridge$spawnEntity(entity);
    }

    public Collection<Entity> spawnEntities(Iterable<? extends Entity> entities) {
        return EntityUtil.spawnEntities(entities, x -> this.api$isInBounds(x.position()), entity -> ((LevelChunkBridge)((Object)this)).bridge$spawnEntity((Entity)entity));
    }

    public boolean setBlock(int x, int y, int z, BlockState blockState, BlockChangeFlag flag) {
        this.api$checkPositionInChunk(x, y, z);
        return ((WorldLike)this.field_12858).setBlock(x, y, z, blockState, flag);
    }

    private void api$checkPositionInChunk(int x, int y, int z) {
        if (!VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max())) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private void api$checkPositionInChunk(Vector3d position) {
        if (!this.api$isInBounds(position)) {
            throw new IllegalArgumentException("Supplied bounds are not within this chunk.");
        }
    }

    private boolean api$isInBounds(Vector3d position) {
        return VecHelper.inBounds(position, this.min(), this.max());
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        this.api$checkPositionInChunk(x, y, z);
        if (this.field_12858 instanceof ServerWorld) {
            return (ServerLocation)((ServerWorld)this.field_12858).location(x, y, z);
        }
        throw new MissingImplementationException("LevelChunk", "impl$dataholder");
    }
}

