/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.chunk;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2843;
import net.minecraft.class_5539;
import net.minecraft.class_6746;
import net.minecraft.class_6749;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntity;
import org.spongepowered.api.registry.Registry;
import org.spongepowered.api.util.PositionOutOfBoundsException;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.generation.GenerationChunk;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.data.holder.SpongeServerLocationBaseDataHolder;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.MissingImplementationException;
import org.spongepowered.common.util.SpongeTicks;
import org.spongepowered.common.world.schematic.PaletteWrapper;
import org.spongepowered.common.world.storage.SpongeChunkLayout;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3i;
import org.spongepowered.math.vector.Vectori;

@Mixin(value={class_2839.class})
public abstract class ProtoChunkMixin_API
extends class_2791
implements GenerationChunk,
SpongeServerLocationBaseDataHolder {
    @Shadow
    private @Nullable class_6746 field_35473;
    private @Nullable Vector3i api$blockMin;
    private @Nullable Vector3i api$blockMax;

    @Shadow
    public abstract Map<class_2338, class_2586> shadow$method_12309();

    @Shadow
    public abstract void shadow$method_12007(class_2586 var1);

    @Shadow
    public abstract void shadow$method_12041(class_2338 var1);

    @Shadow
    public abstract class_6880<class_1959> shadow$method_16359(int var1, int var2, int var3);

    @Shadow
    public abstract class_2806 shadow$method_12009();

    public ProtoChunkMixin_API(class_1923 $$0, class_2843 $$1, class_5539 $$2, class_2378<class_1959> $$3, long $$4, class_2826[] $$5, class_6749 $$6) {
        super($$0, $$1, $$2, $$3, $$4, $$5, $$6);
    }

    public Palette<BlockState, BlockType> blockPalette() {
        return PaletteWrapper.of((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get(), class_2248.field_10651, (Registry)SpongeCommon.vanillaRegistry(class_7924.field_41254));
    }

    public VolumeStream<GenerationChunk, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream biomes on ProtoChunk");
    }

    public VolumeStream<GenerationChunk, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block states on ProtoChunk");
    }

    public VolumeStream<GenerationChunk, BlockEntity> blockEntityStream(Vector3i min, Vector3i max, StreamOptions options) {
        throw new UnsupportedOperationException("Cannot stream block entities on ProtoChunk");
    }

    public Vector3i min() {
        if (this.api$blockMin == null) {
            this.api$blockMin = SpongeChunkLayout.INSTANCE.forceToWorld(this.chunkPosition());
        }
        return this.api$blockMin;
    }

    public Vector3i max() {
        if (this.api$blockMax == null) {
            this.api$blockMax = this.min().add(SpongeChunkLayout.INSTANCE.chunkSize()).sub(1, 1, 1);
        }
        return this.api$blockMax;
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        return false;
    }

    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        if (!(this.shadow$method_12009().method_12165(class_2806.field_12794) || this.field_35473 != null && this.field_35473.method_39319().method_12165(class_2806.field_12794))) {
            throw new IllegalStateException("Asking for biomes before we have biomes");
        }
        return VolumeStreamUtils.setBiomeOnNativeChunk(x, y, z, biome, () -> this.method_38259(this.method_31602(y)), () -> {});
    }

    public Collection<? extends BlockEntity> blockEntities() {
        return Collections.unmodifiableCollection(this.shadow$method_12309().values());
    }

    public Ticks inhabitedTime() {
        return new SpongeTicks(this.method_12033());
    }

    public void addBlockEntity(int x, int y, int z, BlockEntity blockEntity) {
        this.shadow$method_12007((class_2586)blockEntity);
    }

    public void setInhabitedTime(Ticks newInhabitedTime) {
        Objects.requireNonNull(newInhabitedTime);
        if (newInhabitedTime.isInfinite()) {
            throw new IllegalArgumentException("Inhabited time cannot be infinite!");
        }
        this.method_12028(newInhabitedTime.ticks());
    }

    public void removeBlockEntity(int x, int y, int z) {
        this.shadow$method_12041(new class_2338(x, y, z));
    }

    public Biome biome(int x, int y, int z) {
        if (!this.contains(x, y, z)) {
            throw new PositionOutOfBoundsException((Vectori)new Vector3i(x, y, z), (Vectori)Constants.World.BLOCK_MIN, (Vectori)Constants.World.BLOCK_MAX);
        }
        return (Biome)this.shadow$method_16359(x, y, z).comp_349();
    }

    @Override
    public ServerLocation impl$dataholder(int x, int y, int z) {
        throw new MissingImplementationException("ProtoChunk", "impl$dataholder");
    }
}

