/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.levelgen.structure.templatesystem;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3499;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockType;
import org.spongepowered.api.block.entity.BlockEntityArchetype;
import org.spongepowered.api.block.entity.BlockEntityType;
import org.spongepowered.api.data.persistence.DataContainer;
import org.spongepowered.api.data.persistence.DataView;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.fluid.FluidState;
import org.spongepowered.api.registry.RegistryTypes;
import org.spongepowered.api.util.transformation.Transformation;
import org.spongepowered.api.world.biome.Biome;
import org.spongepowered.api.world.schematic.Palette;
import org.spongepowered.api.world.schematic.PaletteType;
import org.spongepowered.api.world.schematic.PaletteTypes;
import org.spongepowered.api.world.schematic.Schematic;
import org.spongepowered.api.world.volume.Volume;
import org.spongepowered.api.world.volume.archetype.ArchetypeVolume;
import org.spongepowered.api.world.volume.archetype.entity.EntityArchetypeEntry;
import org.spongepowered.api.world.volume.stream.StreamOptions;
import org.spongepowered.api.world.volume.stream.VolumeElement;
import org.spongepowered.api.world.volume.stream.VolumeStream;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.data.holder.SpongeArchetypeVolumeDataHolder;
import org.spongepowered.common.data.persistence.NBTTranslator;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.schematic.ReferentSchematicVolume;
import org.spongepowered.common.world.volume.SpongeVolumeStream;
import org.spongepowered.common.world.volume.VolumeStreamUtils;
import org.spongepowered.math.vector.Vector3d;
import org.spongepowered.math.vector.Vector3i;

@Mixin(value={class_3499.class})
public abstract class StructureTemplateMixin_API
implements Schematic,
SpongeArchetypeVolumeDataHolder {
    @Shadow
    @Final
    private List<class_3499.class_5162> field_15586;
    @Shadow
    @Final
    private List<class_3499.class_3502> field_15589;

    @Shadow
    public abstract class_2382 shadow$method_15160();

    public Palette<BlockState, BlockType> blockPalette() {
        Palette blockPallete = ((PaletteType)PaletteTypes.BLOCK_STATE_PALETTE.get()).create(RegistryTypes.BLOCK_TYPE.get());
        return blockPallete;
    }

    public Palette<Biome, Biome> biomePalette() {
        Palette biomePalette = ((PaletteType)PaletteTypes.BIOME_PALETTE.get()).create(RegistryTypes.BIOME.get());
        return biomePalette;
    }

    public DataView metadata() {
        return DataContainer.createNew();
    }

    public Vector3i min() {
        return Vector3i.ZERO;
    }

    public Vector3i max() {
        return VecHelper.toVector3i(this.shadow$method_15160()).sub(Vector3i.ONE);
    }

    public boolean contains(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public boolean isAreaAvailable(int x, int y, int z) {
        return VecHelper.inBounds((double)x, (double)y, (double)z, this.min(), this.max());
    }

    public ArchetypeVolume transform(Transformation transformation) {
        return new ReferentSchematicVolume(this, Objects.requireNonNull(transformation, "Transformation cannot be null"));
    }

    private Map<class_2338, class_2487> api$buildBlockNbtMap() {
        List blockInfos = this.field_15586.iterator().next().method_27125();
        return blockInfos.stream().filter(info -> info.comp_1343() != null).collect(Collectors.toMap(class_3499.class_3501::comp_1341, class_3499.class_3501::comp_1343));
    }

    public Optional<BlockEntityArchetype> blockEntityArchetype(int x, int y, int z) {
        class_2338 pos = new class_2338(x, y, z);
        class_2680 state = this.api$buildBlockStateMap().get(pos);
        if (state.method_31709()) {
            class_2591 type = ((class_2343)state.method_26204()).method_10123(pos, state).method_11017();
            class_2487 nbt = this.api$buildBlockNbtMap().getOrDefault(pos, new class_2487());
            return Optional.of(BlockEntityArchetype.builder().state((BlockState)state).blockEntity((BlockEntityType)type).blockEntityData((DataView)NBTTranslator.INSTANCE.translate(nbt)).build());
        }
        return Optional.empty();
    }

    public Map<Vector3i, BlockEntityArchetype> blockEntityArchetypes() {
        Map<class_2338, class_2487> nbtMap = this.api$buildBlockNbtMap();
        return this.api$buildBlockStateMap().entrySet().stream().filter(e -> ((class_2680)e.getValue()).method_31709()).collect(Collectors.toMap(e -> VecHelper.toVector3i((class_2338)e.getKey()), e -> {
            class_2680 state = (class_2680)e.getValue();
            class_2591 type = ((class_2343)state.method_26204()).method_10123((class_2338)e.getKey(), state).method_11017();
            class_2487 nbt = nbtMap.getOrDefault(e.getKey(), new class_2487());
            return BlockEntityArchetype.builder().state((BlockState)state).blockEntity((BlockEntityType)type).blockEntityData((DataView)NBTTranslator.INSTANCE.translate(nbt)).build();
        }));
    }

    public VolumeStream<ArchetypeVolume, BlockEntityArchetype> blockEntityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Map<class_2338, class_2487> nbtMap = this.api$buildBlockNbtMap();
        Stream stateStream = this.api$buildBlockStateMap().entrySet().stream().filter(e -> ((class_2680)e.getValue()).method_31709()).filter(VolumeStreamUtils.filterPositions(t -> VecHelper.toVector3i((class_2338)t.getKey()), min, max)).map(e -> {
            class_2680 state = (class_2680)e.getValue();
            class_2591 type = ((class_2343)state.method_26204()).method_10123((class_2338)e.getKey(), state).method_11017();
            class_2487 nbt = nbtMap.getOrDefault(e.getKey(), new class_2487());
            BlockEntityArchetype value = BlockEntityArchetype.builder().state((BlockState)e.getValue()).blockEntity((BlockEntityType)type).blockEntityData((DataView)NBTTranslator.INSTANCE.translate(nbt)).build();
            return VolumeElement.of((Volume)this, (Object)value, (Vector3d)VecHelper.toVector3d((class_2338)e.getKey()));
        });
        return new SpongeVolumeStream<ArchetypeVolume, BlockEntityArchetype>(stateStream, () -> this);
    }

    private Stream<EntityArchetypeEntry> api$buildEntityArchetypeList() {
        return this.field_15589.stream().map(info -> {
            Optional by = class_1299.method_17684((class_2487)info.field_15598);
            if (by.isPresent()) {
                DataContainer data = NBTTranslator.INSTANCE.translateFrom(info.field_15598);
                EntityArchetype archetype = EntityArchetype.builder().type((EntityType)by.get()).entityData((DataView)data).build();
                return EntityArchetypeEntry.of((EntityArchetype)archetype, (Vector3d)VecHelper.toVector3d(info.field_15599));
            }
            return null;
        }).filter(Objects::nonNull);
    }

    public Collection<EntityArchetype> entityArchetypes() {
        return this.api$buildEntityArchetypeList().map(EntityArchetypeEntry::archetype).toList();
    }

    public Collection<EntityArchetypeEntry> entityArchetypesByPosition() {
        return this.api$buildEntityArchetypeList().toList();
    }

    public Collection<EntityArchetype> entityArchetypes(Predicate<EntityArchetype> filter) {
        return this.api$buildEntityArchetypeList().map(EntityArchetypeEntry::archetype).filter(filter).toList();
    }

    public VolumeStream<ArchetypeVolume, EntityArchetype> entityArchetypeStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.api$buildEntityArchetypeList().filter(VolumeStreamUtils.filterPositions(t -> t.position().toInt(), min, max)).map(e -> VolumeElement.of((Volume)this, (Object)e.archetype(), (Vector3d)e.position()));
        return new SpongeVolumeStream<ArchetypeVolume, EntityArchetype>(stateStream, () -> this);
    }

    public Stream<EntityArchetypeEntry> entitiesByPosition() {
        return this.api$buildEntityArchetypeList();
    }

    public Biome biome(int x, int y, int z) {
        return null;
    }

    public VolumeStream<ArchetypeVolume, Biome> biomeStream(Vector3i min, Vector3i max, StreamOptions options) {
        return new SpongeVolumeStream<ArchetypeVolume, Biome>(Stream.empty(), () -> this);
    }

    private Map<class_2338, class_2680> api$buildBlockStateMap() {
        List blockInfos = this.field_15586.iterator().next().method_27125();
        return blockInfos.stream().collect(Collectors.toMap(class_3499.class_3501::comp_1341, class_3499.class_3501::comp_1342));
    }

    public BlockState block(int x, int y, int z) {
        return (BlockState)this.api$buildBlockStateMap().get(new class_2338(x, y, z));
    }

    public FluidState fluid(int x, int y, int z) {
        class_2680 blockState = this.api$buildBlockStateMap().get(new class_2338(x, y, z));
        if (blockState == null) {
            return null;
        }
        return (FluidState)blockState.method_26227();
    }

    public VolumeStream<ArchetypeVolume, BlockState> blockStateStream(Vector3i min, Vector3i max, StreamOptions options) {
        Vector3i blockMin = this.min();
        Vector3i blockMax = this.max();
        VolumeStreamUtils.validateStreamArgs(min, max, blockMin, blockMax, options);
        Stream stateStream = this.api$buildBlockStateMap().entrySet().stream().filter(VolumeStreamUtils.filterPositions(t -> VecHelper.toVector3i((class_2338)t.getKey()), min, max)).map(e -> VolumeElement.of((Volume)this, (Object)((BlockState)e.getValue()), (Vector3d)VecHelper.toVector3d((class_2338)e.getKey())));
        return new SpongeVolumeStream<ArchetypeVolume, BlockState>(stateStream, () -> this);
    }

    public int highestYAt(int x, int z) {
        return 0;
    }

    public boolean setBlock(int x, int y, int z, BlockState block) {
        return false;
    }

    public boolean removeBlock(int x, int y, int z) {
        return false;
    }

    public boolean setBiome(int x, int y, int z, Biome biome) {
        return false;
    }

    public void addBlockEntity(int x, int y, int z, BlockEntityArchetype archetype) {
    }

    public void removeBlockEntity(int x, int y, int z) {
    }

    public void addEntity(EntityArchetypeEntry entry) {
        class_243 pos = VecHelper.toVanillaVector3d(entry.position());
        class_2338 blockPos = VecHelper.toBlockPos(entry.position());
        class_2487 data = NBTTranslator.INSTANCE.translate((DataView)entry.archetype().entityData());
        class_3499.class_3502 info = new class_3499.class_3502(pos, blockPos, data);
        this.field_15589.add(info);
    }
}

