/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.api.minecraft.world.level.storage;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1928;
import net.minecraft.class_5268;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.entity.living.trader.WanderingTrader;
import org.spongepowered.api.util.MinecraftDayTime;
import org.spongepowered.api.util.Ticks;
import org.spongepowered.api.world.gamerule.GameRule;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.api.world.server.storage.ServerWorldProperties;
import org.spongepowered.api.world.weather.Weather;
import org.spongepowered.api.world.weather.WeatherType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.common.accessor.world.level.GameRulesAccessor;
import org.spongepowered.common.accessor.world.level.GameRules_ValueAccessor;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.util.SpongeTicks;

@Mixin(value={class_5268.class})
public interface ServerLevelDataMixin_API
extends ServerWorldProperties {
    @Shadow
    public int shadow$method_18038();

    @Shadow
    public void shadow$method_18041(int var1);

    @Shadow
    public int shadow$method_18039();

    @Shadow
    public void shadow$method_18042(int var1);

    @Shadow
    public void shadow$method_18040(UUID var1);

    @Shadow
    public @Nullable UUID shadow$method_35506();

    @Shadow
    public void shadow$method_29035(long var1);

    @Shadow
    public class_1928 shadow$method_146();

    default public ResourceKey key() {
        return Objects.requireNonNull(((ServerLevelDataBridge)((Object)this)).bridge$spongeData().key());
    }

    default public Optional<ServerWorld> world() {
        return Optional.ofNullable((ServerWorld)((ServerLevelDataBridge)((Object)this)).bridge$level());
    }

    default public String name() {
        return this.key().asString();
    }

    default public UUID uniqueId() {
        return ((ServerLevelDataBridge)((Object)this)).bridge$spongeData().uniqueId();
    }

    default public <V> V gameRule(GameRule<V> gameRule) {
        class_1928.class_4315 value = this.shadow$method_146().method_20746((class_1928.class_4313)Objects.requireNonNull(gameRule, "gameRule"));
        if (value instanceof class_1928.class_4310) {
            return (V)Boolean.valueOf(((class_1928.class_4310)value).method_20753());
        }
        if (value instanceof class_1928.class_4312) {
            return (V)Integer.valueOf(((class_1928.class_4312)value).method_20763());
        }
        return null;
    }

    default public <V> void setGameRule(GameRule<V> gameRule, V value) {
        Objects.requireNonNull(gameRule, "gameRule");
        Objects.requireNonNull(value, "value");
        class_1928.class_4315 mValue = this.shadow$method_146().method_20746((class_1928.class_4313)gameRule);
        ((GameRules_ValueAccessor)mValue).invoker$deserialize(value.toString());
    }

    default public Map<GameRule<?>, ?> gameRules() {
        Map<class_1928.class_4313<?>, class_1928.class_4315<?>> rules = ((GameRulesAccessor)this.shadow$method_146()).accessor$rules();
        HashMap<GameRule, Boolean> apiRules = new HashMap<GameRule, Boolean>();
        for (Map.Entry<class_1928.class_4313<?>, class_1928.class_4315<?>> rule : rules.entrySet()) {
            GameRule key = (GameRule)rule.getKey();
            class_1928.class_4315<?> mValue = rule.getValue();
            Comparable<Boolean> value = null;
            if (mValue instanceof class_1928.class_4310) {
                value = ((class_1928.class_4310)mValue).method_20753();
            } else if (mValue instanceof class_1928.class_4312) {
                value = ((class_1928.class_4312)mValue).method_20763();
            }
            if (value == null) continue;
            apiRules.put(key, (Boolean)value);
        }
        return apiRules;
    }

    default public void setDayTime(MinecraftDayTime dayTime) {
        this.shadow$method_29035(dayTime.asTicks().ticks());
    }

    default public Ticks wanderingTraderSpawnDelay() {
        return SpongeTicks.ticksOrInfinite(this.shadow$method_18038());
    }

    default public void setWanderingTraderSpawnDelay(Ticks delay) {
        this.shadow$method_18041(SpongeTicks.toSaturatedIntOrInfinite(delay));
    }

    default public int wanderingTraderSpawnChance() {
        return this.shadow$method_18039();
    }

    default public void setWanderingTraderSpawnChance(int chance) {
        this.shadow$method_18042(chance);
    }

    default public void setWanderingTrader(@Nullable WanderingTrader trader) {
        this.shadow$method_18040(trader == null ? null : trader.uniqueId());
    }

    default public Optional<UUID> wanderTraderUniqueId() {
        return Optional.ofNullable(this.shadow$method_35506());
    }

    default public void setWeather(WeatherType type) {
        this.offer(Keys.WEATHER, Weather.of((WeatherType)Objects.requireNonNull(type, "type"), (long)120L));
    }

    default public void setWeather(WeatherType type, Ticks ticks) {
        this.offer(Keys.WEATHER, Weather.of((WeatherType)Objects.requireNonNull(type, "type"), (Ticks)Objects.requireNonNull(ticks, "ticks")));
    }
}

