/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.advancements;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_167;
import net.minecraft.class_178;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_8779;
import net.minecraft.class_8782;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.api.advancement.Advancement;
import org.spongepowered.api.advancement.AdvancementProgress;
import org.spongepowered.api.advancement.criteria.AdvancementCriterion;
import org.spongepowered.api.advancement.criteria.AndCriterion;
import org.spongepowered.api.advancement.criteria.CriterionProgress;
import org.spongepowered.api.advancement.criteria.OperatorCriterion;
import org.spongepowered.api.advancement.criteria.OrCriterion;
import org.spongepowered.api.advancement.criteria.ScoreAdvancementCriterion;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.advancement.criterion.ImplementationBackedCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterion;
import org.spongepowered.common.advancement.criterion.SpongeAndCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeEmptyCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterion;
import org.spongepowered.common.advancement.criterion.SpongeOrCriterionProgress;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterion;
import org.spongepowered.common.advancement.criterion.SpongeScoreCriterionProgress;
import org.spongepowered.common.bridge.advancements.AdvancementProgressBridge;
import org.spongepowered.common.bridge.advancements.CriterionBridge;
import org.spongepowered.common.bridge.advancements.CriterionProgressBridge;
import org.spongepowered.common.bridge.server.PlayerAdvancementsBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.hooks.PlatformHooks;
import org.spongepowered.common.util.Preconditions;

@Mixin(value={class_167.class})
public abstract class AdvancementProgressMixin
implements AdvancementProgressBridge {
    @Shadow
    @Final
    private Map<String, class_178> field_1160;
    private @Nullable Map<String, ImplementationBackedCriterionProgress> impl$progressMap;
    private @Nullable class_2960 impl$advancementKey;
    private @Nullable class_2985 impl$playerAdvancements;

    @Override
    public Advancement bridge$getAdvancement() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        class_8779 advancement = SpongeCommon.server().method_3851().method_12896(this.impl$advancementKey);
        if (advancement == null) {
            throw new IllegalStateException("The advancement of this advancement progress is unloaded: " + String.valueOf(this.impl$advancementKey));
        }
        return (Advancement)advancement.comp_1920();
    }

    @Override
    public class_2960 bridge$getAdvancementKey() {
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        return this.impl$advancementKey;
    }

    @Override
    public class_2985 bridge$getPlayerAdvancements() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$playerAdvancements != null, "The playerAdvancements is not yet initialized");
        return this.impl$playerAdvancements;
    }

    @Override
    public void bridge$setPlayerAdvancements(class_2985 playerAdvancements) {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$playerAdvancements = playerAdvancements;
    }

    @Override
    public void bridge$setAdvancementId(class_2960 key) {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        this.impl$advancementKey = key;
    }

    @Override
    public void bridge$invalidateAchievedState() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        for (ImplementationBackedCriterionProgress progress : this.impl$getProgressMap().values()) {
            progress.invalidateAchievedState();
        }
    }

    @Override
    public void bridge$updateProgressMap() {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Optional<Advancement> advancement = this.impl$getOptionalAdvancement();
        if (advancement.isPresent()) {
            this.impl$progressMap = new LinkedHashMap<String, ImplementationBackedCriterionProgress>();
            if (advancement.get().criterion() != null) {
                this.impl$processProgressMap(advancement.get().criterion(), this.impl$progressMap);
            } else {
                SpongeCommon.logger().warn("advancement has null criterion");
            }
        } else {
            this.impl$progressMap = null;
        }
    }

    @Override
    public Map<String, ImplementationBackedCriterionProgress> bridge$getProgressMap() {
        return this.impl$progressMap;
    }

    @Inject(method={"method_727(Lnet/minecraft/class_8782;)V"}, at={@At(value="RETURN")})
    private void impl$updateCriterionsAndMap(class_8782 requirements, CallbackInfo ci) {
        for (List reqs : requirements.comp_1922()) {
            for (String req : reqs) {
                if (this.field_1160.containsKey(req)) continue;
                String advName = this.impl$getOptionalAdvancement().map(Objects::toString).orElse("unknown");
                throw new IllegalStateException("Found a requirement which does not exist in the criteria, " + req + " could not be found for the advancement: " + advName);
            }
        }
        this.bridge$updateProgressMap();
    }

    private Map<String, ImplementationBackedCriterionProgress> impl$getProgressMap() {
        Preconditions.checkState(this.impl$progressMap != null, "progressMap isn't initialized");
        return this.impl$progressMap;
    }

    private void impl$processProgressMap(AdvancementCriterion criterion, Map<String, ImplementationBackedCriterionProgress> progressMap) {
        if (criterion instanceof OperatorCriterion) {
            ((OperatorCriterion)criterion).criteria().forEach(child -> this.impl$processProgressMap((AdvancementCriterion)child, progressMap));
            if (criterion instanceof AndCriterion) {
                progressMap.put(criterion.name(), new SpongeAndCriterionProgress((AdvancementProgress)this, (SpongeAndCriterion)criterion));
            } else if (criterion instanceof OrCriterion) {
                progressMap.put(criterion.name(), new SpongeOrCriterionProgress((AdvancementProgress)this, (SpongeOrCriterion)criterion));
            }
        } else if (criterion instanceof SpongeScoreCriterion) {
            SpongeScoreCriterion scoreCriterion = (SpongeScoreCriterion)criterion;
            for (AdvancementCriterion advancementCriterion : scoreCriterion.internalCriteria) {
                CriterionProgressBridge progress = (CriterionProgressBridge)this.field_1160.get(advancementCriterion.name());
                progress.bridge$setCriterion(advancementCriterion);
                progress.bridge$setAdvancementProgress((AdvancementProgress)this);
                progressMap.put(advancementCriterion.name(), (ImplementationBackedCriterionProgress)((Object)progress));
            }
            progressMap.put(scoreCriterion.name(), new SpongeScoreCriterionProgress((AdvancementProgress)this, scoreCriterion));
        } else if (!(criterion instanceof SpongeEmptyCriterion)) {
            CriterionProgressBridge progress = (CriterionProgressBridge)this.field_1160.get(criterion.name());
            progress.bridge$setCriterion(criterion);
            progress.bridge$setAdvancementProgress((AdvancementProgress)this);
            progressMap.put(criterion.name(), (ImplementationBackedCriterionProgress)((Object)progress));
        }
    }

    @Inject(method={"method_740()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$supportComplexCriteria(CallbackInfoReturnable<Boolean> ci) {
        if (this.impl$advancementKey == null || !PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        Advancement advancement = this.impl$getOptionalAdvancement().orElse(null);
        if (advancement != null) {
            if (advancement.criterion() != null) {
                ImplementationBackedCriterionProgress bridge = this.impl$progressMap.get(advancement.criterion().name());
                ci.setReturnValue((Object)(bridge != null && ((CriterionProgress)bridge).achieved() ? 1 : 0));
            } else {
                SpongeCommon.logger().warn("advancement has null criterion");
            }
        }
    }

    @Inject(method={"method_743(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$grantScoreCriteriaAndCallEvents(String criterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$grantCriterion(criterion));
    }

    private boolean impl$grantCriterion(String rawCriterion) {
        Object event;
        class_178 criterionProgress = this.field_1160.get(rawCriterion);
        if (criterionProgress == null || criterionProgress.method_784()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.method_789();
            return true;
        }
        Cause cause = PhaseTracker.getInstance().currentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.criterion();
        CriterionBridge criterionBridge = (CriterionBridge)criterion;
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.name());
            int lastScore = scoreProgress.score();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreRevoke((Cause)cause, (Advancement)this.bridge$getAdvancement(), (ResourceKey)((ResourceKey)this.impl$advancementKey), (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (int)lastScore, (int)score) : (score == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreGrant((Cause)cause, (Advancement)this.bridge$getAdvancement(), (ResourceKey)((ResourceKey)this.impl$advancementKey), (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (Instant)Instant.now(), (int)lastScore, (int)score) : SpongeEventFactory.createCriterionEventScoreChange((Cause)cause, (Advancement)this.bridge$getAdvancement(), (ResourceKey)((ResourceKey)this.impl$advancementKey), (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (int)lastScore, (int)score));
        } else {
            event = SpongeEventFactory.createCriterionEventGrant((Cause)cause, (Advancement)this.bridge$getAdvancement(), (ResourceKey)((ResourceKey)this.impl$advancementKey), (AdvancementCriterion)criterion, (ServerPlayer)player, (Instant)Instant.now());
        }
        if (SpongeCommon.post((Event)event)) {
            return false;
        }
        criterionProgress.method_789();
        return true;
    }

    @Inject(method={"method_729(Ljava/lang/String;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$removeScoreCriteriaAndCallEvents(String rawCriterion, CallbackInfoReturnable<Boolean> ci) {
        if (!PlatformHooks.INSTANCE.getGeneralHooks().onServerThread()) {
            return;
        }
        ci.setReturnValue((Object)this.impl$revokeCriterion(rawCriterion));
    }

    private boolean impl$revokeCriterion(String rawCriterion) {
        Object event;
        class_178 criterionProgress = this.field_1160.get(rawCriterion);
        if (criterionProgress == null || !criterionProgress.method_784()) {
            return false;
        }
        if (SpongeScoreCriterion.BYPASS_EVENT) {
            criterionProgress.method_790();
            return true;
        }
        Cause cause = PhaseTracker.getInstance().currentCause();
        ServerPlayer player = ((PlayerAdvancementsBridge)this.impl$playerAdvancements).bridge$getPlayer();
        CriterionProgress progress = (CriterionProgress)criterionProgress;
        AdvancementCriterion criterion = progress.criterion();
        CriterionBridge criterionBridge = (CriterionBridge)criterion;
        SpongeScoreCriterion scoreCriterion = criterionBridge.bridge$getScoreCriterion();
        Advancement advancement = ((AdvancementProgress)this).advancement();
        ResourceKey key = (ResourceKey)this.impl$advancementKey;
        if (scoreCriterion != null) {
            SpongeScoreCriterionProgress scoreProgress = (SpongeScoreCriterionProgress)this.impl$progressMap.get(scoreCriterion.name());
            int lastScore = scoreProgress.score();
            int score = lastScore + 1;
            event = lastScore == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreRevoke((Cause)cause, (Advancement)advancement, (ResourceKey)key, (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (int)lastScore, (int)score) : (score == scoreCriterion.goal() ? SpongeEventFactory.createCriterionEventScoreGrant((Cause)cause, (Advancement)advancement, (ResourceKey)key, (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (Instant)Instant.now(), (int)lastScore, (int)score) : SpongeEventFactory.createCriterionEventScoreChange((Cause)cause, (Advancement)advancement, (ResourceKey)key, (ScoreAdvancementCriterion)scoreCriterion, (ServerPlayer)player, (int)lastScore, (int)score));
        } else {
            event = SpongeEventFactory.createCriterionEventRevoke((Cause)cause, (Advancement)advancement, (ResourceKey)key, (AdvancementCriterion)criterion, (ServerPlayer)player);
        }
        if (SpongeCommon.post((Event)event)) {
            return false;
        }
        criterionProgress.method_790();
        return true;
    }

    private Optional<Advancement> impl$getOptionalAdvancement() {
        Preconditions.checkState(PlatformHooks.INSTANCE.getGeneralHooks().onServerThread());
        Preconditions.checkState(this.impl$advancementKey != null, "The advancement is not yet initialized");
        class_8779 advancement = SpongeCommon.server().method_3851().method_12896(this.impl$advancementKey);
        return Optional.ofNullable(advancement).map(class_8779::comp_1920).map(Advancement.class::cast);
    }
}

