/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.commands;

import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_2165;
import net.minecraft.class_2168;
import net.minecraft.class_2183;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_7448;
import net.minecraft.class_7620;
import net.minecraft.class_8935;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.EventContext;
import org.spongepowered.api.event.EventContextKey;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.world.server.ServerLocation;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.accessor.commands.CommandSourceStackAccessor;
import org.spongepowered.common.accessor.world.entity.player.PlayerAccessor;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.service.server.permission.SpongePermissions;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.math.vector.Vector3d;

@Mixin(value={class_2168.class})
public abstract class CommandSourceStackMixin
implements CommandSourceStackBridge {
    @Shadow
    @Final
    private class_2165 field_9819;
    @Shadow
    @Final
    @Mutable
    private class_243 field_9817;
    @Shadow
    @Final
    @Mutable
    private class_241 field_9822;
    @Shadow
    @Final
    @Mutable
    private class_3218 field_9828;
    @Shadow
    @Final
    @Mutable
    private int field_9815;
    @Shadow
    @Final
    private class_2561 field_9825;
    @Shadow
    @Final
    private String field_9826;
    @Shadow
    @Final
    private @Nullable class_1297 field_9820;
    @Shadow
    @Final
    private MinecraftServer field_9818;
    @Shadow
    @Final
    private boolean field_9823;
    @Shadow
    @Final
    private class_8935 field_47159;
    @Shadow
    @Final
    private class_2183.class_2184 field_9816;
    @Shadow
    @Final
    private class_7448 field_39183;
    @Shadow
    @Final
    private class_7620 field_39834;
    private Cause impl$cause;
    private @Nullable Supplier<String> impl$potentialPermissionNode = null;

    @Inject(method={"<init>(Lnet/minecraft/class_2165;Lnet/minecraft/class_243;Lnet/minecraft/class_241;Lnet/minecraft/class_3218;ILjava/lang/String;Lnet/minecraft/class_2561;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_1297;ZLnet/minecraft/class_8935;Lnet/minecraft/class_2183$class_2184;Lnet/minecraft/class_7448;Lnet/minecraft/class_7620;)V"}, at={@At(value="RETURN")})
    private void impl$setCauseOnConstruction(class_2165 $$0, class_243 $$1, class_241 $$2, class_3218 $$3, int $$4, String $$5, class_2561 $$6, MinecraftServer $$7, class_1297 $$8, boolean $$9, class_8935 $$10, class_2183.class_2184 $$11, class_7448 $$12, class_7620 $$13, CallbackInfo ci) {
        this.impl$cause = PhaseTracker.getInstance().currentCause();
        EventContext context = this.impl$cause.context();
        context.get(EventContextKeys.LOCATION).ifPresent(x -> {
            this.field_9817 = VecHelper.toVanillaVector3d(x.position());
            this.field_9828 = (class_3218)x.world();
        });
        context.get(EventContextKeys.ROTATION).ifPresent(x -> {
            this.field_9822 = new class_241((float)x.x(), (float)x.y());
        });
        context.get(EventContextKeys.SUBJECT).ifPresent(x -> {
            MinecraftServer ms;
            if (x instanceof PlayerAccessor) {
                PlayerAccessor pa = (PlayerAccessor)x;
                this.field_9815 = pa.invoker$getPermissionLevel();
            } else if (x instanceof MinecraftServer && !(ms = (MinecraftServer)x).method_3724()) {
                this.field_9815 = 4;
            }
        });
    }

    @Inject(method={"method_9232(Lnet/minecraft/class_1297;)Lnet/minecraft/class_2168;", "method_9208(Lnet/minecraft/class_243;)Lnet/minecraft/class_2168;", "method_9216(Lnet/minecraft/class_241;)Lnet/minecraft/class_2168;", "method_9231(Lnet/minecraft/class_8935;)Lnet/minecraft/class_2168;", "method_9217()Lnet/minecraft/class_2168;", "method_9206(I)Lnet/minecraft/class_2168;", "method_9230(I)Lnet/minecraft/class_2168;", "method_9218(Lnet/minecraft/class_2183$class_2184;)Lnet/minecraft/class_2168;", "method_9227(Lnet/minecraft/class_3218;)Lnet/minecraft/class_2168;"}, at={@At(value="RETURN")})
    private void impl$copyPermissionOnCopy(CallbackInfoReturnable<class_2168> cir) {
        if (cir.getReturnValue() != this) {
            CommandSourceStackBridge commandSourceStackBridge = (CommandSourceStackBridge)cir.getReturnValue();
            commandSourceStackBridge.bridge$setPotentialPermissionNode(this.impl$potentialPermissionNode);
            commandSourceStackBridge.bridge$setCause(this.impl$cause);
        }
    }

    @Override
    public CommandCause bridge$withCurrentCause() {
        return (CommandCause)CommandSourceStackAccessor.invoker$new(this.field_9819, this.field_9817, this.field_9822, this.field_9828, this.field_9815, this.field_9826, this.field_9825, this.field_9818, this.field_9820, this.field_9823, this.field_47159, this.field_9816, this.field_39183, this.field_39834);
    }

    @Inject(method={"method_9227(Lnet/minecraft/class_3218;)Lnet/minecraft/class_2168;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithWorld(class_3218 serverWorld, CallbackInfoReturnable<class_2168> cir) {
        if (cir.getReturnValue() != this) {
            ServerLocation location = this.impl$cause.context().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)((ServerWorld)serverWorld), (Vector3d)x.position())).orElseGet(() -> ServerLocation.of((ServerWorld)((ServerWorld)serverWorld), (Vector3d)VecHelper.toVector3d(((class_2168)cir.getReturnValue()).method_9222())));
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"method_9208(Lnet/minecraft/class_243;)Lnet/minecraft/class_2168;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithPosition(class_243 pos, CallbackInfoReturnable<class_2168> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d position = VecHelper.toVector3d(pos);
            ServerLocation location = this.impl$cause.context().get(EventContextKeys.LOCATION).map(x -> ServerLocation.of((ServerWorld)((ServerWorld)x.world()), (Vector3d)position)).orElseGet(() -> ServerLocation.of((ServerWorld)((ServerWorld)((class_2168)cir.getReturnValue()).method_9225()), (Vector3d)position));
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.LOCATION, location));
        }
    }

    @Inject(method={"method_9216(Lnet/minecraft/class_241;)Lnet/minecraft/class_2168;"}, at={@At(value="RETURN")})
    private void impl$updateCauseOnWithRotation(class_241 rotation, CallbackInfoReturnable<class_2168> cir) {
        if (cir.getReturnValue() != this) {
            Vector3d rot = new Vector3d(rotation.field_1343, rotation.field_1342, 0.0f);
            ((CommandSourceStackBridge)cir.getReturnValue()).bridge$setCause(this.impl$applyToCause(EventContextKeys.ROTATION, rot));
        }
    }

    @Inject(method={"method_9259(I)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$checkPermission(int opLevel, CallbackInfoReturnable<Boolean> cir) {
        if (Sponge.isServerAvailable() && this.impl$potentialPermissionNode != null) {
            String perm = this.impl$potentialPermissionNode.get();
            SpongePermissions.registerPermission(perm, opLevel);
            cir.setReturnValue((Object)((CommandCause)this).hasPermission(perm));
        }
    }

    @Override
    public void bridge$setPotentialPermissionNode(@Nullable Supplier<String> permission) {
        this.impl$potentialPermissionNode = permission;
    }

    @Override
    public void bridge$setCause(Cause cause) {
        this.impl$cause = cause;
    }

    @Override
    public Cause bridge$getCause() {
        return this.impl$cause;
    }

    @Override
    public class_2165 bridge$getCommandSource() {
        return this.field_9819;
    }

    @Override
    public void bridge$updateFrameFromCommandSource(CauseStackManager.StackFrame frame) {
        ((CommandSourceBridge)this.field_9819).bridge$addToCauseStack(frame);
    }

    @Override
    public CommandCause bridge$asCommandCause() {
        return (CommandCause)this;
    }

    private <T> Cause impl$applyToCause(EventContextKey<T> key, T value) {
        EventContext.Builder builder = EventContext.builder();
        this.impl$cause.context().asMap().forEach((k, v) -> {
            if (!k.equals((Object)key)) {
                builder.add(k, v);
            }
        });
        builder.add(key, value);
        return Cause.builder().from(this.impl$cause).build(builder.build());
    }
}

