/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.commands.execution.tasks;

import com.mojang.brigadier.ResultConsumer;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_8865;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCause;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.manager.CommandMapping;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.EventContextKeys;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.bridge.commands.CommandSourceStackBridge;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.general.CommandPhaseContext;
import org.spongepowered.common.event.tracking.phase.general.GeneralPhase;

@Mixin(value={class_8865.class})
public abstract class ExecuteCommandMixin {
    @Shadow
    @Final
    private String field_46752;

    @Redirect(method={"method_54416(Lnet/minecraft/class_8839;Lnet/minecraft/class_8854;Lnet/minecraft/class_8937;)V"}, at=@At(value="INVOKE", target="Lcom/mojang/brigadier/context/ContextChain;runExecutable(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/Object;Lcom/mojang/brigadier/ResultConsumer;Z)I"))
    private <S> int impl$onRunExecutable(CommandContext<S> executable, S source, ResultConsumer<S> resultConsumer, boolean forkedMode) throws CommandSyntaxException {
        @Nullable class_3222 player = ((class_2168)source).method_44023();
        Cause cause = ((CommandSourceStackBridge)source).bridge$getCause();
        String originalRawCommand = cause.context().get(EventContextKeys.COMMAND).orElse(this.field_46752);
        String[] origSplitArg = originalRawCommand.split(" ", 2);
        String originalCommand = origSplitArg[0];
        String originalArgs = origSplitArg.length == 2 ? origSplitArg[1] : "";
        try (CauseStackManager.StackFrame frame = PhaseTracker.getInstance().pushCauseFrame();){
            CommandSourceStackBridge sourceBridge = (CommandSourceStackBridge)source;
            frame.addContext(EventContextKeys.COMMAND, (Object)this.field_46752);
            sourceBridge.bridge$updateFrameFromCommandSource(frame);
            CommandCause commandCause = sourceBridge.bridge$withCurrentCause();
            String[] splitArg = this.field_46752.split(" ", 2);
            String baseCommand = splitArg[0];
            String args = splitArg.length == 2 ? splitArg[1] : "";
            CommandMapping mapping = Sponge.server().commandManager().commandMapping(baseCommand).orElse(null);
            CommandPhaseContext context = ((CommandPhaseContext)GeneralPhase.State.COMMAND.createPhaseContext(PhaseTracker.getInstance()).source(source)).command(this.field_46752).commandMapping(mapping);
            try {
                if (player != null) {
                    context.creator(player.method_5667());
                    context.notifier(player.method_5667());
                }
                context.buildAndSwitch();
                int result = ContextChain.runExecutable((CommandContext)executable.copyFor((Object)commandCause), source, resultConsumer, (boolean)forkedMode);
                SpongeCommon.post((Event)SpongeEventFactory.createExecuteCommandEventPost((Cause)commandCause.cause(), (String)originalArgs, (String)args, (String)originalCommand, (String)baseCommand, (CommandCause)commandCause, (CommandResult)CommandResult.builder().result(result).build()));
                int n = result;
                if (context != null) {
                    context.close();
                }
                return n;
            }
            catch (Throwable result) {
                try {
                    if (context != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable) {
                            result.addSuppressed(throwable);
                        }
                    }
                    throw result;
                }
                catch (Exception e) {
                    String owner = Optional.ofNullable(mapping).flatMap(CommandMapping::plugin).map(pc -> pc.metadata().id()).orElse("UNKNOWN");
                    SpongeCommon.logger().error("Could not execute command '{}' from plugin '{}'", (Object)this.field_46752, (Object)owner, (Object)e);
                    throw e;
                }
            }
        }
    }
}

