/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.network;

import com.google.common.collect.Sets;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.local.LocalAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Queue;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2598;
import net.minecraft.class_7648;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.api.MinecraftVersion;
import org.spongepowered.api.ResourceKey;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeMinecraftVersion;
import org.spongepowered.common.bridge.network.ConnectionBridge;
import org.spongepowered.common.entity.player.ClientType;
import org.spongepowered.common.network.SpongeClientEngineConnection;
import org.spongepowered.common.network.SpongeEngineConnection;
import org.spongepowered.common.network.SpongePacketHolder;
import org.spongepowered.common.network.SpongeServerEngineConnection;
import org.spongepowered.common.network.channel.PacketSender;
import org.spongepowered.common.network.channel.TransactionStore;
import org.spongepowered.common.util.Constants;

@Mixin(value={class_2535.class})
public abstract class ConnectionMixin
extends SimpleChannelInboundHandler<class_2596<?>>
implements ConnectionBridge {
    @Shadow
    private class_2547 field_11652;
    @Shadow
    private Channel field_11651;
    @Shadow
    private boolean field_11646;
    @Shadow
    @Final
    private Queue<Consumer<class_2535>> field_45668;
    private TransactionStore impl$transactionStore;
    private final Set<ResourceKey> impl$registeredChannels = Sets.newConcurrentHashSet();
    private @Nullable InetSocketAddress impl$virtualHost;
    private @Nullable MinecraftVersion impl$version;
    private @Nullable class_2561 impl$kickReason;
    private ClientType impl$clientType = ClientType.VANILLA;
    private volatile boolean impl$disconnected;
    private SpongeEngineConnection impl$engineConnection;

    @Shadow
    public abstract SocketAddress method_10755();

    @Shadow
    public abstract boolean shadow$method_10758();

    @Override
    public TransactionStore bridge$getTransactionStore() {
        return this.impl$transactionStore;
    }

    @Override
    public Set<ResourceKey> bridge$getRegisteredChannels() {
        return this.impl$registeredChannels;
    }

    @Override
    public ClientType bridge$getClientType() {
        return this.impl$clientType;
    }

    @Override
    public void bridge$setClientType(ClientType clientType) {
        this.impl$clientType = clientType;
    }

    @Override
    public InetSocketAddress bridge$getAddress() {
        SocketAddress remoteAddress = this.method_10755();
        if (remoteAddress instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)remoteAddress;
    }

    @Override
    public InetSocketAddress bridge$getVirtualHost() {
        if (this.impl$virtualHost != null) {
            return this.impl$virtualHost;
        }
        SocketAddress local = this.field_11651.localAddress();
        if (local instanceof LocalAddress) {
            return Constants.Networking.LOCALHOST;
        }
        return (InetSocketAddress)local;
    }

    @Override
    public void bridge$setVirtualHost(String host, int port) {
        try {
            this.impl$virtualHost = new InetSocketAddress(InetAddress.getByAddress(host, ((InetSocketAddress)this.field_11651.localAddress()).getAddress().getAddress()), port);
        }
        catch (UnknownHostException e) {
            this.impl$virtualHost = InetSocketAddress.createUnresolved(host, port);
        }
    }

    @Override
    public @Nullable class_2561 bridge$getKickReason() {
        return this.impl$kickReason;
    }

    @Override
    public void bridge$setKickReason(class_2561 component) {
        this.impl$kickReason = component;
    }

    @Override
    public MinecraftVersion bridge$getVersion() {
        return this.impl$version;
    }

    @Override
    public void bridge$setVersion(int version) {
        this.impl$version = new SpongeMinecraftVersion(String.valueOf(version), version);
    }

    @Redirect(method={"method_52906(Lnet/minecraft/class_2596;Lnet/minecraft/class_7648;Z)V"}, at=@At(value="INVOKE", target="Ljava/util/Queue;add(Ljava/lang/Object;)Z"))
    private boolean impl$onQueue(Queue instance, final Object consumer, class_2596<?> $$0, @Nullable class_7648 $$1, boolean $$2) {
        boolean result;
        if (this.impl$disconnected) {
            if ($$1 instanceof PacketSender.SpongePacketSendListener) {
                PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$1;
                spongeListener.accept(new IOException("Connection has been closed."));
            }
            return false;
        }
        if ($$1 instanceof PacketSender.SpongePacketSendListener) {
            final PacketSender.SpongePacketSendListener spongeListener = (PacketSender.SpongePacketSendListener)$$1;
            result = instance.add(new SpongePacketHolder(){

                @Override
                public void apply(Throwable t) {
                    spongeListener.accept(t);
                }

                @Override
                public void accept(class_2535 connection) {
                    ((Consumer)consumer).accept(connection);
                }
            });
        } else {
            result = instance.add(consumer);
        }
        if (this.impl$disconnected) {
            this.impl$closePendingActions();
            return false;
        }
        return result;
    }

    private void impl$closePendingActions() {
        Consumer<class_2535> consumer;
        while ((consumer = this.field_45668.poll()) != null) {
            if (!(consumer instanceof SpongePacketHolder)) continue;
            SpongePacketHolder packetHolder = (SpongePacketHolder)consumer;
            packetHolder.apply(new IOException("Connection has been closed."));
        }
    }

    @Inject(method={"method_10768()V"}, at={@At(value="RETURN")})
    private void impl$onDisconnected(CallbackInfo ci) {
        if (!this.field_11646) {
            return;
        }
        this.impl$disconnected = true;
        this.impl$engineConnection.disconnected();
        this.impl$closePendingActions();
    }

    @Redirect(method={"method_60924(Lnet/minecraft/class_9812;)V"}, at=@At(value="INVOKE", target="Lio/netty/channel/ChannelFuture;awaitUninterruptibly()Lio/netty/channel/ChannelFuture;"))
    private ChannelFuture impl$disconnectAsync(ChannelFuture instance) {
        this.impl$disconnected = true;
        return instance;
    }

    @Inject(method={"method_10758()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$onIsConnected(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$disconnected) {
            cir.setReturnValue((Object)false);
        }
    }

    @Redirect(method={"exceptionCaught(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V", "method_10770(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/class_2596;)V", "method_10751()V", "method_10768()V"}, at=@At(value="INVOKE", target="Lio/netty/channel/Channel;isOpen()Z"))
    private boolean impl$onIsOpen(Channel instance) {
        return this.shadow$method_10758();
    }

    @Redirect(method={"method_10759(Lnet/minecraft/class_2596;Lnet/minecraft/class_2547;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2596;method_11054(Lnet/minecraft/class_2547;)V"))
    private static <T extends class_2547> void impl$logPacketError(class_2596<T> $$0, class_2547 $$1) {
        try {
            $$0.method_11054($$1);
        }
        catch (ExceptionInInitializerError e) {
            SpongeCommon.logger().error("Error handling packet " + String.valueOf($$0.getClass()), (Throwable)e);
            throw e;
        }
    }

    @Inject(method={"exceptionCaught(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2535;method_10747(Lnet/minecraft/class_2561;)V")})
    private void impl$onExceptionDisconnect(ChannelHandlerContext $$0, Throwable $$1, CallbackInfo ci) {
        SpongeCommon.logger().error("Disconnected due to error", $$1);
    }

    @Override
    public SpongeEngineConnection bridge$getEngineConnection() {
        return this.impl$engineConnection;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_2598;)V"}, at={@At(value="RETURN")})
    private void impl$onInit(class_2598 packetFlow, CallbackInfo ci) {
        if (packetFlow == class_2598.field_11942) {
            this.impl$engineConnection = new SpongeClientEngineConnection((class_2535)this);
        } else if (packetFlow == class_2598.field_11941) {
            this.impl$engineConnection = new SpongeServerEngineConnection((class_2535)this);
        }
        this.impl$transactionStore = new TransactionStore(this.impl$engineConnection);
    }
}

