/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.server;

import com.google.inject.Injector;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.minecraft.class_1255;
import net.minecraft.class_1267;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2991;
import net.minecraft.class_31;
import net.minecraft.class_32;
import net.minecraft.class_3218;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3312;
import net.minecraft.class_3324;
import net.minecraft.class_3902;
import net.minecraft.class_3949;
import net.minecraft.class_4014;
import net.minecraft.class_5217;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_7492;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.event.Cause;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.Event;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.world.LoadWorldEvent;
import org.spongepowered.api.event.world.UnloadWorldEvent;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.permission.SubjectProxy;
import org.spongepowered.api.world.DefaultWorldKeys;
import org.spongepowered.api.world.SerializationBehavior;
import org.spongepowered.api.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.spongepowered.common.SpongeCommon;
import org.spongepowered.common.SpongeServer;
import org.spongepowered.common.accessor.server.ServerFunctionManagerAccessor;
import org.spongepowered.common.bridge.commands.CommandSourceBridge;
import org.spongepowered.common.bridge.commands.CommandSourceProviderBridge;
import org.spongepowered.common.bridge.network.chat.SpongeChatDecorator;
import org.spongepowered.common.bridge.server.MinecraftServerBridge;
import org.spongepowered.common.bridge.server.level.ServerLevelBridge;
import org.spongepowered.common.bridge.server.players.GameProfileCacheBridge;
import org.spongepowered.common.bridge.world.level.storage.PrimaryLevelDataBridge;
import org.spongepowered.common.bridge.world.level.storage.ServerLevelDataBridge;
import org.spongepowered.common.config.SpongeGameConfigs;
import org.spongepowered.common.config.core.SpongeConfigs;
import org.spongepowered.common.config.inheritable.InheritableConfigHandle;
import org.spongepowered.common.config.inheritable.WorldConfig;
import org.spongepowered.common.datapack.SpongeDataPackManager;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.service.server.SpongeServerScopedServiceProvider;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin
implements SpongeServer,
MinecraftServerBridge,
CommandSourceProviderBridge,
SubjectProxy,
CommandSourceBridge {
    @Shadow
    @Final
    private Map<class_5321<class_1937>, class_3218> field_4589;
    @Shadow
    @Final
    private static Logger field_4546;
    @Shadow
    private int field_4572;
    @Shadow
    @Final
    protected class_32.class_5143 field_23784;
    @Shadow
    @Final
    private Thread field_16257;
    @Shadow
    @Final
    private class_2991 field_4591;
    @Shadow
    private volatile boolean field_35437;
    private final class_7492 impl$spongeDecorator = new SpongeChatDecorator();
    private @Nullable SpongeServerScopedServiceProvider impl$serviceProvider;
    protected @Nullable ResourcePackRequest impl$resourcePack;
    private final class_1255<Runnable> impl$spongeMainThreadExecutor = new class_1255<Runnable>("Sponge"){

        public Runnable method_16211(Runnable runnable) {
            return runnable;
        }

        protected boolean method_18856(@NonNull Runnable runnable) {
            return MinecraftServerMixin.this.shadow$method_3866();
        }

        protected @NonNull Thread method_3777() {
            return MinecraftServerMixin.this.field_16257;
        }
    };

    @Shadow
    public abstract class_2168 shadow$method_3739();

    @Shadow
    public abstract Iterable<class_3218> shadow$method_3738();

    @Shadow
    public abstract boolean shadow$method_3816();

    @Shadow
    public abstract boolean shadow$method_3806();

    @Shadow
    public abstract class_3324 shadow$method_3760();

    @Shadow
    public abstract class_3283 shadow$method_3836();

    @Shadow
    public abstract class_5455.class_6890 shadow$method_30611();

    @Shadow
    public abstract class_3312 shadow$method_3793();

    @Shadow
    public abstract CompletableFuture<Void> shadow$method_29439(Collection<String> var1);

    @Shadow
    public abstract class_5219 shadow$method_27728();

    @Shadow
    public abstract boolean shadow$method_3866();

    @Shadow
    public abstract class_3300 shadow$method_34864();

    public Subject subject() {
        return SpongeCommon.game().systemSubject();
    }

    @Inject(method={"method_29740(Ljava/util/function/Function;)Lnet/minecraft/server/MinecraftServer;"}, at={@At(value="TAIL")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void impl$setThreadOnServerPhaseTracker(Function<Thread, MinecraftServer> p_240784_0_, CallbackInfoReturnable<MinecraftServerMixin> cir, AtomicReference<MinecraftServer> atomicReference, Thread thread) {
        try {
            PhaseTracker.getServerInstanceExplicitly().setThread(thread);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not initialize the server PhaseTracker!");
        }
    }

    @Override
    public ResourcePackRequest bridge$getResourcePack() {
        return this.impl$resourcePack;
    }

    @Inject(method={"method_3748(Ljava/util/function/BooleanSupplier;)V"}, at={@At(value="HEAD")})
    private void impl$onServerTickStart(CallbackInfo ci) {
        this.scheduler().tick();
    }

    @Override
    public class_2168 bridge$getCommandSource(Cause cause) {
        return this.shadow$method_3739();
    }

    @Override
    public void bridge$addToCauseStack(CauseStackManager.StackFrame frame) {
        frame.pushCause((Object)Sponge.systemSubject());
    }

    @Inject(method={"method_3786(Lnet/minecraft/class_3949;)V"}, at={@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/class_3218;<init>(Lnet/minecraft/server/MinecraftServer;Ljava/util/concurrent/Executor;Lnet/minecraft/class_32$class_5143;Lnet/minecraft/class_5268;Lnet/minecraft/class_5321;Lnet/minecraft/class_5363;Lnet/minecraft/class_3949;ZJLjava/util/List;ZLnet/minecraft/class_8565;)V")})
    private void impl$onCreateDefaultLevel(CallbackInfo ci, @Local class_5268 levelData, @Local class_5363 levelStem) {
        ((PrimaryLevelDataBridge)levelData).bridge$populateFromLevelStem(levelStem);
        ((ServerLevelDataBridge)levelData).bridge$spongeData().setKey(DefaultWorldKeys.DEFAULT);
    }

    @Inject(method={"method_3786(Lnet/minecraft/class_3949;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_5268;method_222()Z")})
    private void impl$onInitDefaultLevel(CallbackInfo ci, @Local class_5268 levelData, @Local class_3218 level) {
        boolean initialized = levelData.method_222();
        LoadWorldEvent loadWorldEvent = SpongeEventFactory.createLoadWorldEvent((Cause)PhaseTracker.getInstance().currentCause(), (ServerWorld)((ServerWorld)level), (boolean)initialized);
        SpongeCommon.post((Event)loadWorldEvent);
    }

    @Redirect(method={"method_3786(Lnet/minecraft/class_3949;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_2378;method_29722()Ljava/util/Set;"))
    private Set<?> impl$onCreateOtherLevels(class_2378<?> stemRegistry) {
        this.worldManager().createNonDefaultLevels();
        return Set.of();
    }

    @WrapMethod(method={"method_27901(Lnet/minecraft/class_3218;Lnet/minecraft/class_5268;ZZ)V"})
    private static void impl$wrapSetInitialSpawn(class_3218 level, class_5268 levelData, boolean generateBonusChest, boolean debugWorld, Operation<Void> original) {
        try (GenericGenerationContext state = GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext(PhaseTracker.getInstance());){
            state.buildAndSwitch();
            original.call(new Object[]{level, levelData, generateBonusChest, debugWorld});
        }
    }

    @Overwrite
    private void method_3774(class_3949 progressListener) {
        this.worldManager().prepareLevels();
    }

    @Overwrite
    @DontObfuscate
    public String getServerModName() {
        return "sponge";
    }

    @Inject(method={"method_3782()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_3723(ZZZ)Z")})
    private void impl$callUnloadWorldEvents(CallbackInfo ci) {
        for (class_3218 level : this.shadow$method_3738()) {
            UnloadWorldEvent unloadWorldEvent = SpongeEventFactory.createUnloadWorldEvent((Cause)PhaseTracker.getInstance().currentCause(), (ServerWorld)((ServerWorld)level));
            SpongeCommon.post((Event)unloadWorldEvent);
        }
    }

    @Inject(method={"method_3782()V"}, at={@At(value="TAIL")})
    private void impl$closeLevelSaveForOtherWorlds(CallbackInfo ci) {
        for (Map.Entry<class_5321<class_1937>, class_3218> entry : this.field_4589.entrySet()) {
            if (entry.getKey() == class_1937.field_25179) continue;
            class_32.class_5143 levelSave = ((ServerLevelBridge)entry.getValue()).bridge$getLevelSave();
            try {
                levelSave.close();
            }
            catch (IOException e) {
                field_4546.error("Failed to unlock level {}", (Object)levelSave.method_27005(), (Object)e);
            }
        }
    }

    @Inject(method={"method_43496(Lnet/minecraft/class_2561;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$useTranslatingLogger(class_2561 input, CallbackInfo ci) {
        field_4546.info(input.getString());
        ci.cancel();
    }

    @ModifyConstant(method={"method_3748(Ljava/util/function/BooleanSupplier;)V"}, slice={@Slice(to=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;method_62734()V", ordinal=1), from=@At(value="FIELD", target="Lnet/minecraft/server/MinecraftServer;field_47135:I", ordinal=0))}, constant={@Constant(intValue=0, ordinal=0, expandZeroConditions={Constant.Condition.LESS_THAN_OR_EQUAL_TO_ZERO})})
    private int impl$getSaveTickInterval(int zero) {
        if (!this.shadow$method_3816()) {
            return zero;
        }
        if (!this.shadow$method_3806()) {
            return Integer.MIN_VALUE;
        }
        int autoPlayerSaveInterval = SpongeConfigs.getCommon().get().world.playerAutoSaveInterval;
        if (autoPlayerSaveInterval > 0 && this.field_4572 % autoPlayerSaveInterval == 0) {
            this.field_35437 = true;
            this.shadow$method_3760().method_14617();
            this.field_35437 = false;
        }
        this.field_35437 = true;
        this.method_3723(true, false, false);
        this.field_35437 = false;
        return Integer.MIN_VALUE;
    }

    @Overwrite
    public boolean method_3723(boolean suppressLog, boolean flush, boolean isForced) {
        boolean result = false;
        for (class_3218 level : this.shadow$method_3738()) {
            int autoSaveInterval;
            boolean canSaveAtAll;
            SerializationBehavior serializationBehavior = ((ServerLevelDataBridge)level.method_8401()).bridge$serializationBehavior().orElse(SerializationBehavior.AUTOMATIC);
            InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.getForWorld((class_1937)level);
            boolean log = ((WorldConfig)configAdapter.get()).world.logAutoSave;
            if (!this.shadow$method_3806() || this.field_4572 % 6000 == 0 || isForced) {
                configAdapter.save();
            }
            if (!(canSaveAtAll = serializationBehavior != SerializationBehavior.NONE) || this.bridge$performAutosaveChecks() && !isForced && ((autoSaveInterval = ((WorldConfig)configAdapter.get()).world.autoSaveInterval) <= 0 || serializationBehavior != SerializationBehavior.AUTOMATIC || this.field_4572 % autoSaveInterval != 0)) continue;
            if (log) {
                field_4546.info("Saving chunks for level '{}'/{}", (Object)level, (Object)level.method_27983().method_29177());
            }
            level.method_14176(null, flush, level.field_13957 && !isForced);
            result = true;
        }
        if (isForced || this.field_4572 % 6000 == 0) {
            class_3312 profileCache = this.shadow$method_3793();
            ((GameProfileCacheBridge)profileCache).bridge$setCanSave(true);
            profileCache.method_14518();
            ((GameProfileCacheBridge)profileCache).bridge$setCanSave(false);
        }
        if (flush) {
            for (class_3218 level : this.shadow$method_3738()) {
                InheritableConfigHandle<WorldConfig> configAdapter = SpongeGameConfigs.getForWorld((class_1937)level);
                boolean log = ((WorldConfig)configAdapter.get()).world.logAutoSave;
                if (!log) continue;
                field_4546.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)level.method_14178().field_17254.method_37476());
            }
            field_4546.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return result;
    }

    @Overwrite
    public void method_3776(class_1267 difficulty, boolean force) {
        for (class_3218 level : this.shadow$method_3738()) {
            class_5217 class_52172 = level.method_8401();
            if (!(class_52172 instanceof class_31)) continue;
            class_31 levelData = (class_31)class_52172;
            if (!force && levelData.method_197() || ((PrimaryLevelDataBridge)levelData).bridge$customDifficulty()) continue;
            ((PrimaryLevelDataBridge)levelData).bridge$forceSetDifficulty(difficulty);
        }
    }

    @Override
    public void bridge$initServices(Game game, Injector injector) {
        if (this.impl$serviceProvider == null) {
            this.impl$serviceProvider = new SpongeServerScopedServiceProvider(this, game, injector);
            this.impl$serviceProvider.init();
            class_156.method_43499(e -> class_4014.method_40087((class_3300)this.shadow$method_34864(), List.of(((ServerFunctionManagerAccessor)this.field_4591).accessor$library()), (Executor)class_156.method_18349(), (Executor)e, CompletableFuture.completedFuture(class_3902.field_17274), (boolean)field_4546.isDebugEnabled()).method_18364());
        }
    }

    @Override
    public SpongeServerScopedServiceProvider bridge$getServiceProvider() {
        return this.impl$serviceProvider;
    }

    @Inject(method={"method_29439(Ljava/util/Collection;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    public void impl$reloadResources(Collection<String> datapacksToLoad, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        List<String> reloadablePacks = ((SpongeDataPackManager)this.dataPackManager()).registerPacks();
        datapacksToLoad.addAll(reloadablePacks);
        this.shadow$method_3836().method_14445();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Inject(method={"method_43929()Lnet/minecraft/class_7492;"}, at={@At(value="RETURN")}, cancellable=true)
    private void impl$redirectChatDecorator(CallbackInfoReturnable<class_7492> cir) {
        if (cir.getReturnValue() == class_7492.field_39384) {
            cir.setReturnValue((Object)this.impl$spongeDecorator);
        }
    }

    @Override
    public class_1255<Runnable> bridge$spongeMainThreadExecutor() {
        return this.impl$spongeMainThreadExecutor;
    }

    @Inject(method={"method_20415()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void impl$pollSpongeTasks(CallbackInfoReturnable<Boolean> cir) {
        if (this.impl$spongeMainThreadExecutor.method_16075()) {
            cir.setReturnValue((Object)true);
        }
    }
}

